//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Data for filling the OpenDroneID System message. The System Message contains general system information including the operator location/altitude and possible aircraft group and/or category/class information.
type MessageOpenDroneIdSystem struct {
	// System ID (0 for broadcast).
	TargetSystem uint8
	// Component ID (0 for broadcast).
	TargetComponent uint8
	// Only used for drone ID data received from other UAs. See detailed description at https://mavlink.io/en/services/opendroneid.html.
	IdOrMac [20]uint8
	// Specifies the operator location type.
	OperatorLocationType MAV_ODID_OPERATOR_LOCATION_TYPE `mavenum:"uint8"`
	// Specifies the classification type of the UA.
	ClassificationType MAV_ODID_CLASSIFICATION_TYPE `mavenum:"uint8"`
	// Latitude of the operator. If unknown: 0 (both Lat/Lon).
	OperatorLatitude int32
	// Longitude of the operator. If unknown: 0 (both Lat/Lon).
	OperatorLongitude int32
	// Number of aircraft in the area, group or formation (default 1). Used only for swarms/multiple UA.
	AreaCount uint16
	// Radius of the cylindrical area of the group or formation (default 0). Used only for swarms/multiple UA.
	AreaRadius uint16
	// Area Operations Ceiling relative to WGS84. If unknown: -1000 m. Used only for swarms/multiple UA.
	AreaCeiling float32
	// Area Operations Floor relative to WGS84. If unknown: -1000 m. Used only for swarms/multiple UA.
	AreaFloor float32
	// When classification_type is MAV_ODID_CLASSIFICATION_TYPE_EU, specifies the category of the UA.
	CategoryEu MAV_ODID_CATEGORY_EU `mavenum:"uint8"`
	// When classification_type is MAV_ODID_CLASSIFICATION_TYPE_EU, specifies the class of the UA.
	ClassEu MAV_ODID_CLASS_EU `mavenum:"uint8"`
	// Geodetic altitude of the operator relative to WGS84. If unknown: -1000 m.
	OperatorAltitudeGeo float32
	// 32 bit Unix Timestamp in seconds since 00:00:00 01/01/2019.
	Timestamp uint32
}

// GetID implements the message.Message interface.
func (*MessageOpenDroneIdSystem) GetID() uint32 {
	return 12904
}
