/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.ucore;

import com.ubnt.model.api.ucore.UcoreInfoDto;
import com.ubnt.model.ucore.FullUcoreInfoDto;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowPrivilege;
import com.ubnt.net.v2.exception.InternalErrorException;
import com.ubnt.service.sdn.do;
import com.ubnt.service.system.W;
import com.ubnt.service.system.jA;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.springframework.web.bind.annotation.GetMapping;

@V2RestController
@Tag(name="UniFi Core Info")
public class UcoreInfoController {
    public static final Logger LOG = jA.\u00f4o0000;
    private final do \u00d300000;
    private final W o00000;
    private final com.ubnt.service.ucore.do \u00d200000;

    public UcoreInfoController(do do_, W w2, com.ubnt.service.ucore.do do_2) {
        this.\u00d300000 = do_;
        this.o00000 = w2;
        this.\u00d200000 = do_2;
    }

    @AllowPrivilege(value={"admin", "readonly"})
    @GetMapping(value={"/api/unifi-core/general-info"})
    @Operation(summary="Get UniFi Core general info")
    public UcoreInfoDto getUcoreInfo() {
        if (!this.o00000.\u00f4\u00d80000()) {
            LOG.debug("Calling API requests that is only for UniFi Core installation");
            return UcoreInfoDto.EMPTY;
        }
        return this.\u00d200000.\u00d3o\u00f6000().map(this::o00000).orElseThrow(UcoreInfoRequestFailed::new);
    }

    private UcoreInfoDto o00000(FullUcoreInfoDto fullUcoreInfoDto) {
        return UcoreInfoDto.builder().isCloudAccessEnabled(this.\u00d300000.thisclasssuper()).isCloudBackupEnabled(fullUcoreInfoDto.isBackupEnabled()).build();
    }

    static class UcoreInfoRequestFailed
    extends InternalErrorException {
        public UcoreInfoRequestFailed() {
            super("UcoreInfoRequestFailed", "Error while getting info from Unifi-Core");
        }
    }
}

