/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trafficrule.migrate;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mongodb.client.result.UpdateResult;
import com.ubnt.data.NetworkConf;
import com.ubnt.service.system.jA;
import com.ubnt.service.traffic.TrafficTargetDeviceDocumentPart;
import com.ubnt.service.trafficrule.TrafficRuleDocument;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@com.ubnt.service.system.db.migrator.A
class A {
    private static final Logger \u00d200000 = jA.Stringsuper;
    private static final String \u00d300000 = "app_ids";
    private static final String super = "app_category_ids";
    private final MongoTemplate \u00d400000;

    A(MongoTemplate mongoTemplate) {
        this.\u00d400000 = mongoTemplate;
    }

    boolean \u00f500000(String string) {
        Criteria criteria = Criteria.where((String)"site_id").is((Object)string);
        return this.\u00d400000.exists(new Query((CriteriaDefinition)criteria), TrafficRuleDocument.class);
    }

    void oo0000() {
        this.\u00d400000.updateMulti(new Query((CriteriaDefinition)new Criteria("domains").exists(false)), (UpdateDefinition)new Update().set("domains", Collections.emptyList()), "traffic_rule");
    }

    void \u00d5O0000() {
        this.\u00d400000.updateMulti(new Query((CriteriaDefinition)new Criteria("regions").exists(false)), (UpdateDefinition)new Update().set("regions", Collections.emptyList()), TrafficRuleDocument.class);
    }

    void Stringsuper() {
        this.\u00d400000.updateMulti(new Query((CriteriaDefinition)new Criteria("bandwidth_limit").exists(false)), (UpdateDefinition)new Update().set("bandwidth_limit", (Object)ImmutableMap.of((Object)"enabled", (Object)false, (Object)"download_limit_kbps", (Object)1024L, (Object)"upload_limit_kbps", (Object)1024L)), TrafficRuleDocument.class);
    }

    void \u00d300000() {
        this.\u00d400000.updateMulti(new Query((CriteriaDefinition)new Criteria("bandwidth_limit").exists(true)), (UpdateDefinition)new Update().set("bandwidth_limit", (Object)ImmutableMap.of((Object)"enabled", (Object)false, (Object)"download_limit_kbps", (Object)1024, (Object)"upload_limit_kbps", (Object)1024)), TrafficRuleDocument.class);
    }

    List<TrafficRuleDocument> \u00d800000(String string) {
        Criteria criteria = Criteria.where((String)"site_id").is((Object)string);
        return this.\u00d400000.find(Query.query((CriteriaDefinition)criteria), TrafficRuleDocument.class);
    }

    Set<String> \u00f400000(List<TrafficRuleDocument> list, List<NetworkConf> list2) {
        Set set = list2.stream().map(NetworkConf::getId).collect(Collectors.toSet());
        Set set2 = list.stream().map(this::\u00d400000).flatMap(Collection::stream).collect(Collectors.toSet());
        return Sets.difference(set2, set);
    }

    void if(List<TrafficRuleDocument> list, String string) {
        list.forEach(trafficRuleDocument -> this.Oo0000((TrafficRuleDocument)trafficRuleDocument, string));
    }

    public long \u00f5O0000(String string) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("enabled").is((Object)true).and("schedule").exists(true).and("schedule.mode").is((Object)"CUSTOM").and("schedule.date_start").exists(false));
        Update update = new Update().set("enabled", (Object)false);
        UpdateResult updateResult = this.\u00d400000.updateMulti(query, (UpdateDefinition)update, TrafficRuleDocument.class);
        return updateResult.getModifiedCount();
    }

    public long \u00f8O0000(String string, List<String> list) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("enabled").is((Object)true).and("id").in(list));
        Update update = new Update().set("enabled", (Object)false);
        UpdateResult updateResult = this.\u00d400000.updateMulti(query, (UpdateDefinition)update, TrafficRuleDocument.class);
        return updateResult.getModifiedCount();
    }

    private void Oo0000(TrafficRuleDocument trafficRuleDocument, String string) {
        List<String> list;
        List<TrafficTargetDeviceDocumentPart> list2 = this.\u00d500000(trafficRuleDocument, string);
        if (this.\u00d3O0000(trafficRuleDocument, list2, list = this.while(trafficRuleDocument, string))) {
            TrafficRuleDocument trafficRuleDocument2 = TrafficRuleDocument.from(trafficRuleDocument, this.\u00f4O0000(trafficRuleDocument, list2, list), list2, list);
            this.\u00d400000.save((Object)trafficRuleDocument2);
        }
    }

    private List<TrafficTargetDeviceDocumentPart> \u00d500000(TrafficRuleDocument trafficRuleDocument, String string) {
        return trafficRuleDocument.getTargetDevices().stream().filter(trafficTargetDeviceDocumentPart -> !StringUtils.equals((CharSequence)string, (CharSequence)trafficTargetDeviceDocumentPart.getNetworkId())).collect(Collectors.toList());
    }

    private List<String> while(TrafficRuleDocument trafficRuleDocument, String string) {
        return trafficRuleDocument.getNetworkIds().stream().filter(string2 -> !StringUtils.equals((CharSequence)string2, (CharSequence)string)).collect(Collectors.toList());
    }

    private boolean \u00d3O0000(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list, List<String> list2) {
        return list2.size() != trafficRuleDocument.getNetworkIds().size() || list.size() != trafficRuleDocument.getTargetDevices().size();
    }

    private boolean \u00f4O0000(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list, List<String> list2) {
        return trafficRuleDocument.isEnabled() && !this.\u00d8O0000(trafficRuleDocument, list2) && !this.thissuper(trafficRuleDocument, list);
    }

    private boolean \u00d8O0000(TrafficRuleDocument trafficRuleDocument, List<String> list) {
        return !trafficRuleDocument.getNetworkIds().isEmpty() && list.isEmpty();
    }

    private boolean thissuper(TrafficRuleDocument trafficRuleDocument, List<TrafficTargetDeviceDocumentPart> list) {
        return !trafficRuleDocument.getTargetDevices().isEmpty() && list.isEmpty();
    }

    private Set<String> \u00d400000(TrafficRuleDocument trafficRuleDocument) {
        Set set = trafficRuleDocument.getTargetDevices().stream().map(TrafficTargetDeviceDocumentPart::getNetworkId).filter(Objects::nonNull).collect(Collectors.toSet());
        return ImmutableSet.builder().addAll(set).addAll(trafficRuleDocument.getNetworkIds()).build();
    }

    void return(String string, TrafficRuleDocument trafficRuleDocument) {
        \u00d200000.info("Removing obsolete Traffic Rule {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        this.\u00d400000.remove(query, TrafficRuleDocument.class);
    }

    void OO0000(String string, TrafficRuleDocument trafficRuleDocument, List<Integer> list) {
        \u00d200000.info("Update Traffic Rule App Ids {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        Update update = new Update().set(\u00d300000, list);
        this.\u00d400000.updateMulti(query, (UpdateDefinition)update, TrafficRuleDocument.class);
    }

    public void \u00f800000(String string, TrafficRuleDocument trafficRuleDocument) {
        \u00d200000.info("Removing obsolete Applications and Categories from Traffic Rule {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        Update update = new Update().set(super, trafficRuleDocument.getAppCategoryIds()).set(\u00d300000, trafficRuleDocument.getAppIds());
        this.\u00d400000.updateFirst(query, (UpdateDefinition)update, TrafficRuleDocument.class);
    }

    public void oO0000(String string, TrafficRuleDocument trafficRuleDocument) {
        \u00d200000.info("Removing Applications till limit from Traffic Rule {}", (Object)trafficRuleDocument.getDescription());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"site_id").is((Object)string).and("_id").is((Object)new ObjectId(trafficRuleDocument.getId())));
        Update update = new Update().set(\u00d300000, trafficRuleDocument.getAppIds());
        this.\u00d400000.updateFirst(query, (UpdateDefinition)update, TrafficRuleDocument.class);
    }
}

