package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// CreatePoolReq 创建后端云服务器组的请求体
type CreatePoolReq struct {

	// 后端云服务器组的后端协议。取值：UDP、TCP、HTTP。当指定istener_id创建后端云服务器组时，后端云服务器组的protocol和它关联的监听器的protocol有如下关系：监听器的protocol为TCP时，后端云服务器组的protocol必须为TCP。监听器的protocol为UDP时，后端云服务器组的protocol必须为UDP。监听器的protocol为HTTP或TERMINATED_HTTPS时，后端云服务器组的protocol必须为HTTP。
	Protocol CreatePoolReqProtocol `json:"protocol"`

	// 后端云服务器组的负载均衡算法，取值：ROUND_ROBIN：加权轮询算法；LEAST_CONNECTIONS：加权最少连接算法；SOURCE_IP：源IP算法；当该字段的取值为SOURCE_IP时，后端云服务器组绑定的后端云服务器的weight字段无效。
	LbAlgorithm string `json:"lb_algorithm"`

	// 后端云服务器组关联的负载均衡器ID。listener_id和loadbalancer_id中至少指定一个。
	LoadbalancerId *string `json:"loadbalancer_id,omitempty"`

	// 后端云服务器组关联的监听器的ID。listener_id和loadbalancer_id中至少指定一个。
	ListenerId *string `json:"listener_id,omitempty"`

	// 后端云服务器组所在的项目ID。
	TenantId *string `json:"tenant_id,omitempty"`

	// 后端云服务器组的名称。
	Name *string `json:"name,omitempty"`

	// 后端云服务器组的描述信息
	Description *string `json:"description,omitempty"`

	// 后端云服务器组的管理状态。只支持设定为true，该字段的值无实际意义。
	AdminStateUp *bool `json:"admin_state_up,omitempty"`

	SessionPersistence *SessionPersistence `json:"session_persistence,omitempty"`

	// 修改保护状态, 取值： - nonProtection: 不保护，默认值为nonProtection - consoleProtection: 控制台修改保护
	ProtectionStatus *CreatePoolReqProtectionStatus `json:"protection_status,omitempty"`

	// 设置保护的原因 >仅当protection_status为consoleProtection时有效。
	ProtectionReason *string `json:"protection_reason,omitempty"`
}

func (o CreatePoolReq) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreatePoolReq struct{}"
	}

	return strings.Join([]string{"CreatePoolReq", string(data)}, " ")
}

type CreatePoolReqProtocol struct {
	value string
}

type CreatePoolReqProtocolEnum struct {
	UDP  CreatePoolReqProtocol
	TCP  CreatePoolReqProtocol
	HTTP CreatePoolReqProtocol
}

func GetCreatePoolReqProtocolEnum() CreatePoolReqProtocolEnum {
	return CreatePoolReqProtocolEnum{
		UDP: CreatePoolReqProtocol{
			value: "UDP",
		},
		TCP: CreatePoolReqProtocol{
			value: "TCP",
		},
		HTTP: CreatePoolReqProtocol{
			value: "HTTP",
		},
	}
}

func (c CreatePoolReqProtocol) Value() string {
	return c.value
}

func (c CreatePoolReqProtocol) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *CreatePoolReqProtocol) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}

type CreatePoolReqProtectionStatus struct {
	value string
}

type CreatePoolReqProtectionStatusEnum struct {
	NON_PROTECTION     CreatePoolReqProtectionStatus
	CONSOLE_PROTECTION CreatePoolReqProtectionStatus
}

func GetCreatePoolReqProtectionStatusEnum() CreatePoolReqProtectionStatusEnum {
	return CreatePoolReqProtectionStatusEnum{
		NON_PROTECTION: CreatePoolReqProtectionStatus{
			value: "nonProtection",
		},
		CONSOLE_PROTECTION: CreatePoolReqProtectionStatus{
			value: "consoleProtection",
		},
	}
}

func (c CreatePoolReqProtectionStatus) Value() string {
	return c.value
}

func (c CreatePoolReqProtectionStatus) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *CreatePoolReqProtectionStatus) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
