package model

import (
	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/sdktime"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"
	"strings"
)

type ApiGroupInfo struct {

	// 编号
	Id string `json:"id"`

	// API分组名称
	Name string `json:"name"`

	// 状态   - 1： 有效   - 2:  锁定
	Status ApiGroupInfoStatus `json:"status"`

	// 系统默认分配的子域名
	SlDomain string `json:"sl_domain"`

	// 创建时间
	RegisterTime *sdktime.SdkTime `json:"register_time"`

	// 最近修改时间
	UpdateTime *sdktime.SdkTime `json:"update_time"`

	// 是否已上架云市场： - 1：已上架 - 2：未上架 - 3：审核中  [ROMA Connect](tag:hws,hws_hk,hcs,hcs_sm,fcs,g42)[ROMA Site](tag:Site)暂未对接云市场，此字段默认返回2
	OnSellStatus int32 `json:"on_sell_status"`

	// 分组上绑定的独立域名列表
	UrlDomains *[]UrlDomain `json:"url_domains,omitempty"`

	// 系统默认分配的子域名列表
	SlDomains *[]string `json:"sl_domains,omitempty"`

	// 描述
	Remark *string `json:"remark,omitempty"`

	// 流控时长内分组下的API的总访问次数限制，默认不限，请根据服务的负载能力自行设置  暂不支持
	CallLimits *int32 `json:"call_limits,omitempty"`

	// 流控时长  暂不支持
	TimeInterval *int32 `json:"time_interval,omitempty"`

	// 流控的时间单位  暂不支持
	TimeUnit *string `json:"time_unit,omitempty"`

	// 是否为默认分组
	IsDefault *int32 `json:"is_default,omitempty"`

	// 分组版本  - V1：全局分组 - V2：应用级分组
	Version *string `json:"version,omitempty"`

	// 分组归属的集成应用编号。  分组版本V2时必填。
	RomaAppId *string `json:"roma_app_id,omitempty"`

	// 分组归属的集成应用名称
	RomaAppName *string `json:"roma_app_name,omitempty"`
}

func (o ApiGroupInfo) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ApiGroupInfo struct{}"
	}

	return strings.Join([]string{"ApiGroupInfo", string(data)}, " ")
}

type ApiGroupInfoStatus struct {
	value int32
}

type ApiGroupInfoStatusEnum struct {
	E_1 ApiGroupInfoStatus
	E_2 ApiGroupInfoStatus
}

func GetApiGroupInfoStatusEnum() ApiGroupInfoStatusEnum {
	return ApiGroupInfoStatusEnum{
		E_1: ApiGroupInfoStatus{
			value: 1,
		}, E_2: ApiGroupInfoStatus{
			value: 2,
		},
	}
}

func (c ApiGroupInfoStatus) Value() int32 {
	return c.value
}

func (c ApiGroupInfoStatus) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *ApiGroupInfoStatus) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("int32")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: int32")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(int32); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to int32 error")
	}
}
