# Go API client for data_streaming

The Data Streaming API allows you to manage your existing data streamings and templates.
Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time.


## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import data_streaming "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), data_streaming.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), data_streaming.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```golang
ctx := context.WithValue(context.Background(), data_streaming.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), data_streaming.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *https://api.azionapi.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataStreamingAPI* | [**CreateNewDataStreaming**](docs/DataStreamingAPI.md#createnewdatastreaming) | **Post** /data_streaming/streamings | Create a new data streaming
*DataStreamingAPI* | [**DeleteDataStreamingById**](docs/DataStreamingAPI.md#deletedatastreamingbyid) | **Delete** /data_streaming/streamings/{data_streaming_id} | Delete data streaming
*DataStreamingAPI* | [**EditDataStreamingById**](docs/DataStreamingAPI.md#editdatastreamingbyid) | **Patch** /data_streaming/streamings/{data_streaming_id} | Edit data streaming
*DataStreamingAPI* | [**ListDataStreamingById**](docs/DataStreamingAPI.md#listdatastreamingbyid) | **Get** /data_streaming/streamings/{data_streaming_id} | Get expecific data streaming by Data Streaming ID
*DataStreamingAPI* | [**ListDataStreamings**](docs/DataStreamingAPI.md#listdatastreamings) | **Get** /data_streaming/streamings | List all exist data streamings
*DataStreamingAPI* | [**OverwriteDataStreamingById**](docs/DataStreamingAPI.md#overwritedatastreamingbyid) | **Put** /data_streaming/streamings/{data_streaming_id} | Overwrite data streaming
*DataStreamingDomainAPI* | [**ListDataStreaming**](docs/DataStreamingDomainAPI.md#listdatastreaming) | **Get** /data_streaming/domains | List all domains used on data streaming
*DataStreamingTemplatesAPI* | [**GetDataStramingTemplateById**](docs/DataStreamingTemplatesAPI.md#getdatastramingtemplatebyid) | **Get** /data_streaming/templates/{template_id} | Get an global Template info by template ID
*DataStreamingTemplatesAPI* | [**ListDataStreamingTemplates**](docs/DataStreamingTemplatesAPI.md#listdatastreamingtemplates) | **Get** /data_streaming/templates | List all global Templates that can be used on Data Streaming operations


## Documentation For Models

 - [CreateCustomDataStreamingResponse](docs/CreateCustomDataStreamingResponse.md)
 - [CreateDataStreamingResponse](docs/CreateDataStreamingResponse.md)
 - [CreateNewDataStreaming201Response](docs/CreateNewDataStreaming201Response.md)
 - [CreateNewDataStreamingRequest](docs/CreateNewDataStreamingRequest.md)
 - [CustomDataStreamingPostBody](docs/CustomDataStreamingPostBody.md)
 - [DataStreamingEndpointTypeDatadogDTS](docs/DataStreamingEndpointTypeDatadogDTS.md)
 - [DataStreamingEndpointTypeKafka](docs/DataStreamingEndpointTypeKafka.md)
 - [DataStreamingEndpointTypeStandard](docs/DataStreamingEndpointTypeStandard.md)
 - [DataStreamingEndpointTypeStandardHeadersExample](docs/DataStreamingEndpointTypeStandardHeadersExample.md)
 - [DataStreamingPostBody](docs/DataStreamingPostBody.md)
 - [DataStreamingResponseGetResultTypeCustom](docs/DataStreamingResponseGetResultTypeCustom.md)
 - [DataStreamingResponseGetResultTypeDatadogDTS](docs/DataStreamingResponseGetResultTypeDatadogDTS.md)
 - [DataStreamingResponseGetResultTypeKafka](docs/DataStreamingResponseGetResultTypeKafka.md)
 - [DataStreamingResponseGetResultTypeStandard](docs/DataStreamingResponseGetResultTypeStandard.md)
 - [DataStreamingResponseWithResults](docs/DataStreamingResponseWithResults.md)
 - [DataStreamingResponseWithResultsResultsInner](docs/DataStreamingResponseWithResultsResultsInner.md)
 - [DataStreamingsById](docs/DataStreamingsById.md)
 - [DataStreamingsDomainResponse](docs/DataStreamingsDomainResponse.md)
 - [DataStreamingsDomainResponseLinks](docs/DataStreamingsDomainResponseLinks.md)
 - [DataStreamingsDomainResult](docs/DataStreamingsDomainResult.md)
 - [EndpoinrtS3](docs/EndpoinrtS3.md)
 - [EndpointAWSKinesisFirehose](docs/EndpointAWSKinesisFirehose.md)
 - [EndpointAzureBlobStorage](docs/EndpointAzureBlobStorage.md)
 - [EndpointAzureMonitor](docs/EndpointAzureMonitor.md)
 - [EndpointDatadog](docs/EndpointDatadog.md)
 - [EndpointDefault](docs/EndpointDefault.md)
 - [EndpointElasticsearch](docs/EndpointElasticsearch.md)
 - [EndpointGoogleBigQuery](docs/EndpointGoogleBigQuery.md)
 - [EndpointGoogleBigQueryServiceAccountKey](docs/EndpointGoogleBigQueryServiceAccountKey.md)
 - [EndpointIBMQRadar](docs/EndpointIBMQRadar.md)
 - [EndpointKafka](docs/EndpointKafka.md)
 - [EndpointSplunk](docs/EndpointSplunk.md)
 - [PostCustomDataStreamingResponse](docs/PostCustomDataStreamingResponse.md)
 - [PostDataStreamingResponse](docs/PostDataStreamingResponse.md)
 - [PostDataStreamingResponseEndpointInner](docs/PostDataStreamingResponseEndpointInner.md)
 - [StandardDataStreamingPostBody](docs/StandardDataStreamingPostBody.md)
 - [Template](docs/Template.md)
 - [TemplateResultById](docs/TemplateResultById.md)
 - [TemplateResults](docs/TemplateResults.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: Authorization and passed in as the auth context for each request.

Example

```golang
auth := context.WithValue(
		context.Background(),
		sw.ContextAPIKeys,
		map[string]sw.APIKey{
			"Authorization": {Key: "API_KEY_STRING"},
		},
	)
r, err := client.Service.Operation(auth, args)
```


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



