// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/phishingprotection/v1beta1/phishingprotection.proto

package phishingprotectionpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PhishingProtectionServiceV1Beta1_ReportPhishing_FullMethodName = "/google.cloud.phishingprotection.v1beta1.PhishingProtectionServiceV1Beta1/ReportPhishing"
)

// PhishingProtectionServiceV1Beta1Client is the client API for PhishingProtectionServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PhishingProtectionServiceV1Beta1Client interface {
	// Reports a URI suspected of containing phishing content to be reviewed. Once
	// the report review is complete, its result can be found in the Cloud
	// Security Command Center findings dashboard for Phishing Protection. If the
	// result verifies the existence of malicious phishing content, the site will
	// be added the to [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future.
	ReportPhishing(ctx context.Context, in *ReportPhishingRequest, opts ...grpc.CallOption) (*ReportPhishingResponse, error)
}

type phishingProtectionServiceV1Beta1Client struct {
	cc grpc.ClientConnInterface
}

func NewPhishingProtectionServiceV1Beta1Client(cc grpc.ClientConnInterface) PhishingProtectionServiceV1Beta1Client {
	return &phishingProtectionServiceV1Beta1Client{cc}
}

func (c *phishingProtectionServiceV1Beta1Client) ReportPhishing(ctx context.Context, in *ReportPhishingRequest, opts ...grpc.CallOption) (*ReportPhishingResponse, error) {
	out := new(ReportPhishingResponse)
	err := c.cc.Invoke(ctx, PhishingProtectionServiceV1Beta1_ReportPhishing_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PhishingProtectionServiceV1Beta1Server is the server API for PhishingProtectionServiceV1Beta1 service.
// All implementations should embed UnimplementedPhishingProtectionServiceV1Beta1Server
// for forward compatibility
type PhishingProtectionServiceV1Beta1Server interface {
	// Reports a URI suspected of containing phishing content to be reviewed. Once
	// the report review is complete, its result can be found in the Cloud
	// Security Command Center findings dashboard for Phishing Protection. If the
	// result verifies the existence of malicious phishing content, the site will
	// be added the to [Google's Social Engineering
	// lists](https://support.google.com/webmasters/answer/6350487/) in order to
	// protect users that could get exposed to this threat in the future.
	ReportPhishing(context.Context, *ReportPhishingRequest) (*ReportPhishingResponse, error)
}

// UnimplementedPhishingProtectionServiceV1Beta1Server should be embedded to have forward compatible implementations.
type UnimplementedPhishingProtectionServiceV1Beta1Server struct {
}

func (UnimplementedPhishingProtectionServiceV1Beta1Server) ReportPhishing(context.Context, *ReportPhishingRequest) (*ReportPhishingResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportPhishing not implemented")
}

// UnsafePhishingProtectionServiceV1Beta1Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PhishingProtectionServiceV1Beta1Server will
// result in compilation errors.
type UnsafePhishingProtectionServiceV1Beta1Server interface {
	mustEmbedUnimplementedPhishingProtectionServiceV1Beta1Server()
}

func RegisterPhishingProtectionServiceV1Beta1Server(s grpc.ServiceRegistrar, srv PhishingProtectionServiceV1Beta1Server) {
	s.RegisterService(&PhishingProtectionServiceV1Beta1_ServiceDesc, srv)
}

func _PhishingProtectionServiceV1Beta1_ReportPhishing_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportPhishingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PhishingProtectionServiceV1Beta1Server).ReportPhishing(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PhishingProtectionServiceV1Beta1_ReportPhishing_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PhishingProtectionServiceV1Beta1Server).ReportPhishing(ctx, req.(*ReportPhishingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PhishingProtectionServiceV1Beta1_ServiceDesc is the grpc.ServiceDesc for PhishingProtectionServiceV1Beta1 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PhishingProtectionServiceV1Beta1_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.phishingprotection.v1beta1.PhishingProtectionServiceV1Beta1",
	HandlerType: (*PhishingProtectionServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ReportPhishing",
			Handler:    _PhishingProtectionServiceV1Beta1_ReportPhishing_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/phishingprotection/v1beta1/phishingprotection.proto",
}
