package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// HandleImageVulnerabilityRequestBody 处置镜像漏洞的请求信息
type HandleImageVulnerabilityRequestBody struct {

	// **参数解释**: 镜像类型 **约束限制**: 不涉及 **取值范围**: - local：本地镜像 - registry：仓库镜像 - cicd：cicd镜像  **默认取值**: 不涉及
	ImageType string `json:"image_type"`

	// **参数解释**: 漏洞类型 **约束限制**: 不涉及 **取值范围**: - linux_vul：Linux系统漏洞 - app_vul：应用漏洞  **默认取值**: 不涉及
	Type string `json:"type"`

	// **参数解释**: 对漏洞做的处置动作 **约束限制**: 不涉及 **取值范围**: - ignore：忽略 - not_ignore：取消忽略 - manual_repair：人工修复 - add_to_whitelist：加白  **默认取值**: 不涉及
	OperateType string `json:"operate_type"`

	// **参数解释**: 需要处置的漏洞状态 **约束限制**: 不涉及 **取值范围**: - unhandled：待处理的漏洞 - handled：已处理的漏洞  **默认取值**: 不涉及
	HandleStatus *string `json:"handle_status,omitempty"`

	// **参数解释**: 处置漏洞范围的类型 **约束限制**: 不涉及 **取值范围**: - all_vul：处置所有漏洞 - specific_image_all_vul：处置指定镜像的所有漏洞 - specific_vul_all_image：处置指定漏洞的全部镜像 - vul_view：通过漏洞维度指定需要处置的漏洞和镜像信息 - image_view：通过镜像维度指定需要处置的漏洞和镜像信息  **默认取值**: 不涉及
	SelectType string `json:"select_type"`

	// **参数解释**: select_type值为specific_image_all_vul时，该字段用于指定需要处置的镜像id列表 **约束限制**: 仅在select_type值为specific_image_all_vul时该字段有效 **取值范围**: 不涉及 **默认取值**: 不涉及
	ImageIdList *[]string `json:"image_id_list,omitempty"`

	// **参数解释**: select_type值为specific_vul_all_image时，该字段用于指定需要处置的漏洞id列表 **约束限制**: 仅在select_type值为specific_vul_all_image时该字段有效 **取值范围**: 不涉及 **默认取值**: 不涉及
	VulIdList *[]string `json:"vul_id_list,omitempty"`

	// **参数解释**: select_type值为vul_view时，该字段用于指定需要处置的漏洞和镜像信息 **约束限制**: 仅在select_type值为vul_view时该字段有效 **取值范围**: 不涉及 **默认取值**: 不涉及
	VulDataList *[]HandleImageVulnerabilityRequestBodyVulDataList `json:"vul_data_list,omitempty"`

	// **参数解释**: select_type值为image_view时，该字段用于指定需要处置的漏洞和镜像信息 **约束限制**: 仅在select_type值为image_view时该字段有效 **取值范围**: 不涉及 **默认取值**: 不涉及
	ImageDataList *[]HandleImageVulnerabilityRequestBodyImageDataList `json:"image_data_list,omitempty"`

	// **参数解释**: 处置操作的描述信息 **约束限制**: 不涉及 **取值范围**: 字符长度0-512位 **默认取值**: 不涉及
	Remark *string `json:"remark,omitempty"`
}

func (o HandleImageVulnerabilityRequestBody) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "HandleImageVulnerabilityRequestBody struct{}"
	}

	return strings.Join([]string{"HandleImageVulnerabilityRequestBody", string(data)}, " ")
}
