// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewArrayValue()
				CopyArrayValue(dest, src)
				assert.Equal(t, src, dest)
				CopyArrayValue(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyArrayValueSlice(t *testing.T) {
	src := []ArrayValue{}
	dest := []ArrayValue{}
	// Test CopyTo empty
	dest = CopyArrayValueSlice(dest, src)
	assert.Equal(t, []ArrayValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestArrayValueSlice()
	dest = CopyArrayValueSlice(dest, src)
	assert.Equal(t, GenTestArrayValueSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyArrayValueSlice(dest, src)
	assert.Equal(t, GenTestArrayValueSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyArrayValueSlice(dest, []ArrayValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyArrayValueSlice(dest, src)
	assert.Equal(t, GenTestArrayValueSlice(), dest)
}

func TestCopyArrayValuePtrSlice(t *testing.T) {
	src := []*ArrayValue{}
	dest := []*ArrayValue{}
	// Test CopyTo empty
	dest = CopyArrayValuePtrSlice(dest, src)
	assert.Equal(t, []*ArrayValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestArrayValuePtrSlice()
	dest = CopyArrayValuePtrSlice(dest, src)
	assert.Equal(t, GenTestArrayValuePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyArrayValuePtrSlice(dest, src)
	assert.Equal(t, GenTestArrayValuePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyArrayValuePtrSlice(dest, []*ArrayValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyArrayValuePtrSlice(dest, src)
	assert.Equal(t, GenTestArrayValuePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONArrayValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewArrayValue()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewArrayValue(), dest)
}

func TestMarshalAndUnmarshalJSONArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewArrayValue()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteArrayValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoArrayValueFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesArrayValue() {
		t.Run(name, func(t *testing.T) {
			dest := NewArrayValue()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoArrayValueUnknown(t *testing.T) {
	dest := NewArrayValue()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewArrayValue(), dest)
}

func TestMarshalAndUnmarshalProtoArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewArrayValue()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteArrayValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufArrayValue(t *testing.T) {
	for name, src := range genTestEncodingValuesArrayValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.ArrayValue{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewArrayValue()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesArrayValue() map[string][]byte {
	return map[string][]byte{
		"invalid_field":          {0x02},
		"Values/wrong_wire_type": {0xc},
		"Values/missing_value":   {0xa},
	}
}

func genTestEncodingValuesArrayValue() map[string]*ArrayValue {
	return map[string]*ArrayValue{
		"empty":       NewArrayValue(),
		"Values/test": {Values: []AnyValue{{}, *GenTestAnyValue()}},
	}
}
