// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/tpu/v1/cloud_tpu.proto

package tpupb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Tpu_ListNodes_FullMethodName              = "/google.cloud.tpu.v1.Tpu/ListNodes"
	Tpu_GetNode_FullMethodName                = "/google.cloud.tpu.v1.Tpu/GetNode"
	Tpu_CreateNode_FullMethodName             = "/google.cloud.tpu.v1.Tpu/CreateNode"
	Tpu_DeleteNode_FullMethodName             = "/google.cloud.tpu.v1.Tpu/DeleteNode"
	Tpu_ReimageNode_FullMethodName            = "/google.cloud.tpu.v1.Tpu/ReimageNode"
	Tpu_StopNode_FullMethodName               = "/google.cloud.tpu.v1.Tpu/StopNode"
	Tpu_StartNode_FullMethodName              = "/google.cloud.tpu.v1.Tpu/StartNode"
	Tpu_ListTensorFlowVersions_FullMethodName = "/google.cloud.tpu.v1.Tpu/ListTensorFlowVersions"
	Tpu_GetTensorFlowVersion_FullMethodName   = "/google.cloud.tpu.v1.Tpu/GetTensorFlowVersion"
	Tpu_ListAcceleratorTypes_FullMethodName   = "/google.cloud.tpu.v1.Tpu/ListAcceleratorTypes"
	Tpu_GetAcceleratorType_FullMethodName     = "/google.cloud.tpu.v1.Tpu/GetAcceleratorType"
)

// TpuClient is the client API for Tpu service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type TpuClient interface {
	// Lists nodes.
	ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error)
	// Gets the details of a node.
	GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error)
	// Creates a node.
	CreateNode(ctx context.Context, in *CreateNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a node.
	DeleteNode(ctx context.Context, in *DeleteNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Reimages a node's OS.
	ReimageNode(ctx context.Context, in *ReimageNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a node, this operation is only available with single TPU nodes.
	StopNode(ctx context.Context, in *StopNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts a node.
	StartNode(ctx context.Context, in *StartNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List TensorFlow versions supported by this API.
	ListTensorFlowVersions(ctx context.Context, in *ListTensorFlowVersionsRequest, opts ...grpc.CallOption) (*ListTensorFlowVersionsResponse, error)
	// Gets TensorFlow Version.
	GetTensorFlowVersion(ctx context.Context, in *GetTensorFlowVersionRequest, opts ...grpc.CallOption) (*TensorFlowVersion, error)
	// Lists accelerator types supported by this API.
	ListAcceleratorTypes(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*ListAcceleratorTypesResponse, error)
	// Gets AcceleratorType.
	GetAcceleratorType(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error)
}

type tpuClient struct {
	cc grpc.ClientConnInterface
}

func NewTpuClient(cc grpc.ClientConnInterface) TpuClient {
	return &tpuClient{cc}
}

func (c *tpuClient) ListNodes(ctx context.Context, in *ListNodesRequest, opts ...grpc.CallOption) (*ListNodesResponse, error) {
	out := new(ListNodesResponse)
	err := c.cc.Invoke(ctx, Tpu_ListNodes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetNode(ctx context.Context, in *GetNodeRequest, opts ...grpc.CallOption) (*Node, error) {
	out := new(Node)
	err := c.cc.Invoke(ctx, Tpu_GetNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) CreateNode(ctx context.Context, in *CreateNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tpu_CreateNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) DeleteNode(ctx context.Context, in *DeleteNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tpu_DeleteNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ReimageNode(ctx context.Context, in *ReimageNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tpu_ReimageNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) StopNode(ctx context.Context, in *StopNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tpu_StopNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) StartNode(ctx context.Context, in *StartNodeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Tpu_StartNode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ListTensorFlowVersions(ctx context.Context, in *ListTensorFlowVersionsRequest, opts ...grpc.CallOption) (*ListTensorFlowVersionsResponse, error) {
	out := new(ListTensorFlowVersionsResponse)
	err := c.cc.Invoke(ctx, Tpu_ListTensorFlowVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetTensorFlowVersion(ctx context.Context, in *GetTensorFlowVersionRequest, opts ...grpc.CallOption) (*TensorFlowVersion, error) {
	out := new(TensorFlowVersion)
	err := c.cc.Invoke(ctx, Tpu_GetTensorFlowVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) ListAcceleratorTypes(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*ListAcceleratorTypesResponse, error) {
	out := new(ListAcceleratorTypesResponse)
	err := c.cc.Invoke(ctx, Tpu_ListAcceleratorTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *tpuClient) GetAcceleratorType(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error) {
	out := new(AcceleratorType)
	err := c.cc.Invoke(ctx, Tpu_GetAcceleratorType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TpuServer is the server API for Tpu service.
// All implementations should embed UnimplementedTpuServer
// for forward compatibility
type TpuServer interface {
	// Lists nodes.
	ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error)
	// Gets the details of a node.
	GetNode(context.Context, *GetNodeRequest) (*Node, error)
	// Creates a node.
	CreateNode(context.Context, *CreateNodeRequest) (*longrunningpb.Operation, error)
	// Deletes a node.
	DeleteNode(context.Context, *DeleteNodeRequest) (*longrunningpb.Operation, error)
	// Reimages a node's OS.
	ReimageNode(context.Context, *ReimageNodeRequest) (*longrunningpb.Operation, error)
	// Stops a node, this operation is only available with single TPU nodes.
	StopNode(context.Context, *StopNodeRequest) (*longrunningpb.Operation, error)
	// Starts a node.
	StartNode(context.Context, *StartNodeRequest) (*longrunningpb.Operation, error)
	// List TensorFlow versions supported by this API.
	ListTensorFlowVersions(context.Context, *ListTensorFlowVersionsRequest) (*ListTensorFlowVersionsResponse, error)
	// Gets TensorFlow Version.
	GetTensorFlowVersion(context.Context, *GetTensorFlowVersionRequest) (*TensorFlowVersion, error)
	// Lists accelerator types supported by this API.
	ListAcceleratorTypes(context.Context, *ListAcceleratorTypesRequest) (*ListAcceleratorTypesResponse, error)
	// Gets AcceleratorType.
	GetAcceleratorType(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error)
}

// UnimplementedTpuServer should be embedded to have forward compatible implementations.
type UnimplementedTpuServer struct {
}

func (UnimplementedTpuServer) ListNodes(context.Context, *ListNodesRequest) (*ListNodesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodes not implemented")
}
func (UnimplementedTpuServer) GetNode(context.Context, *GetNodeRequest) (*Node, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNode not implemented")
}
func (UnimplementedTpuServer) CreateNode(context.Context, *CreateNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNode not implemented")
}
func (UnimplementedTpuServer) DeleteNode(context.Context, *DeleteNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNode not implemented")
}
func (UnimplementedTpuServer) ReimageNode(context.Context, *ReimageNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReimageNode not implemented")
}
func (UnimplementedTpuServer) StopNode(context.Context, *StopNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopNode not implemented")
}
func (UnimplementedTpuServer) StartNode(context.Context, *StartNodeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNode not implemented")
}
func (UnimplementedTpuServer) ListTensorFlowVersions(context.Context, *ListTensorFlowVersionsRequest) (*ListTensorFlowVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTensorFlowVersions not implemented")
}
func (UnimplementedTpuServer) GetTensorFlowVersion(context.Context, *GetTensorFlowVersionRequest) (*TensorFlowVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTensorFlowVersion not implemented")
}
func (UnimplementedTpuServer) ListAcceleratorTypes(context.Context, *ListAcceleratorTypesRequest) (*ListAcceleratorTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAcceleratorTypes not implemented")
}
func (UnimplementedTpuServer) GetAcceleratorType(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAcceleratorType not implemented")
}

// UnsafeTpuServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to TpuServer will
// result in compilation errors.
type UnsafeTpuServer interface {
	mustEmbedUnimplementedTpuServer()
}

func RegisterTpuServer(s grpc.ServiceRegistrar, srv TpuServer) {
	s.RegisterService(&Tpu_ServiceDesc, srv)
}

func _Tpu_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_ListNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListNodes(ctx, req.(*ListNodesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_GetNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetNode(ctx, req.(*GetNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_CreateNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).CreateNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_CreateNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).CreateNode(ctx, req.(*CreateNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_DeleteNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).DeleteNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_DeleteNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).DeleteNode(ctx, req.(*DeleteNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ReimageNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReimageNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ReimageNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_ReimageNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ReimageNode(ctx, req.(*ReimageNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_StopNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).StopNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_StopNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).StopNode(ctx, req.(*StopNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_StartNode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).StartNode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_StartNode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).StartNode(ctx, req.(*StartNodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ListTensorFlowVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTensorFlowVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListTensorFlowVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_ListTensorFlowVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListTensorFlowVersions(ctx, req.(*ListTensorFlowVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetTensorFlowVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTensorFlowVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetTensorFlowVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_GetTensorFlowVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetTensorFlowVersion(ctx, req.(*GetTensorFlowVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_ListAcceleratorTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAcceleratorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).ListAcceleratorTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_ListAcceleratorTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).ListAcceleratorTypes(ctx, req.(*ListAcceleratorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Tpu_GetAcceleratorType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAcceleratorTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TpuServer).GetAcceleratorType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Tpu_GetAcceleratorType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TpuServer).GetAcceleratorType(ctx, req.(*GetAcceleratorTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Tpu_ServiceDesc is the grpc.ServiceDesc for Tpu service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Tpu_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.tpu.v1.Tpu",
	HandlerType: (*TpuServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListNodes",
			Handler:    _Tpu_ListNodes_Handler,
		},
		{
			MethodName: "GetNode",
			Handler:    _Tpu_GetNode_Handler,
		},
		{
			MethodName: "CreateNode",
			Handler:    _Tpu_CreateNode_Handler,
		},
		{
			MethodName: "DeleteNode",
			Handler:    _Tpu_DeleteNode_Handler,
		},
		{
			MethodName: "ReimageNode",
			Handler:    _Tpu_ReimageNode_Handler,
		},
		{
			MethodName: "StopNode",
			Handler:    _Tpu_StopNode_Handler,
		},
		{
			MethodName: "StartNode",
			Handler:    _Tpu_StartNode_Handler,
		},
		{
			MethodName: "ListTensorFlowVersions",
			Handler:    _Tpu_ListTensorFlowVersions_Handler,
		},
		{
			MethodName: "GetTensorFlowVersion",
			Handler:    _Tpu_GetTensorFlowVersion_Handler,
		},
		{
			MethodName: "ListAcceleratorTypes",
			Handler:    _Tpu_ListAcceleratorTypes_Handler,
		},
		{
			MethodName: "GetAcceleratorType",
			Handler:    _Tpu_GetAcceleratorType_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/tpu/v1/cloud_tpu.proto",
}
