// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package ptrace

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"go.opentelemetry.io/collector/pdata/internal"
	otlptrace "go.opentelemetry.io/collector/pdata/internal/data/protogen/trace/v1"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

func TestScopeSpans_MoveTo(t *testing.T) {
	ms := generateTestScopeSpans()
	dest := NewScopeSpans()
	ms.MoveTo(dest)
	assert.Equal(t, NewScopeSpans(), ms)
	assert.Equal(t, generateTestScopeSpans(), dest)
	dest.MoveTo(dest)
	assert.Equal(t, generateTestScopeSpans(), dest)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.MoveTo(newScopeSpans(internal.NewOrigScopeSpans(), sharedState)) })
	assert.Panics(t, func() { newScopeSpans(internal.NewOrigScopeSpans(), sharedState).MoveTo(dest) })
}

func TestScopeSpans_CopyTo(t *testing.T) {
	ms := NewScopeSpans()
	orig := NewScopeSpans()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	orig = generateTestScopeSpans()
	orig.CopyTo(ms)
	assert.Equal(t, orig, ms)
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { ms.CopyTo(newScopeSpans(internal.NewOrigScopeSpans(), sharedState)) })
}

func TestScopeSpans_Scope(t *testing.T) {
	ms := NewScopeSpans()
	assert.Equal(t, pcommon.NewInstrumentationScope(), ms.Scope())
	ms.orig.Scope = *internal.GenTestOrigInstrumentationScope()
	assert.Equal(t, pcommon.InstrumentationScope(internal.NewInstrumentationScope(internal.GenTestOrigInstrumentationScope(), ms.state)), ms.Scope())
}

func TestScopeSpans_Spans(t *testing.T) {
	ms := NewScopeSpans()
	assert.Equal(t, NewSpanSlice(), ms.Spans())
	ms.orig.Spans = internal.GenerateOrigTestSpanSlice()
	assert.Equal(t, generateTestSpanSlice(), ms.Spans())
}

func TestScopeSpans_SchemaUrl(t *testing.T) {
	ms := NewScopeSpans()
	assert.Empty(t, ms.SchemaUrl())
	ms.SetSchemaUrl("test_schemaurl")
	assert.Equal(t, "test_schemaurl", ms.SchemaUrl())
	sharedState := internal.NewState()
	sharedState.MarkReadOnly()
	assert.Panics(t, func() { newScopeSpans(&otlptrace.ScopeSpans{}, sharedState).SetSchemaUrl("test_schemaurl") })
}

func generateTestScopeSpans() ScopeSpans {
	ms := newScopeSpans(internal.GenTestOrigScopeSpans(), internal.NewState())
	return ms
}
