// Code generated by smithy-go-codegen DO NOT EDIT.

package iam

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables the outbound identity federation feature for your Amazon Web Services
// account. When enabled, IAM principals in your account can use the
// GetWebIdentityToken API to obtain JSON Web Tokens (JWTs) for secure
// authentication with external services. This operation also generates a unique
// issuer URL for your Amazon Web Services account.
func (c *Client) EnableOutboundWebIdentityFederation(ctx context.Context, params *EnableOutboundWebIdentityFederationInput, optFns ...func(*Options)) (*EnableOutboundWebIdentityFederationOutput, error) {
	if params == nil {
		params = &EnableOutboundWebIdentityFederationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableOutboundWebIdentityFederation", params, optFns, c.addOperationEnableOutboundWebIdentityFederationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableOutboundWebIdentityFederationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type EnableOutboundWebIdentityFederationInput struct {
	noSmithyDocumentSerde
}

type EnableOutboundWebIdentityFederationOutput struct {

	// A unique issuer URL for your Amazon Web Services account that hosts the OpenID
	// Connect (OIDC) discovery endpoints at /.well-known/openid-configuration and
	// /.well-known/jwks.json . The OpenID Connect (OIDC) discovery endpoints contain
	// verification keys and metadata necessary for token verification.
	IssuerIdentifier *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableOutboundWebIdentityFederationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpEnableOutboundWebIdentityFederation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpEnableOutboundWebIdentityFederation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableOutboundWebIdentityFederation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableOutboundWebIdentityFederation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableOutboundWebIdentityFederation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableOutboundWebIdentityFederation",
	}
}
