// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/securitycenter/v2/mitre_attack.proto

package securitycenterpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// MITRE ATT&CK tactics that can be referenced by SCC findings.
// See: https://attack.mitre.org/tactics/enterprise/
type MitreAttack_Tactic int32

const (
	// Unspecified value.
	MitreAttack_TACTIC_UNSPECIFIED MitreAttack_Tactic = 0
	// TA0043
	MitreAttack_RECONNAISSANCE MitreAttack_Tactic = 1
	// TA0042
	MitreAttack_RESOURCE_DEVELOPMENT MitreAttack_Tactic = 2
	// TA0001
	MitreAttack_INITIAL_ACCESS MitreAttack_Tactic = 5
	// TA0002
	MitreAttack_EXECUTION MitreAttack_Tactic = 3
	// TA0003
	MitreAttack_PERSISTENCE MitreAttack_Tactic = 6
	// TA0004
	MitreAttack_PRIVILEGE_ESCALATION MitreAttack_Tactic = 8
	// TA0005
	MitreAttack_DEFENSE_EVASION MitreAttack_Tactic = 7
	// TA0006
	MitreAttack_CREDENTIAL_ACCESS MitreAttack_Tactic = 9
	// TA0007
	MitreAttack_DISCOVERY MitreAttack_Tactic = 10
	// TA0008
	MitreAttack_LATERAL_MOVEMENT MitreAttack_Tactic = 11
	// TA0009
	MitreAttack_COLLECTION MitreAttack_Tactic = 12
	// TA0011
	MitreAttack_COMMAND_AND_CONTROL MitreAttack_Tactic = 4
	// TA0010
	MitreAttack_EXFILTRATION MitreAttack_Tactic = 13
	// TA0040
	MitreAttack_IMPACT MitreAttack_Tactic = 14
)

// Enum value maps for MitreAttack_Tactic.
var (
	MitreAttack_Tactic_name = map[int32]string{
		0:  "TACTIC_UNSPECIFIED",
		1:  "RECONNAISSANCE",
		2:  "RESOURCE_DEVELOPMENT",
		5:  "INITIAL_ACCESS",
		3:  "EXECUTION",
		6:  "PERSISTENCE",
		8:  "PRIVILEGE_ESCALATION",
		7:  "DEFENSE_EVASION",
		9:  "CREDENTIAL_ACCESS",
		10: "DISCOVERY",
		11: "LATERAL_MOVEMENT",
		12: "COLLECTION",
		4:  "COMMAND_AND_CONTROL",
		13: "EXFILTRATION",
		14: "IMPACT",
	}
	MitreAttack_Tactic_value = map[string]int32{
		"TACTIC_UNSPECIFIED":   0,
		"RECONNAISSANCE":       1,
		"RESOURCE_DEVELOPMENT": 2,
		"INITIAL_ACCESS":       5,
		"EXECUTION":            3,
		"PERSISTENCE":          6,
		"PRIVILEGE_ESCALATION": 8,
		"DEFENSE_EVASION":      7,
		"CREDENTIAL_ACCESS":    9,
		"DISCOVERY":            10,
		"LATERAL_MOVEMENT":     11,
		"COLLECTION":           12,
		"COMMAND_AND_CONTROL":  4,
		"EXFILTRATION":         13,
		"IMPACT":               14,
	}
)

func (x MitreAttack_Tactic) Enum() *MitreAttack_Tactic {
	p := new(MitreAttack_Tactic)
	*p = x
	return p
}

func (x MitreAttack_Tactic) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MitreAttack_Tactic) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes[0].Descriptor()
}

func (MitreAttack_Tactic) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes[0]
}

func (x MitreAttack_Tactic) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MitreAttack_Tactic.Descriptor instead.
func (MitreAttack_Tactic) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescGZIP(), []int{0, 0}
}

// MITRE ATT&CK techniques that can be referenced by Security Command Center
// findings. See: https://attack.mitre.org/techniques/enterprise/
type MitreAttack_Technique int32

const (
	// Unspecified value.
	MitreAttack_TECHNIQUE_UNSPECIFIED MitreAttack_Technique = 0
	// T1001
	MitreAttack_DATA_OBFUSCATION MitreAttack_Technique = 70
	// T1001.002
	MitreAttack_DATA_OBFUSCATION_STEGANOGRAPHY MitreAttack_Technique = 71
	// T1003
	MitreAttack_OS_CREDENTIAL_DUMPING MitreAttack_Technique = 114
	// T1003.007
	MitreAttack_OS_CREDENTIAL_DUMPING_PROC_FILESYSTEM MitreAttack_Technique = 115
	// T1003.008
	MitreAttack_OS_CREDENTIAL_DUMPING_ETC_PASSWORD_AND_ETC_SHADOW MitreAttack_Technique = 122
	// T1005
	MitreAttack_DATA_FROM_LOCAL_SYSTEM MitreAttack_Technique = 117
	// T1020
	MitreAttack_AUTOMATED_EXFILTRATION MitreAttack_Technique = 68
	// T1027
	MitreAttack_OBFUSCATED_FILES_OR_INFO MitreAttack_Technique = 72
	// T1027.003
	MitreAttack_STEGANOGRAPHY MitreAttack_Technique = 73
	// T1027.004
	MitreAttack_COMPILE_AFTER_DELIVERY MitreAttack_Technique = 74
	// T1027.010
	MitreAttack_COMMAND_OBFUSCATION MitreAttack_Technique = 75
	// T1029
	MitreAttack_SCHEDULED_TRANSFER MitreAttack_Technique = 120
	// T1033
	MitreAttack_SYSTEM_OWNER_USER_DISCOVERY MitreAttack_Technique = 118
	// T1036
	MitreAttack_MASQUERADING MitreAttack_Technique = 49
	// T1036.005
	MitreAttack_MATCH_LEGITIMATE_NAME_OR_LOCATION MitreAttack_Technique = 50
	// T1037
	MitreAttack_BOOT_OR_LOGON_INITIALIZATION_SCRIPTS MitreAttack_Technique = 37
	// T1037.005
	MitreAttack_STARTUP_ITEMS MitreAttack_Technique = 38
	// T1046
	MitreAttack_NETWORK_SERVICE_DISCOVERY MitreAttack_Technique = 32
	// T1053
	MitreAttack_SCHEDULED_TASK_JOB MitreAttack_Technique = 89
	// T1053.003
	MitreAttack_SCHEDULED_TASK_JOB_CRON MitreAttack_Technique = 119
	// T1053.007
	MitreAttack_CONTAINER_ORCHESTRATION_JOB MitreAttack_Technique = 90
	// T1055
	MitreAttack_PROCESS_INJECTION MitreAttack_Technique = 93
	// T1056
	MitreAttack_INPUT_CAPTURE MitreAttack_Technique = 103
	// T1056.001
	MitreAttack_INPUT_CAPTURE_KEYLOGGING MitreAttack_Technique = 104
	// T1057
	MitreAttack_PROCESS_DISCOVERY MitreAttack_Technique = 56
	// T1059
	MitreAttack_COMMAND_AND_SCRIPTING_INTERPRETER MitreAttack_Technique = 6
	// T1059.004
	MitreAttack_UNIX_SHELL MitreAttack_Technique = 7
	// T1059.006
	MitreAttack_PYTHON MitreAttack_Technique = 59
	// T1068
	MitreAttack_EXPLOITATION_FOR_PRIVILEGE_ESCALATION MitreAttack_Technique = 63
	// T1069
	MitreAttack_PERMISSION_GROUPS_DISCOVERY MitreAttack_Technique = 18
	// T1069.003
	MitreAttack_CLOUD_GROUPS MitreAttack_Technique = 19
	// T1070
	MitreAttack_INDICATOR_REMOVAL MitreAttack_Technique = 123
	// T1070.002
	MitreAttack_INDICATOR_REMOVAL_CLEAR_LINUX_OR_MAC_SYSTEM_LOGS MitreAttack_Technique = 124
	// T1070.003
	MitreAttack_INDICATOR_REMOVAL_CLEAR_COMMAND_HISTORY MitreAttack_Technique = 125
	// T1070.004
	MitreAttack_INDICATOR_REMOVAL_FILE_DELETION MitreAttack_Technique = 64
	// T1070.006
	MitreAttack_INDICATOR_REMOVAL_TIMESTOMP MitreAttack_Technique = 128
	// T1070.008
	MitreAttack_INDICATOR_REMOVAL_CLEAR_MAILBOX_DATA MitreAttack_Technique = 126
	// T1071
	MitreAttack_APPLICATION_LAYER_PROTOCOL MitreAttack_Technique = 45
	// T1071.004
	MitreAttack_DNS MitreAttack_Technique = 46
	// T1072
	MitreAttack_SOFTWARE_DEPLOYMENT_TOOLS MitreAttack_Technique = 47
	// T1078
	MitreAttack_VALID_ACCOUNTS MitreAttack_Technique = 14
	// T1078.001
	MitreAttack_DEFAULT_ACCOUNTS MitreAttack_Technique = 35
	// T1078.003
	MitreAttack_LOCAL_ACCOUNTS MitreAttack_Technique = 15
	// T1078.004
	MitreAttack_CLOUD_ACCOUNTS MitreAttack_Technique = 16
	// T1083
	MitreAttack_FILE_AND_DIRECTORY_DISCOVERY MitreAttack_Technique = 121
	// T1087.001
	MitreAttack_ACCOUNT_DISCOVERY_LOCAL_ACCOUNT MitreAttack_Technique = 116
	// T1090
	MitreAttack_PROXY MitreAttack_Technique = 9
	// T1090.002
	MitreAttack_EXTERNAL_PROXY MitreAttack_Technique = 10
	// T1090.003
	MitreAttack_MULTI_HOP_PROXY MitreAttack_Technique = 11
	// T1098
	MitreAttack_ACCOUNT_MANIPULATION MitreAttack_Technique = 22
	// T1098.001
	MitreAttack_ADDITIONAL_CLOUD_CREDENTIALS MitreAttack_Technique = 40
	// T1098.003
	MitreAttack_ADDITIONAL_CLOUD_ROLES MitreAttack_Technique = 67
	// T1098.004
	MitreAttack_SSH_AUTHORIZED_KEYS MitreAttack_Technique = 23
	// T1098.006
	MitreAttack_ADDITIONAL_CONTAINER_CLUSTER_ROLES MitreAttack_Technique = 58
	// T1104
	MitreAttack_MULTI_STAGE_CHANNELS MitreAttack_Technique = 76
	// T1105
	MitreAttack_INGRESS_TOOL_TRANSFER MitreAttack_Technique = 3
	// T1106
	MitreAttack_NATIVE_API MitreAttack_Technique = 4
	// T1110
	MitreAttack_BRUTE_FORCE MitreAttack_Technique = 44
	// T1119
	MitreAttack_AUTOMATED_COLLECTION MitreAttack_Technique = 94
	// T1129
	MitreAttack_SHARED_MODULES MitreAttack_Technique = 5
	// T1132
	MitreAttack_DATA_ENCODING MitreAttack_Technique = 77
	// T1132.001
	MitreAttack_STANDARD_ENCODING MitreAttack_Technique = 78
	// T1134
	MitreAttack_ACCESS_TOKEN_MANIPULATION MitreAttack_Technique = 33
	// T1134.001
	MitreAttack_TOKEN_IMPERSONATION_OR_THEFT MitreAttack_Technique = 39
	// T1136
	MitreAttack_CREATE_ACCOUNT MitreAttack_Technique = 79
	// T1136.001
	MitreAttack_LOCAL_ACCOUNT MitreAttack_Technique = 80
	// T1140
	MitreAttack_DEOBFUSCATE_DECODE_FILES_OR_INFO MitreAttack_Technique = 95
	// T1190
	MitreAttack_EXPLOIT_PUBLIC_FACING_APPLICATION MitreAttack_Technique = 27
	// T1195
	MitreAttack_SUPPLY_CHAIN_COMPROMISE MitreAttack_Technique = 129
	// T1195.001
	MitreAttack_COMPROMISE_SOFTWARE_DEPENDENCIES_AND_DEVELOPMENT_TOOLS MitreAttack_Technique = 130
	// T1203
	MitreAttack_EXPLOITATION_FOR_CLIENT_EXECUTION MitreAttack_Technique = 134
	// T1204
	MitreAttack_USER_EXECUTION MitreAttack_Technique = 69
	// T1222.002
	MitreAttack_LINUX_AND_MAC_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION MitreAttack_Technique = 135
	// T1484
	MitreAttack_DOMAIN_POLICY_MODIFICATION MitreAttack_Technique = 30
	// T1485
	MitreAttack_DATA_DESTRUCTION MitreAttack_Technique = 29
	// T1486
	MitreAttack_DATA_ENCRYPTED_FOR_IMPACT MitreAttack_Technique = 132
	// T1489
	MitreAttack_SERVICE_STOP MitreAttack_Technique = 52
	// T1490
	MitreAttack_INHIBIT_SYSTEM_RECOVERY MitreAttack_Technique = 36
	// T1495
	MitreAttack_FIRMWARE_CORRUPTION MitreAttack_Technique = 81
	// T1496
	MitreAttack_RESOURCE_HIJACKING MitreAttack_Technique = 8
	// T1498
	MitreAttack_NETWORK_DENIAL_OF_SERVICE MitreAttack_Technique = 17
	// T1526
	MitreAttack_CLOUD_SERVICE_DISCOVERY MitreAttack_Technique = 48
	// T1528
	MitreAttack_STEAL_APPLICATION_ACCESS_TOKEN MitreAttack_Technique = 42
	// T1531
	MitreAttack_ACCOUNT_ACCESS_REMOVAL MitreAttack_Technique = 51
	// T1537
	MitreAttack_TRANSFER_DATA_TO_CLOUD_ACCOUNT MitreAttack_Technique = 91
	// T1539
	MitreAttack_STEAL_WEB_SESSION_COOKIE MitreAttack_Technique = 25
	// T1543
	MitreAttack_CREATE_OR_MODIFY_SYSTEM_PROCESS MitreAttack_Technique = 24
	// T1546
	MitreAttack_EVENT_TRIGGERED_EXECUTION MitreAttack_Technique = 65
	// T1547
	MitreAttack_BOOT_OR_LOGON_AUTOSTART_EXECUTION MitreAttack_Technique = 82
	// T1547.006
	MitreAttack_KERNEL_MODULES_AND_EXTENSIONS MitreAttack_Technique = 83
	// T1547.009
	MitreAttack_SHORTCUT_MODIFICATION MitreAttack_Technique = 127
	// T1548
	MitreAttack_ABUSE_ELEVATION_CONTROL_MECHANISM MitreAttack_Technique = 34
	// T1548.001
	MitreAttack_ABUSE_ELEVATION_CONTROL_MECHANISM_SETUID_AND_SETGID MitreAttack_Technique = 136
	// T1548.003
	MitreAttack_ABUSE_ELEVATION_CONTROL_MECHANISM_SUDO_AND_SUDO_CACHING MitreAttack_Technique = 109
	// T1552
	MitreAttack_UNSECURED_CREDENTIALS MitreAttack_Technique = 13
	// T1552.001
	MitreAttack_CREDENTIALS_IN_FILES MitreAttack_Technique = 105
	// T1552.003
	MitreAttack_BASH_HISTORY MitreAttack_Technique = 96
	// T1552.004
	MitreAttack_PRIVATE_KEYS MitreAttack_Technique = 97
	// T1553
	MitreAttack_SUBVERT_TRUST_CONTROL MitreAttack_Technique = 106
	// T1553.004
	MitreAttack_INSTALL_ROOT_CERTIFICATE MitreAttack_Technique = 107
	// T1554
	MitreAttack_COMPROMISE_HOST_SOFTWARE_BINARY MitreAttack_Technique = 84
	// T1555
	MitreAttack_CREDENTIALS_FROM_PASSWORD_STORES MitreAttack_Technique = 98
	// T1556
	MitreAttack_MODIFY_AUTHENTICATION_PROCESS MitreAttack_Technique = 28
	// T1556.003
	MitreAttack_PLUGGABLE_AUTHENTICATION_MODULES MitreAttack_Technique = 108
	// T1556.006
	MitreAttack_MULTI_FACTOR_AUTHENTICATION MitreAttack_Technique = 137
	// T1562
	MitreAttack_IMPAIR_DEFENSES MitreAttack_Technique = 31
	// T1562.001
	MitreAttack_DISABLE_OR_MODIFY_TOOLS MitreAttack_Technique = 55
	// T1562.006
	MitreAttack_INDICATOR_BLOCKING MitreAttack_Technique = 110
	// T1562.012
	MitreAttack_DISABLE_OR_MODIFY_LINUX_AUDIT_SYSTEM MitreAttack_Technique = 111
	// T1564
	MitreAttack_HIDE_ARTIFACTS MitreAttack_Technique = 85
	// T1564.001
	MitreAttack_HIDDEN_FILES_AND_DIRECTORIES MitreAttack_Technique = 86
	// T1564.002
	MitreAttack_HIDDEN_USERS MitreAttack_Technique = 87
	// T1567
	MitreAttack_EXFILTRATION_OVER_WEB_SERVICE MitreAttack_Technique = 20
	// T1567.002
	MitreAttack_EXFILTRATION_TO_CLOUD_STORAGE MitreAttack_Technique = 21
	// T1568
	MitreAttack_DYNAMIC_RESOLUTION MitreAttack_Technique = 12
	// T1570
	MitreAttack_LATERAL_TOOL_TRANSFER MitreAttack_Technique = 41
	// T1574
	MitreAttack_HIJACK_EXECUTION_FLOW MitreAttack_Technique = 112
	// T1574.006
	MitreAttack_HIJACK_EXECUTION_FLOW_DYNAMIC_LINKER_HIJACKING MitreAttack_Technique = 113
	// T1578
	MitreAttack_MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE MitreAttack_Technique = 26
	// T1578.001
	MitreAttack_CREATE_SNAPSHOT MitreAttack_Technique = 54
	// T1580
	MitreAttack_CLOUD_INFRASTRUCTURE_DISCOVERY MitreAttack_Technique = 53
	// T1587
	MitreAttack_DEVELOP_CAPABILITIES MitreAttack_Technique = 99
	// T1587.001
	MitreAttack_DEVELOP_CAPABILITIES_MALWARE MitreAttack_Technique = 100
	// T1588
	MitreAttack_OBTAIN_CAPABILITIES MitreAttack_Technique = 43
	// T1588.001
	MitreAttack_OBTAIN_CAPABILITIES_MALWARE MitreAttack_Technique = 101
	// T1588.006
	MitreAttack_OBTAIN_CAPABILITIES_VULNERABILITIES MitreAttack_Technique = 133
	// T1595
	MitreAttack_ACTIVE_SCANNING MitreAttack_Technique = 1
	// T1595.001
	MitreAttack_SCANNING_IP_BLOCKS MitreAttack_Technique = 2
	// T1608
	MitreAttack_STAGE_CAPABILITIES MitreAttack_Technique = 88
	// T1608.001
	MitreAttack_UPLOAD_MALWARE MitreAttack_Technique = 102
	// T1609
	MitreAttack_CONTAINER_ADMINISTRATION_COMMAND MitreAttack_Technique = 60
	// T1610
	MitreAttack_DEPLOY_CONTAINER MitreAttack_Technique = 66
	// T1611
	MitreAttack_ESCAPE_TO_HOST MitreAttack_Technique = 61
	// T1613
	MitreAttack_CONTAINER_AND_RESOURCE_DISCOVERY MitreAttack_Technique = 57
	// T1620
	MitreAttack_REFLECTIVE_CODE_LOADING MitreAttack_Technique = 92
	// T1649
	MitreAttack_STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES MitreAttack_Technique = 62
	// T1657
	MitreAttack_FINANCIAL_THEFT MitreAttack_Technique = 131
)

// Enum value maps for MitreAttack_Technique.
var (
	MitreAttack_Technique_name = map[int32]string{
		0:   "TECHNIQUE_UNSPECIFIED",
		70:  "DATA_OBFUSCATION",
		71:  "DATA_OBFUSCATION_STEGANOGRAPHY",
		114: "OS_CREDENTIAL_DUMPING",
		115: "OS_CREDENTIAL_DUMPING_PROC_FILESYSTEM",
		122: "OS_CREDENTIAL_DUMPING_ETC_PASSWORD_AND_ETC_SHADOW",
		117: "DATA_FROM_LOCAL_SYSTEM",
		68:  "AUTOMATED_EXFILTRATION",
		72:  "OBFUSCATED_FILES_OR_INFO",
		73:  "STEGANOGRAPHY",
		74:  "COMPILE_AFTER_DELIVERY",
		75:  "COMMAND_OBFUSCATION",
		120: "SCHEDULED_TRANSFER",
		118: "SYSTEM_OWNER_USER_DISCOVERY",
		49:  "MASQUERADING",
		50:  "MATCH_LEGITIMATE_NAME_OR_LOCATION",
		37:  "BOOT_OR_LOGON_INITIALIZATION_SCRIPTS",
		38:  "STARTUP_ITEMS",
		32:  "NETWORK_SERVICE_DISCOVERY",
		89:  "SCHEDULED_TASK_JOB",
		119: "SCHEDULED_TASK_JOB_CRON",
		90:  "CONTAINER_ORCHESTRATION_JOB",
		93:  "PROCESS_INJECTION",
		103: "INPUT_CAPTURE",
		104: "INPUT_CAPTURE_KEYLOGGING",
		56:  "PROCESS_DISCOVERY",
		6:   "COMMAND_AND_SCRIPTING_INTERPRETER",
		7:   "UNIX_SHELL",
		59:  "PYTHON",
		63:  "EXPLOITATION_FOR_PRIVILEGE_ESCALATION",
		18:  "PERMISSION_GROUPS_DISCOVERY",
		19:  "CLOUD_GROUPS",
		123: "INDICATOR_REMOVAL",
		124: "INDICATOR_REMOVAL_CLEAR_LINUX_OR_MAC_SYSTEM_LOGS",
		125: "INDICATOR_REMOVAL_CLEAR_COMMAND_HISTORY",
		64:  "INDICATOR_REMOVAL_FILE_DELETION",
		128: "INDICATOR_REMOVAL_TIMESTOMP",
		126: "INDICATOR_REMOVAL_CLEAR_MAILBOX_DATA",
		45:  "APPLICATION_LAYER_PROTOCOL",
		46:  "DNS",
		47:  "SOFTWARE_DEPLOYMENT_TOOLS",
		14:  "VALID_ACCOUNTS",
		35:  "DEFAULT_ACCOUNTS",
		15:  "LOCAL_ACCOUNTS",
		16:  "CLOUD_ACCOUNTS",
		121: "FILE_AND_DIRECTORY_DISCOVERY",
		116: "ACCOUNT_DISCOVERY_LOCAL_ACCOUNT",
		9:   "PROXY",
		10:  "EXTERNAL_PROXY",
		11:  "MULTI_HOP_PROXY",
		22:  "ACCOUNT_MANIPULATION",
		40:  "ADDITIONAL_CLOUD_CREDENTIALS",
		67:  "ADDITIONAL_CLOUD_ROLES",
		23:  "SSH_AUTHORIZED_KEYS",
		58:  "ADDITIONAL_CONTAINER_CLUSTER_ROLES",
		76:  "MULTI_STAGE_CHANNELS",
		3:   "INGRESS_TOOL_TRANSFER",
		4:   "NATIVE_API",
		44:  "BRUTE_FORCE",
		94:  "AUTOMATED_COLLECTION",
		5:   "SHARED_MODULES",
		77:  "DATA_ENCODING",
		78:  "STANDARD_ENCODING",
		33:  "ACCESS_TOKEN_MANIPULATION",
		39:  "TOKEN_IMPERSONATION_OR_THEFT",
		79:  "CREATE_ACCOUNT",
		80:  "LOCAL_ACCOUNT",
		95:  "DEOBFUSCATE_DECODE_FILES_OR_INFO",
		27:  "EXPLOIT_PUBLIC_FACING_APPLICATION",
		129: "SUPPLY_CHAIN_COMPROMISE",
		130: "COMPROMISE_SOFTWARE_DEPENDENCIES_AND_DEVELOPMENT_TOOLS",
		134: "EXPLOITATION_FOR_CLIENT_EXECUTION",
		69:  "USER_EXECUTION",
		135: "LINUX_AND_MAC_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION",
		30:  "DOMAIN_POLICY_MODIFICATION",
		29:  "DATA_DESTRUCTION",
		132: "DATA_ENCRYPTED_FOR_IMPACT",
		52:  "SERVICE_STOP",
		36:  "INHIBIT_SYSTEM_RECOVERY",
		81:  "FIRMWARE_CORRUPTION",
		8:   "RESOURCE_HIJACKING",
		17:  "NETWORK_DENIAL_OF_SERVICE",
		48:  "CLOUD_SERVICE_DISCOVERY",
		42:  "STEAL_APPLICATION_ACCESS_TOKEN",
		51:  "ACCOUNT_ACCESS_REMOVAL",
		91:  "TRANSFER_DATA_TO_CLOUD_ACCOUNT",
		25:  "STEAL_WEB_SESSION_COOKIE",
		24:  "CREATE_OR_MODIFY_SYSTEM_PROCESS",
		65:  "EVENT_TRIGGERED_EXECUTION",
		82:  "BOOT_OR_LOGON_AUTOSTART_EXECUTION",
		83:  "KERNEL_MODULES_AND_EXTENSIONS",
		127: "SHORTCUT_MODIFICATION",
		34:  "ABUSE_ELEVATION_CONTROL_MECHANISM",
		136: "ABUSE_ELEVATION_CONTROL_MECHANISM_SETUID_AND_SETGID",
		109: "ABUSE_ELEVATION_CONTROL_MECHANISM_SUDO_AND_SUDO_CACHING",
		13:  "UNSECURED_CREDENTIALS",
		105: "CREDENTIALS_IN_FILES",
		96:  "BASH_HISTORY",
		97:  "PRIVATE_KEYS",
		106: "SUBVERT_TRUST_CONTROL",
		107: "INSTALL_ROOT_CERTIFICATE",
		84:  "COMPROMISE_HOST_SOFTWARE_BINARY",
		98:  "CREDENTIALS_FROM_PASSWORD_STORES",
		28:  "MODIFY_AUTHENTICATION_PROCESS",
		108: "PLUGGABLE_AUTHENTICATION_MODULES",
		137: "MULTI_FACTOR_AUTHENTICATION",
		31:  "IMPAIR_DEFENSES",
		55:  "DISABLE_OR_MODIFY_TOOLS",
		110: "INDICATOR_BLOCKING",
		111: "DISABLE_OR_MODIFY_LINUX_AUDIT_SYSTEM",
		85:  "HIDE_ARTIFACTS",
		86:  "HIDDEN_FILES_AND_DIRECTORIES",
		87:  "HIDDEN_USERS",
		20:  "EXFILTRATION_OVER_WEB_SERVICE",
		21:  "EXFILTRATION_TO_CLOUD_STORAGE",
		12:  "DYNAMIC_RESOLUTION",
		41:  "LATERAL_TOOL_TRANSFER",
		112: "HIJACK_EXECUTION_FLOW",
		113: "HIJACK_EXECUTION_FLOW_DYNAMIC_LINKER_HIJACKING",
		26:  "MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE",
		54:  "CREATE_SNAPSHOT",
		53:  "CLOUD_INFRASTRUCTURE_DISCOVERY",
		99:  "DEVELOP_CAPABILITIES",
		100: "DEVELOP_CAPABILITIES_MALWARE",
		43:  "OBTAIN_CAPABILITIES",
		101: "OBTAIN_CAPABILITIES_MALWARE",
		133: "OBTAIN_CAPABILITIES_VULNERABILITIES",
		1:   "ACTIVE_SCANNING",
		2:   "SCANNING_IP_BLOCKS",
		88:  "STAGE_CAPABILITIES",
		102: "UPLOAD_MALWARE",
		60:  "CONTAINER_ADMINISTRATION_COMMAND",
		66:  "DEPLOY_CONTAINER",
		61:  "ESCAPE_TO_HOST",
		57:  "CONTAINER_AND_RESOURCE_DISCOVERY",
		92:  "REFLECTIVE_CODE_LOADING",
		62:  "STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES",
		131: "FINANCIAL_THEFT",
	}
	MitreAttack_Technique_value = map[string]int32{
		"TECHNIQUE_UNSPECIFIED":                             0,
		"DATA_OBFUSCATION":                                  70,
		"DATA_OBFUSCATION_STEGANOGRAPHY":                    71,
		"OS_CREDENTIAL_DUMPING":                             114,
		"OS_CREDENTIAL_DUMPING_PROC_FILESYSTEM":             115,
		"OS_CREDENTIAL_DUMPING_ETC_PASSWORD_AND_ETC_SHADOW": 122,
		"DATA_FROM_LOCAL_SYSTEM":                            117,
		"AUTOMATED_EXFILTRATION":                            68,
		"OBFUSCATED_FILES_OR_INFO":                          72,
		"STEGANOGRAPHY":                                     73,
		"COMPILE_AFTER_DELIVERY":                            74,
		"COMMAND_OBFUSCATION":                               75,
		"SCHEDULED_TRANSFER":                                120,
		"SYSTEM_OWNER_USER_DISCOVERY":                       118,
		"MASQUERADING":                                      49,
		"MATCH_LEGITIMATE_NAME_OR_LOCATION":                 50,
		"BOOT_OR_LOGON_INITIALIZATION_SCRIPTS":              37,
		"STARTUP_ITEMS":                                     38,
		"NETWORK_SERVICE_DISCOVERY":                         32,
		"SCHEDULED_TASK_JOB":                                89,
		"SCHEDULED_TASK_JOB_CRON":                           119,
		"CONTAINER_ORCHESTRATION_JOB":                       90,
		"PROCESS_INJECTION":                                 93,
		"INPUT_CAPTURE":                                     103,
		"INPUT_CAPTURE_KEYLOGGING":                          104,
		"PROCESS_DISCOVERY":                                 56,
		"COMMAND_AND_SCRIPTING_INTERPRETER":                 6,
		"UNIX_SHELL":                                        7,
		"PYTHON":                                            59,
		"EXPLOITATION_FOR_PRIVILEGE_ESCALATION":             63,
		"PERMISSION_GROUPS_DISCOVERY":                       18,
		"CLOUD_GROUPS":                                      19,
		"INDICATOR_REMOVAL":                                 123,
		"INDICATOR_REMOVAL_CLEAR_LINUX_OR_MAC_SYSTEM_LOGS":  124,
		"INDICATOR_REMOVAL_CLEAR_COMMAND_HISTORY":           125,
		"INDICATOR_REMOVAL_FILE_DELETION":                   64,
		"INDICATOR_REMOVAL_TIMESTOMP":                       128,
		"INDICATOR_REMOVAL_CLEAR_MAILBOX_DATA":              126,
		"APPLICATION_LAYER_PROTOCOL":                        45,
		"DNS":                                               46,
		"SOFTWARE_DEPLOYMENT_TOOLS":                         47,
		"VALID_ACCOUNTS":                                    14,
		"DEFAULT_ACCOUNTS":                                  35,
		"LOCAL_ACCOUNTS":                                    15,
		"CLOUD_ACCOUNTS":                                    16,
		"FILE_AND_DIRECTORY_DISCOVERY":                      121,
		"ACCOUNT_DISCOVERY_LOCAL_ACCOUNT":                   116,
		"PROXY":                                             9,
		"EXTERNAL_PROXY":                                    10,
		"MULTI_HOP_PROXY":                                   11,
		"ACCOUNT_MANIPULATION":                              22,
		"ADDITIONAL_CLOUD_CREDENTIALS":                      40,
		"ADDITIONAL_CLOUD_ROLES":                            67,
		"SSH_AUTHORIZED_KEYS":                               23,
		"ADDITIONAL_CONTAINER_CLUSTER_ROLES":                58,
		"MULTI_STAGE_CHANNELS":                              76,
		"INGRESS_TOOL_TRANSFER":                             3,
		"NATIVE_API":                                        4,
		"BRUTE_FORCE":                                       44,
		"AUTOMATED_COLLECTION":                              94,
		"SHARED_MODULES":                                    5,
		"DATA_ENCODING":                                     77,
		"STANDARD_ENCODING":                                 78,
		"ACCESS_TOKEN_MANIPULATION":                         33,
		"TOKEN_IMPERSONATION_OR_THEFT":                      39,
		"CREATE_ACCOUNT":                                    79,
		"LOCAL_ACCOUNT":                                     80,
		"DEOBFUSCATE_DECODE_FILES_OR_INFO":                  95,
		"EXPLOIT_PUBLIC_FACING_APPLICATION":                 27,
		"SUPPLY_CHAIN_COMPROMISE":                           129,
		"COMPROMISE_SOFTWARE_DEPENDENCIES_AND_DEVELOPMENT_TOOLS":    130,
		"EXPLOITATION_FOR_CLIENT_EXECUTION":                         134,
		"USER_EXECUTION":                                            69,
		"LINUX_AND_MAC_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION": 135,
		"DOMAIN_POLICY_MODIFICATION":                                30,
		"DATA_DESTRUCTION":                                          29,
		"DATA_ENCRYPTED_FOR_IMPACT":                                 132,
		"SERVICE_STOP":                                              52,
		"INHIBIT_SYSTEM_RECOVERY":                                   36,
		"FIRMWARE_CORRUPTION":                                       81,
		"RESOURCE_HIJACKING":                                        8,
		"NETWORK_DENIAL_OF_SERVICE":                                 17,
		"CLOUD_SERVICE_DISCOVERY":                                   48,
		"STEAL_APPLICATION_ACCESS_TOKEN":                            42,
		"ACCOUNT_ACCESS_REMOVAL":                                    51,
		"TRANSFER_DATA_TO_CLOUD_ACCOUNT":                            91,
		"STEAL_WEB_SESSION_COOKIE":                                  25,
		"CREATE_OR_MODIFY_SYSTEM_PROCESS":                           24,
		"EVENT_TRIGGERED_EXECUTION":                                 65,
		"BOOT_OR_LOGON_AUTOSTART_EXECUTION":                         82,
		"KERNEL_MODULES_AND_EXTENSIONS":                             83,
		"SHORTCUT_MODIFICATION":                                     127,
		"ABUSE_ELEVATION_CONTROL_MECHANISM":                         34,
		"ABUSE_ELEVATION_CONTROL_MECHANISM_SETUID_AND_SETGID":       136,
		"ABUSE_ELEVATION_CONTROL_MECHANISM_SUDO_AND_SUDO_CACHING":   109,
		"UNSECURED_CREDENTIALS":                                     13,
		"CREDENTIALS_IN_FILES":                                      105,
		"BASH_HISTORY":                                              96,
		"PRIVATE_KEYS":                                              97,
		"SUBVERT_TRUST_CONTROL":                                     106,
		"INSTALL_ROOT_CERTIFICATE":                                  107,
		"COMPROMISE_HOST_SOFTWARE_BINARY":                           84,
		"CREDENTIALS_FROM_PASSWORD_STORES":                          98,
		"MODIFY_AUTHENTICATION_PROCESS":                             28,
		"PLUGGABLE_AUTHENTICATION_MODULES":                          108,
		"MULTI_FACTOR_AUTHENTICATION":                               137,
		"IMPAIR_DEFENSES":                                           31,
		"DISABLE_OR_MODIFY_TOOLS":                                   55,
		"INDICATOR_BLOCKING":                                        110,
		"DISABLE_OR_MODIFY_LINUX_AUDIT_SYSTEM":                      111,
		"HIDE_ARTIFACTS":                                            85,
		"HIDDEN_FILES_AND_DIRECTORIES":                              86,
		"HIDDEN_USERS":                                              87,
		"EXFILTRATION_OVER_WEB_SERVICE":                             20,
		"EXFILTRATION_TO_CLOUD_STORAGE":                             21,
		"DYNAMIC_RESOLUTION":                                        12,
		"LATERAL_TOOL_TRANSFER":                                     41,
		"HIJACK_EXECUTION_FLOW":                                     112,
		"HIJACK_EXECUTION_FLOW_DYNAMIC_LINKER_HIJACKING":            113,
		"MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE":                       26,
		"CREATE_SNAPSHOT":                                           54,
		"CLOUD_INFRASTRUCTURE_DISCOVERY":                            53,
		"DEVELOP_CAPABILITIES":                                      99,
		"DEVELOP_CAPABILITIES_MALWARE":                              100,
		"OBTAIN_CAPABILITIES":                                       43,
		"OBTAIN_CAPABILITIES_MALWARE":                               101,
		"OBTAIN_CAPABILITIES_VULNERABILITIES":                       133,
		"ACTIVE_SCANNING":                                           1,
		"SCANNING_IP_BLOCKS":                                        2,
		"STAGE_CAPABILITIES":                                        88,
		"UPLOAD_MALWARE":                                            102,
		"CONTAINER_ADMINISTRATION_COMMAND":                          60,
		"DEPLOY_CONTAINER":                                          66,
		"ESCAPE_TO_HOST":                                            61,
		"CONTAINER_AND_RESOURCE_DISCOVERY":                          57,
		"REFLECTIVE_CODE_LOADING":                                   92,
		"STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES":                62,
		"FINANCIAL_THEFT":                                           131,
	}
)

func (x MitreAttack_Technique) Enum() *MitreAttack_Technique {
	p := new(MitreAttack_Technique)
	*p = x
	return p
}

func (x MitreAttack_Technique) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MitreAttack_Technique) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes[1].Descriptor()
}

func (MitreAttack_Technique) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes[1]
}

func (x MitreAttack_Technique) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MitreAttack_Technique.Descriptor instead.
func (MitreAttack_Technique) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescGZIP(), []int{0, 1}
}

// MITRE ATT&CK tactics and techniques related to this finding.
// See: https://attack.mitre.org
type MitreAttack struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The MITRE ATT&CK tactic most closely represented by this finding, if any.
	PrimaryTactic MitreAttack_Tactic `protobuf:"varint,1,opt,name=primary_tactic,json=primaryTactic,proto3,enum=google.cloud.securitycenter.v2.MitreAttack_Tactic" json:"primary_tactic,omitempty"`
	// The MITRE ATT&CK technique most closely represented by this finding, if
	// any. primary_techniques is a repeated field because there are multiple
	// levels of MITRE ATT&CK techniques.  If the technique most closely
	// represented by this finding is a sub-technique (e.g. `SCANNING_IP_BLOCKS`),
	// both the sub-technique and its parent technique(s) will be listed (e.g.
	// `SCANNING_IP_BLOCKS`, `ACTIVE_SCANNING`).
	PrimaryTechniques []MitreAttack_Technique `protobuf:"varint,2,rep,packed,name=primary_techniques,json=primaryTechniques,proto3,enum=google.cloud.securitycenter.v2.MitreAttack_Technique" json:"primary_techniques,omitempty"`
	// Additional MITRE ATT&CK tactics related to this finding, if any.
	AdditionalTactics []MitreAttack_Tactic `protobuf:"varint,3,rep,packed,name=additional_tactics,json=additionalTactics,proto3,enum=google.cloud.securitycenter.v2.MitreAttack_Tactic" json:"additional_tactics,omitempty"`
	// Additional MITRE ATT&CK techniques related to this finding, if any, along
	// with any of their respective parent techniques.
	AdditionalTechniques []MitreAttack_Technique `protobuf:"varint,4,rep,packed,name=additional_techniques,json=additionalTechniques,proto3,enum=google.cloud.securitycenter.v2.MitreAttack_Technique" json:"additional_techniques,omitempty"`
	// The MITRE ATT&CK version referenced by the above fields. E.g. "8".
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *MitreAttack) Reset() {
	*x = MitreAttack{}
	mi := &file_google_cloud_securitycenter_v2_mitre_attack_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MitreAttack) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MitreAttack) ProtoMessage() {}

func (x *MitreAttack) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_mitre_attack_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MitreAttack.ProtoReflect.Descriptor instead.
func (*MitreAttack) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescGZIP(), []int{0}
}

func (x *MitreAttack) GetPrimaryTactic() MitreAttack_Tactic {
	if x != nil {
		return x.PrimaryTactic
	}
	return MitreAttack_TACTIC_UNSPECIFIED
}

func (x *MitreAttack) GetPrimaryTechniques() []MitreAttack_Technique {
	if x != nil {
		return x.PrimaryTechniques
	}
	return nil
}

func (x *MitreAttack) GetAdditionalTactics() []MitreAttack_Tactic {
	if x != nil {
		return x.AdditionalTactics
	}
	return nil
}

func (x *MitreAttack) GetAdditionalTechniques() []MitreAttack_Technique {
	if x != nil {
		return x.AdditionalTechniques
	}
	return nil
}

func (x *MitreAttack) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

var File_google_cloud_securitycenter_v2_mitre_attack_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x6d, 0x69, 0x74, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x2e, 0x76, 0x32, 0x22, 0x9e, 0x26, 0x0a, 0x0b, 0x4d, 0x69, 0x74, 0x72, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x12, 0x59, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74,
	0x61, 0x63, 0x74, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x69, 0x74,
	0x72, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x54, 0x61, 0x63, 0x74, 0x69, 0x63, 0x52,
	0x0d, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x61, 0x63, 0x74, 0x69, 0x63, 0x12, 0x64,
	0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x69, 0x74, 0x72,
	0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75,
	0x65, 0x52, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69,
	0x71, 0x75, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x61, 0x6c, 0x5f, 0x74, 0x61, 0x63, 0x74, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76,
	0x32, 0x2e, 0x4d, 0x69, 0x74, 0x72, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x2e, 0x54, 0x61,
	0x63, 0x74, 0x69, 0x63, 0x52, 0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x54, 0x61, 0x63, 0x74, 0x69, 0x63, 0x73, 0x12, 0x6a, 0x0a, 0x15, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65,
	0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x69, 0x74, 0x72, 0x65, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x2e, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x52, 0x14, 0x61,
	0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xb4, 0x02,
	0x0a, 0x06, 0x54, 0x61, 0x63, 0x74, 0x69, 0x63, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x41, 0x43, 0x54,
	0x49, 0x43, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x4e, 0x41, 0x49, 0x53, 0x53, 0x41, 0x4e,
	0x43, 0x45, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x12,
	0x0a, 0x0e, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x03, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x45, 0x52, 0x53, 0x49, 0x53, 0x54, 0x45, 0x4e, 0x43, 0x45,
	0x10, 0x06, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x52, 0x49, 0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x5f,
	0x45, 0x53, 0x43, 0x41, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x13, 0x0a, 0x0f,
	0x44, 0x45, 0x46, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x45, 0x56, 0x41, 0x53, 0x49, 0x4f, 0x4e, 0x10,
	0x07, 0x12, 0x15, 0x0a, 0x11, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x09, 0x12, 0x0d, 0x0a, 0x09, 0x44, 0x49, 0x53, 0x43,
	0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x0a, 0x12, 0x14, 0x0a, 0x10, 0x4c, 0x41, 0x54, 0x45, 0x52,
	0x41, 0x4c, 0x5f, 0x4d, 0x4f, 0x56, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x0b, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x17, 0x0a,
	0x13, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x43, 0x4f, 0x4e,
	0x54, 0x52, 0x4f, 0x4c, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x45, 0x58, 0x46, 0x49, 0x4c, 0x54,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0d, 0x12, 0x0a, 0x0a, 0x06, 0x49, 0x4d, 0x50, 0x41,
	0x43, 0x54, 0x10, 0x0e, 0x22, 0xad, 0x20, 0x0a, 0x09, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71,
	0x75, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x45, 0x43, 0x48, 0x4e, 0x49, 0x51, 0x55, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a,
	0x10, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4f, 0x42, 0x46, 0x55, 0x53, 0x43, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x46, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x4f, 0x42, 0x46, 0x55,
	0x53, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x45, 0x47, 0x41, 0x4e, 0x4f, 0x47,
	0x52, 0x41, 0x50, 0x48, 0x59, 0x10, 0x47, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x53, 0x5f, 0x43, 0x52,
	0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x49, 0x4e, 0x47,
	0x10, 0x72, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54,
	0x49, 0x41, 0x4c, 0x5f, 0x44, 0x55, 0x4d, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x52, 0x4f, 0x43,
	0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x73, 0x12, 0x35, 0x0a,
	0x31, 0x4f, 0x53, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x44,
	0x55, 0x4d, 0x50, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x54, 0x43, 0x5f, 0x50, 0x41, 0x53, 0x53, 0x57,
	0x4f, 0x52, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x45, 0x54, 0x43, 0x5f, 0x53, 0x48, 0x41, 0x44,
	0x4f, 0x57, 0x10, 0x7a, 0x12, 0x1a, 0x0a, 0x16, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x52, 0x4f,
	0x4d, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x75,
	0x12, 0x1a, 0x0a, 0x16, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x45, 0x58,
	0x46, 0x49, 0x4c, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x44, 0x12, 0x1c, 0x0a, 0x18,
	0x4f, 0x42, 0x46, 0x55, 0x53, 0x43, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53,
	0x5f, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x48, 0x12, 0x11, 0x0a, 0x0d, 0x53, 0x54,
	0x45, 0x47, 0x41, 0x4e, 0x4f, 0x47, 0x52, 0x41, 0x50, 0x48, 0x59, 0x10, 0x49, 0x12, 0x1a, 0x0a,
	0x16, 0x43, 0x4f, 0x4d, 0x50, 0x49, 0x4c, 0x45, 0x5f, 0x41, 0x46, 0x54, 0x45, 0x52, 0x5f, 0x44,
	0x45, 0x4c, 0x49, 0x56, 0x45, 0x52, 0x59, 0x10, 0x4a, 0x12, 0x17, 0x0a, 0x13, 0x43, 0x4f, 0x4d,
	0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x4f, 0x42, 0x46, 0x55, 0x53, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x4b, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x5f,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x10, 0x78, 0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x59,
	0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4f, 0x57, 0x4e, 0x45, 0x52, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f,
	0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x76, 0x12, 0x10, 0x0a, 0x0c, 0x4d,
	0x41, 0x53, 0x51, 0x55, 0x45, 0x52, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x31, 0x12, 0x25, 0x0a,
	0x21, 0x4d, 0x41, 0x54, 0x43, 0x48, 0x5f, 0x4c, 0x45, 0x47, 0x49, 0x54, 0x49, 0x4d, 0x41, 0x54,
	0x45, 0x5f, 0x4e, 0x41, 0x4d, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x32, 0x12, 0x28, 0x0a, 0x24, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x52, 0x5f,
	0x4c, 0x4f, 0x47, 0x4f, 0x4e, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x53, 0x10, 0x25, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x55, 0x50, 0x5f, 0x49, 0x54, 0x45, 0x4d, 0x53, 0x10,
	0x26, 0x12, 0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x20,
	0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x41,
	0x53, 0x4b, 0x5f, 0x4a, 0x4f, 0x42, 0x10, 0x59, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x43, 0x48, 0x45,
	0x44, 0x55, 0x4c, 0x45, 0x44, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x4a, 0x4f, 0x42, 0x5f, 0x43,
	0x52, 0x4f, 0x4e, 0x10, 0x77, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e,
	0x45, 0x52, 0x5f, 0x4f, 0x52, 0x43, 0x48, 0x45, 0x53, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4a, 0x4f, 0x42, 0x10, 0x5a, 0x12, 0x15, 0x0a, 0x11, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x49, 0x4e, 0x4a, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x5d, 0x12, 0x11, 0x0a,
	0x0d, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52, 0x45, 0x10, 0x67,
	0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x43, 0x41, 0x50, 0x54, 0x55, 0x52,
	0x45, 0x5f, 0x4b, 0x45, 0x59, 0x4c, 0x4f, 0x47, 0x47, 0x49, 0x4e, 0x47, 0x10, 0x68, 0x12, 0x15,
	0x0a, 0x11, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56,
	0x45, 0x52, 0x59, 0x10, 0x38, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x43, 0x52, 0x49, 0x50, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x49,
	0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x45, 0x54, 0x45, 0x52, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a,
	0x55, 0x4e, 0x49, 0x58, 0x5f, 0x53, 0x48, 0x45, 0x4c, 0x4c, 0x10, 0x07, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x59, 0x54, 0x48, 0x4f, 0x4e, 0x10, 0x3b, 0x12, 0x29, 0x0a, 0x25, 0x45, 0x58, 0x50, 0x4c,
	0x4f, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x50, 0x52, 0x49,
	0x56, 0x49, 0x4c, 0x45, 0x47, 0x45, 0x5f, 0x45, 0x53, 0x43, 0x41, 0x4c, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x10, 0x3f, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x47, 0x52, 0x4f, 0x55, 0x50, 0x53, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45,
	0x52, 0x59, 0x10, 0x12, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x47, 0x52,
	0x4f, 0x55, 0x50, 0x53, 0x10, 0x13, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41,
	0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x10, 0x7b, 0x12, 0x34, 0x0a,
	0x30, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56,
	0x41, 0x4c, 0x5f, 0x43, 0x4c, 0x45, 0x41, 0x52, 0x5f, 0x4c, 0x49, 0x4e, 0x55, 0x58, 0x5f, 0x4f,
	0x52, 0x5f, 0x4d, 0x41, 0x43, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x4c, 0x4f, 0x47,
	0x53, 0x10, 0x7c, 0x12, 0x2b, 0x0a, 0x27, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41, 0x54, 0x4f, 0x52,
	0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x43, 0x4c, 0x45, 0x41, 0x52, 0x5f, 0x43,
	0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x7d,
	0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45,
	0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4f, 0x4e, 0x10, 0x40, 0x12, 0x20, 0x0a, 0x1b, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41, 0x54,
	0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x53,
	0x54, 0x4f, 0x4d, 0x50, 0x10, 0x80, 0x01, 0x12, 0x28, 0x0a, 0x24, 0x49, 0x4e, 0x44, 0x49, 0x43,
	0x41, 0x54, 0x4f, 0x52, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x43, 0x4c, 0x45,
	0x41, 0x52, 0x5f, 0x4d, 0x41, 0x49, 0x4c, 0x42, 0x4f, 0x58, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x10,
	0x7e, 0x12, 0x1e, 0x0a, 0x1a, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4c, 0x41, 0x59, 0x45, 0x52, 0x5f, 0x50, 0x52, 0x4f, 0x54, 0x4f, 0x43, 0x4f, 0x4c, 0x10,
	0x2d, 0x12, 0x07, 0x0a, 0x03, 0x44, 0x4e, 0x53, 0x10, 0x2e, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x4f,
	0x46, 0x54, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e,
	0x54, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x10, 0x2f, 0x12, 0x12, 0x0a, 0x0e, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x10, 0x0e, 0x12, 0x14, 0x0a,
	0x10, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x53, 0x10, 0x23, 0x12, 0x12, 0x0a, 0x0e, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43,
	0x4f, 0x55, 0x4e, 0x54, 0x53, 0x10, 0x0f, 0x12, 0x12, 0x0a, 0x0e, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x53, 0x10, 0x10, 0x12, 0x20, 0x0a, 0x1c, 0x46,
	0x49, 0x4c, 0x45, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x4f, 0x52,
	0x59, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x79, 0x12, 0x23, 0x0a,
	0x1f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45,
	0x52, 0x59, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x10, 0x74, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10, 0x09, 0x12, 0x12, 0x0a,
	0x0e, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x50, 0x52, 0x4f, 0x58, 0x59, 0x10,
	0x0a, 0x12, 0x13, 0x0a, 0x0f, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x48, 0x4f, 0x50, 0x5f, 0x50,
	0x52, 0x4f, 0x58, 0x59, 0x10, 0x0b, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e,
	0x54, 0x5f, 0x4d, 0x41, 0x4e, 0x49, 0x50, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x16,
	0x12, 0x20, 0x0a, 0x1c, 0x41, 0x44, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53,
	0x10, 0x28, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x44, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x41, 0x4c,
	0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x53, 0x10, 0x43, 0x12, 0x17,
	0x0a, 0x13, 0x53, 0x53, 0x48, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x4f, 0x52, 0x49, 0x5a, 0x45, 0x44,
	0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x17, 0x12, 0x26, 0x0a, 0x22, 0x41, 0x44, 0x44, 0x49, 0x54,
	0x49, 0x4f, 0x4e, 0x41, 0x4c, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f,
	0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x53, 0x10, 0x3a, 0x12,
	0x18, 0x0a, 0x14, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x43,
	0x48, 0x41, 0x4e, 0x4e, 0x45, 0x4c, 0x53, 0x10, 0x4c, 0x12, 0x19, 0x0a, 0x15, 0x49, 0x4e, 0x47,
	0x52, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46,
	0x45, 0x52, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x41, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x41,
	0x50, 0x49, 0x10, 0x04, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x52, 0x55, 0x54, 0x45, 0x5f, 0x46, 0x4f,
	0x52, 0x43, 0x45, 0x10, 0x2c, 0x12, 0x18, 0x0a, 0x14, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54,
	0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x5e, 0x12,
	0x12, 0x0a, 0x0e, 0x53, 0x48, 0x41, 0x52, 0x45, 0x44, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45,
	0x53, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x45, 0x4e, 0x43, 0x4f,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x4d, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41,
	0x52, 0x44, 0x5f, 0x45, 0x4e, 0x43, 0x4f, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x4e, 0x12, 0x1d, 0x0a,
	0x19, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x4d, 0x41,
	0x4e, 0x49, 0x50, 0x55, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x21, 0x12, 0x20, 0x0a, 0x1c,
	0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x5f, 0x49, 0x4d, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x54, 0x48, 0x45, 0x46, 0x54, 0x10, 0x27, 0x12, 0x12,
	0x0a, 0x0e, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54,
	0x10, 0x4f, 0x12, 0x11, 0x0a, 0x0d, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x41, 0x43, 0x43, 0x4f,
	0x55, 0x4e, 0x54, 0x10, 0x50, 0x12, 0x24, 0x0a, 0x20, 0x44, 0x45, 0x4f, 0x42, 0x46, 0x55, 0x53,
	0x43, 0x41, 0x54, 0x45, 0x5f, 0x44, 0x45, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x46, 0x49, 0x4c, 0x45,
	0x53, 0x5f, 0x4f, 0x52, 0x5f, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x5f, 0x12, 0x25, 0x0a, 0x21, 0x45,
	0x58, 0x50, 0x4c, 0x4f, 0x49, 0x54, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x46, 0x41,
	0x43, 0x49, 0x4e, 0x47, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x1b, 0x12, 0x1c, 0x0a, 0x17, 0x53, 0x55, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x43, 0x48, 0x41,
	0x49, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45, 0x10, 0x81, 0x01,
	0x12, 0x3b, 0x0a, 0x36, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f, 0x4d, 0x49, 0x53, 0x45, 0x5f, 0x53,
	0x4f, 0x46, 0x54, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x44, 0x45, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x4e,
	0x43, 0x49, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50,
	0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x10, 0x82, 0x01, 0x12, 0x26, 0x0a,
	0x21, 0x45, 0x58, 0x50, 0x4c, 0x4f, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x4f,
	0x52, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x86, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x45, 0x58,
	0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x45, 0x12, 0x3e, 0x0a, 0x39, 0x4c, 0x49, 0x4e,
	0x55, 0x58, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x4d, 0x41, 0x43, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x5f,
	0x41, 0x4e, 0x44, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x4f, 0x52, 0x59, 0x5f, 0x50, 0x45,
	0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49,
	0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x87, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x44, 0x4f, 0x4d,
	0x41, 0x49, 0x4e, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46,
	0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x1e, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x41, 0x54,
	0x41, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x52, 0x55, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x1d, 0x12,
	0x1e, 0x0a, 0x19, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x45,
	0x44, 0x5f, 0x46, 0x4f, 0x52, 0x5f, 0x49, 0x4d, 0x50, 0x41, 0x43, 0x54, 0x10, 0x84, 0x01, 0x12,
	0x10, 0x0a, 0x0c, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x50, 0x10,
	0x34, 0x12, 0x1b, 0x0a, 0x17, 0x49, 0x4e, 0x48, 0x49, 0x42, 0x49, 0x54, 0x5f, 0x53, 0x59, 0x53,
	0x54, 0x45, 0x4d, 0x5f, 0x52, 0x45, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x24, 0x12, 0x17,
	0x0a, 0x13, 0x46, 0x49, 0x52, 0x4d, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x43, 0x4f, 0x52, 0x52, 0x55,
	0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x51, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x48, 0x49, 0x4a, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x08, 0x12,
	0x1d, 0x0a, 0x19, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x41,
	0x4c, 0x5f, 0x4f, 0x46, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x11, 0x12, 0x1b,
	0x0a, 0x17, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10, 0x30, 0x12, 0x22, 0x0a, 0x1e, 0x53,
	0x54, 0x45, 0x41, 0x4c, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x2a, 0x12,
	0x1a, 0x0a, 0x16, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x41, 0x4c, 0x10, 0x33, 0x12, 0x22, 0x0a, 0x1e, 0x54,
	0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x54, 0x4f, 0x5f,
	0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x5b, 0x12,
	0x1c, 0x0a, 0x18, 0x53, 0x54, 0x45, 0x41, 0x4c, 0x5f, 0x57, 0x45, 0x42, 0x5f, 0x53, 0x45, 0x53,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4f, 0x4b, 0x49, 0x45, 0x10, 0x19, 0x12, 0x23, 0x0a,
	0x1f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46,
	0x59, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x18, 0x12, 0x1d, 0x0a, 0x19, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x52, 0x49, 0x47,
	0x47, 0x45, 0x52, 0x45, 0x44, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x41, 0x12, 0x25, 0x0a, 0x21, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x52, 0x5f, 0x4c, 0x4f, 0x47,
	0x4f, 0x4e, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x53, 0x54, 0x41, 0x52, 0x54, 0x5f, 0x45, 0x58, 0x45,
	0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x52, 0x12, 0x21, 0x0a, 0x1d, 0x4b, 0x45, 0x52, 0x4e,
	0x45, 0x4c, 0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x45,
	0x58, 0x54, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x53, 0x10, 0x53, 0x12, 0x19, 0x0a, 0x15, 0x53,
	0x48, 0x4f, 0x52, 0x54, 0x43, 0x55, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x49, 0x43, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x7f, 0x12, 0x25, 0x0a, 0x21, 0x41, 0x42, 0x55, 0x53, 0x45, 0x5f,
	0x45, 0x4c, 0x45, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f,
	0x4c, 0x5f, 0x4d, 0x45, 0x43, 0x48, 0x41, 0x4e, 0x49, 0x53, 0x4d, 0x10, 0x22, 0x12, 0x38, 0x0a,
	0x33, 0x41, 0x42, 0x55, 0x53, 0x45, 0x5f, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x5f, 0x4d, 0x45, 0x43, 0x48, 0x41, 0x4e, 0x49,
	0x53, 0x4d, 0x5f, 0x53, 0x45, 0x54, 0x55, 0x49, 0x44, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x45,
	0x54, 0x47, 0x49, 0x44, 0x10, 0x88, 0x01, 0x12, 0x3b, 0x0a, 0x37, 0x41, 0x42, 0x55, 0x53, 0x45,
	0x5f, 0x45, 0x4c, 0x45, 0x56, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x52,
	0x4f, 0x4c, 0x5f, 0x4d, 0x45, 0x43, 0x48, 0x41, 0x4e, 0x49, 0x53, 0x4d, 0x5f, 0x53, 0x55, 0x44,
	0x4f, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x53, 0x55, 0x44, 0x4f, 0x5f, 0x43, 0x41, 0x43, 0x48, 0x49,
	0x4e, 0x47, 0x10, 0x6d, 0x12, 0x19, 0x0a, 0x15, 0x55, 0x4e, 0x53, 0x45, 0x43, 0x55, 0x52, 0x45,
	0x44, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x10, 0x0d, 0x12,
	0x18, 0x0a, 0x14, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x5f, 0x49,
	0x4e, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x10, 0x69, 0x12, 0x10, 0x0a, 0x0c, 0x42, 0x41, 0x53,
	0x48, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x60, 0x12, 0x10, 0x0a, 0x0c, 0x50,
	0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x4b, 0x45, 0x59, 0x53, 0x10, 0x61, 0x12, 0x19, 0x0a,
	0x15, 0x53, 0x55, 0x42, 0x56, 0x45, 0x52, 0x54, 0x5f, 0x54, 0x52, 0x55, 0x53, 0x54, 0x5f, 0x43,
	0x4f, 0x4e, 0x54, 0x52, 0x4f, 0x4c, 0x10, 0x6a, 0x12, 0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4c, 0x4c, 0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
	0x43, 0x41, 0x54, 0x45, 0x10, 0x6b, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x50, 0x52, 0x4f,
	0x4d, 0x49, 0x53, 0x45, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x5f, 0x53, 0x4f, 0x46, 0x54, 0x57, 0x41,
	0x52, 0x45, 0x5f, 0x42, 0x49, 0x4e, 0x41, 0x52, 0x59, 0x10, 0x54, 0x12, 0x24, 0x0a, 0x20, 0x43,
	0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41, 0x4c, 0x53, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f,
	0x50, 0x41, 0x53, 0x53, 0x57, 0x4f, 0x52, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x53, 0x10,
	0x62, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x5f, 0x41, 0x55, 0x54, 0x48,
	0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x53, 0x53, 0x10, 0x1c, 0x12, 0x24, 0x0a, 0x20, 0x50, 0x4c, 0x55, 0x47, 0x47, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x53, 0x10, 0x6c, 0x12, 0x20, 0x0a, 0x1b, 0x4d, 0x55,
	0x4c, 0x54, 0x49, 0x5f, 0x46, 0x41, 0x43, 0x54, 0x4f, 0x52, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x45,
	0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x89, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x49, 0x4d, 0x50, 0x41, 0x49, 0x52, 0x5f, 0x44, 0x45, 0x46, 0x45, 0x4e, 0x53, 0x45, 0x53, 0x10,
	0x1f, 0x12, 0x1b, 0x0a, 0x17, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x5f, 0x4f, 0x52, 0x5f,
	0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x53, 0x10, 0x37, 0x12, 0x16,
	0x0a, 0x12, 0x49, 0x4e, 0x44, 0x49, 0x43, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x49, 0x4e, 0x47, 0x10, 0x6e, 0x12, 0x28, 0x0a, 0x24, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c,
	0x45, 0x5f, 0x4f, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x5f, 0x4c, 0x49, 0x4e, 0x55,
	0x58, 0x5f, 0x41, 0x55, 0x44, 0x49, 0x54, 0x5f, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x6f,
	0x12, 0x12, 0x0a, 0x0e, 0x48, 0x49, 0x44, 0x45, 0x5f, 0x41, 0x52, 0x54, 0x49, 0x46, 0x41, 0x43,
	0x54, 0x53, 0x10, 0x55, 0x12, 0x20, 0x0a, 0x1c, 0x48, 0x49, 0x44, 0x44, 0x45, 0x4e, 0x5f, 0x46,
	0x49, 0x4c, 0x45, 0x53, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x4f,
	0x52, 0x49, 0x45, 0x53, 0x10, 0x56, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x49, 0x44, 0x44, 0x45, 0x4e,
	0x5f, 0x55, 0x53, 0x45, 0x52, 0x53, 0x10, 0x57, 0x12, 0x21, 0x0a, 0x1d, 0x45, 0x58, 0x46, 0x49,
	0x4c, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x5f, 0x57, 0x45,
	0x42, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x14, 0x12, 0x21, 0x0a, 0x1d, 0x45,
	0x58, 0x46, 0x49, 0x4c, 0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x4f, 0x5f, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10, 0x15, 0x12, 0x16,
	0x0a, 0x12, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x12, 0x19, 0x0a, 0x15, 0x4c, 0x41, 0x54, 0x45, 0x52, 0x41,
	0x4c, 0x5f, 0x54, 0x4f, 0x4f, 0x4c, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x10,
	0x29, 0x12, 0x19, 0x0a, 0x15, 0x48, 0x49, 0x4a, 0x41, 0x43, 0x4b, 0x5f, 0x45, 0x58, 0x45, 0x43,
	0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x4c, 0x4f, 0x57, 0x10, 0x70, 0x12, 0x32, 0x0a, 0x2e,
	0x48, 0x49, 0x4a, 0x41, 0x43, 0x4b, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x44, 0x59, 0x4e, 0x41, 0x4d, 0x49, 0x43, 0x5f, 0x4c, 0x49,
	0x4e, 0x4b, 0x45, 0x52, 0x5f, 0x48, 0x49, 0x4a, 0x41, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x71,
	0x12, 0x27, 0x0a, 0x23, 0x4d, 0x4f, 0x44, 0x49, 0x46, 0x59, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44,
	0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x49, 0x4e, 0x46, 0x52, 0x41, 0x53, 0x54,
	0x52, 0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x10, 0x1a, 0x12, 0x13, 0x0a, 0x0f, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x45, 0x5f, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f, 0x54, 0x10, 0x36, 0x12, 0x22,
	0x0a, 0x1e, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x49, 0x4e, 0x46, 0x52, 0x41, 0x53, 0x54, 0x52,
	0x55, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59,
	0x10, 0x35, 0x12, 0x18, 0x0a, 0x14, 0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x5f, 0x43, 0x41,
	0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x63, 0x12, 0x20, 0x0a, 0x1c,
	0x44, 0x45, 0x56, 0x45, 0x4c, 0x4f, 0x50, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49,
	0x54, 0x49, 0x45, 0x53, 0x5f, 0x4d, 0x41, 0x4c, 0x57, 0x41, 0x52, 0x45, 0x10, 0x64, 0x12, 0x17,
	0x0a, 0x13, 0x4f, 0x42, 0x54, 0x41, 0x49, 0x4e, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x2b, 0x12, 0x1f, 0x0a, 0x1b, 0x4f, 0x42, 0x54, 0x41, 0x49,
	0x4e, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x49, 0x45, 0x53, 0x5f, 0x4d,
	0x41, 0x4c, 0x57, 0x41, 0x52, 0x45, 0x10, 0x65, 0x12, 0x28, 0x0a, 0x23, 0x4f, 0x42, 0x54, 0x41,
	0x49, 0x4e, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x49, 0x45, 0x53, 0x5f,
	0x56, 0x55, 0x4c, 0x4e, 0x45, 0x52, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x49, 0x45, 0x53, 0x10,
	0x85, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f, 0x53, 0x43, 0x41,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x53, 0x43, 0x41, 0x4e, 0x4e,
	0x49, 0x4e, 0x47, 0x5f, 0x49, 0x50, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x53, 0x10, 0x02, 0x12,
	0x16, 0x0a, 0x12, 0x53, 0x54, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c,
	0x49, 0x54, 0x49, 0x45, 0x53, 0x10, 0x58, 0x12, 0x12, 0x0a, 0x0e, 0x55, 0x50, 0x4c, 0x4f, 0x41,
	0x44, 0x5f, 0x4d, 0x41, 0x4c, 0x57, 0x41, 0x52, 0x45, 0x10, 0x66, 0x12, 0x24, 0x0a, 0x20, 0x43,
	0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x41, 0x44, 0x4d, 0x49, 0x4e, 0x49, 0x53,
	0x54, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x4d, 0x41, 0x4e, 0x44, 0x10,
	0x3c, 0x12, 0x14, 0x0a, 0x10, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x54,
	0x41, 0x49, 0x4e, 0x45, 0x52, 0x10, 0x42, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x53, 0x43, 0x41, 0x50,
	0x45, 0x5f, 0x54, 0x4f, 0x5f, 0x48, 0x4f, 0x53, 0x54, 0x10, 0x3d, 0x12, 0x24, 0x0a, 0x20, 0x43,
	0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x45, 0x52, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52, 0x59, 0x10,
	0x39, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x46, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x56, 0x45, 0x5f,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x5c, 0x12, 0x2e,
	0x0a, 0x2a, 0x53, 0x54, 0x45, 0x41, 0x4c, 0x5f, 0x4f, 0x52, 0x5f, 0x46, 0x4f, 0x52, 0x47, 0x45,
	0x5f, 0x41, 0x55, 0x54, 0x48, 0x45, 0x4e, 0x54, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x53, 0x10, 0x3e, 0x12, 0x14,
	0x0a, 0x0f, 0x46, 0x49, 0x4e, 0x41, 0x4e, 0x43, 0x49, 0x41, 0x4c, 0x5f, 0x54, 0x48, 0x45, 0x46,
	0x54, 0x10, 0x83, 0x01, 0x42, 0xea, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x10, 0x4d, 0x69, 0x74,
	0x72, 0x65, 0x41, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x73, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x1e, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72,
	0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c, 0x56, 0x32, 0xea, 0x02, 0x21,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3a, 0x3a, 0x56,
	0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescData = file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_securitycenter_v2_mitre_attack_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_mitre_attack_proto_goTypes = []any{
	(MitreAttack_Tactic)(0),    // 0: google.cloud.securitycenter.v2.MitreAttack.Tactic
	(MitreAttack_Technique)(0), // 1: google.cloud.securitycenter.v2.MitreAttack.Technique
	(*MitreAttack)(nil),        // 2: google.cloud.securitycenter.v2.MitreAttack
}
var file_google_cloud_securitycenter_v2_mitre_attack_proto_depIdxs = []int32{
	0, // 0: google.cloud.securitycenter.v2.MitreAttack.primary_tactic:type_name -> google.cloud.securitycenter.v2.MitreAttack.Tactic
	1, // 1: google.cloud.securitycenter.v2.MitreAttack.primary_techniques:type_name -> google.cloud.securitycenter.v2.MitreAttack.Technique
	0, // 2: google.cloud.securitycenter.v2.MitreAttack.additional_tactics:type_name -> google.cloud.securitycenter.v2.MitreAttack.Tactic
	1, // 3: google.cloud.securitycenter.v2.MitreAttack.additional_techniques:type_name -> google.cloud.securitycenter.v2.MitreAttack.Technique
	4, // [4:4] is the sub-list for method output_type
	4, // [4:4] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_mitre_attack_proto_init() }
func file_google_cloud_securitycenter_v2_mitre_attack_proto_init() {
	if File_google_cloud_securitycenter_v2_mitre_attack_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_mitre_attack_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_mitre_attack_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_mitre_attack_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_mitre_attack_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_mitre_attack_proto = out.File
	file_google_cloud_securitycenter_v2_mitre_attack_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_mitre_attack_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_mitre_attack_proto_depIdxs = nil
}
