/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class DingtekProtocolDecoder
extends BaseProtocolDecoder {
    public DingtekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        String sentence = (String)msg;
        int type = Integer.parseInt(sentence.substring(6, 8), 16);
        if (type == 1 || type == 2 || type == 4) {
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(sentence));
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            String imei = ByteBufUtil.hexDump((ByteBuf)buf.slice(buf.writerIndex() - 9, 8)).substring(1);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession == null) {
                return null;
            }
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date());
            position.set("height", buf.readUnsignedShort());
            position.setValid(buf.readUnsignedByte() > 0);
            position.setLongitude(buf.readFloat());
            position.setLatitude(buf.readFloat());
            position.set("temp1", buf.readUnsignedByte());
            position.set("status", buf.readUnsignedInt());
            position.set("battery", (double)buf.readUnsignedShort() * 0.001);
            position.set("rssi", Float.valueOf(buf.readFloat()));
            position.set("index", buf.readUnsignedShort());
            return position;
        }
        return null;
    }
}

