/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.client.MongoCollection;
import java.util.Collections;
import java.util.Iterator;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.convert.ReferenceResolver;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.lang.Nullable;

public interface ReferenceLoader {
    @Nullable
    default public Document fetchOne(DocumentReferenceQuery referenceQuery, ReferenceResolver.ReferenceCollection context) {
        Iterator<Document> it = this.fetchMany(referenceQuery, context).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public Iterable<Document> fetchMany(DocumentReferenceQuery var1, ReferenceResolver.ReferenceCollection var2);

    public static interface DocumentReferenceQuery {
        public Bson getQuery();

        default public Bson getSort() {
            return new Document();
        }

        default public Iterable<Document> apply(MongoCollection<Document> collection) {
            return this.restoreOrder((Iterable<Document>)collection.find(this.getQuery()).sort(this.getSort()));
        }

        default public Iterable<Document> restoreOrder(Iterable<Document> documents) {
            return documents;
        }

        public static DocumentReferenceQuery forSingleDocument(final Bson bson) {
            return new DocumentReferenceQuery(){

                @Override
                public Bson getQuery() {
                    return bson;
                }

                @Override
                public Iterable<Document> apply(MongoCollection<Document> collection) {
                    Document result = (Document)collection.find(this.getQuery()).sort(this.getSort()).limit(1).first();
                    return result != null ? Collections.singleton(result) : Collections.emptyList();
                }
            };
        }

        public static DocumentReferenceQuery forManyDocuments(final Bson bson) {
            return new DocumentReferenceQuery(){

                @Override
                public Bson getQuery() {
                    return bson;
                }

                @Override
                public Iterable<Document> apply(MongoCollection<Document> collection) {
                    return collection.find(this.getQuery()).sort(this.getSort());
                }
            };
        }

        public static DocumentReferenceQuery forNoResult() {
            return NoResultsFilter.INSTANCE;
        }
    }

    public static enum NoResultsFilter implements DocumentReferenceQuery
    {
        INSTANCE;

        private static final Document NO_RESULTS_PREDICATE;

        @Override
        public Bson getQuery() {
            return NO_RESULTS_PREDICATE;
        }

        static {
            NO_RESULTS_PREDICATE = new Document(FieldName.ID.name(), (Object)new Document("$exists", (Object)false));
        }
    }
}

