/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.auth.eap.leap.client;

import com.axlradius.radclient4.ClientReceiveException;
import com.axlradius.radclient4.ClientSendException;
import com.axlradius.radclient4.RADIUSClient;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.attributes.AttributeList;
import com.axlradius.radclient4.attributes.Cisco;
import com.axlradius.radclient4.attributes.VendorSpecific;
import com.axlradius.radclient4.auth.eap.ClientLayer;
import com.axlradius.radclient4.auth.eap.EAPException;
import com.axlradius.radclient4.auth.eap.EAPPacket;
import com.axlradius.radclient4.auth.eap.EAPParameters;
import com.axlradius.radclient4.auth.eap.EAPType;
import com.axlradius.radclient4.auth.eap.PublicState;
import com.axlradius.radclient4.auth.eap.leap.client.LEAPClientParameters;
import com.axlradius.radclient4.auth.eap.leap.client.a;
import com.axlradius.radclient4.auth.eap.tls.c;
import com.axlradius.radclient4.auth.mschap.MSChap;
import com.axlradius.radclient4.dictionary.BD;
import com.axlradius.radclient4.radutil.RADIUSEncode;
import com.axlradius.radclient4.radutil.Util;
import java.net.SocketException;
import java.security.MessageDigest;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class LEAPClient
implements com.axlradius.radclient4.auth.eap.tls.ttls.client.c {
    private RADIUSClient a;
    private ClientLayer a;
    private boolean debug;
    private LEAPClientParameters a;
    private a a;
    private int T = 3;
    private MSChap a;
    private byte[] y;
    private byte[] z;
    private byte[] A;
    private byte[] B;
    private PublicState a;

    public LEAPClient(RADIUSClient rADIUSClient) {
        this.a = rADIUSClient;
        this.debug = rADIUSClient.getDebugIndicator();
        BD.addDictionary(new Cisco());
    }

    public LEAPClient() {
    }

    @Override
    public final void a(EAPPacket eAPPacket) {
        try {
            this.a = new a(eAPPacket);
            return;
        }
        catch (EAPException eAPException) {
            this.logToDebug("Error creating LEAP packet: " + eAPException.getMessage());
            return;
        }
    }

    public static EAPType getEAPType() {
        return EAPType.TYPE.LEAP.getType();
    }

    @Override
    public final void a(EAPParameters eAPParameters) {
        this.a = (LEAPClientParameters)eAPParameters;
        this.a = this.a.getClientLayer();
    }

    @Override
    public final PublicState authenticate() throws RADIUSException, ClientSendException, SocketException, ClientReceiveException, EAPException {
        this.a = PublicState.CONTINUE;
        try {
            this.a = new MSChap();
        }
        catch (Exception exception) {
            return this.a(exception.getMessage());
        }
        Object object = null;
        this.T = 3;
        if (this.a == null) {
            object = this.getStateName() + " ";
            object = (String)object + "Initial EAP packet not set, failed to invoke setInitialEAPPacket()";
            return this.a((String)object);
        }
        do {
            if (this.debug) {
                this.logToDebug("LEAPClient.State for receive is " + this.getStateName());
            }
            switch (this.T) {
                case 3: {
                    byte[] byArray = this.a.g();
                    this.y = new byte[8];
                    try {
                        System.arraycopy(byArray, 0, this.y, 0, 8);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return this.a(this.getStateName() + " Challenge length error. expecting 8 EAP data contained " + byArray.length + " bytes");
                    }
                    if (this.debug) {
                        this.logToDebug("LEAPClient: Recieved challenge " + Util.toHexString(this.y) + " length " + this.y.length);
                    }
                    try {
                        this.z = this.a.NtChallengeResponse(this.y, this.a.getPassword(), this.a.getPasswordType());
                        if (this.debug) {
                            this.logToDebug("EAP-LEAP: Creating ntHash using challenge: " + Util.toHexString(this.y) + " to create response " + Util.toHexString(this.z));
                        }
                        this.a = new a(2, this.z);
                        object = this.a.toAttributeList();
                        if (this.debug) {
                            this.logToDebug("EAP-LEAP: Sending NtChallengeResponse: " + Util.toHexString(this.z) + " length " + this.z.length);
                        }
                        this.T = 5;
                        break;
                    }
                    catch (RADIUSException rADIUSException) {
                        return this.a(rADIUSException.getMessage());
                    }
                }
                case 5: {
                    if (this.a.getCode() != 3) {
                        return this.a("Expected SUCCESS, found " + this.a);
                    }
                    if (this.debug) {
                        this.logToDebug("EAP-LEAP: EAP Success received.");
                    }
                    this.A = MSChap.createChallenge();
                    this.a = new a(1, this.A);
                    object = this.a.toAttributeList();
                    if (this.debug) {
                        this.logToDebug("EAP-LEAP: Sending APC challenge " + Util.toHexString(this.A));
                    }
                    this.T = 7;
                    break;
                }
                case 7: {
                    Object object2;
                    byte[] byArray = this.a.g();
                    this.B = new byte[24];
                    System.arraycopy(byArray, 0, this.B, 0, 24);
                    object = ((AttributeList)object).getVendorSpecific(9);
                    if (((VendorSpecific[])object).length == 0 || ((VendorSpecific[])object).length > 1) {
                        object = ((VendorSpecific[])object).length == 0 ? "Expecting Cisco VSA with session key, but none found in final packet." : "Too many Cisco VSA's  expecting 1, found " + ((VendorSpecific[])object).length;
                        object = "EAP-LEAP: " + (String)object;
                        if (this.debug) {
                            this.logToDebug((String)object);
                        }
                        return this.a((String)object);
                    }
                    if (this.debug) {
                        this.logToDebug("EAP-LEAP: Cisco VSA:\n" + object[0]);
                    }
                    byte[] byArray2 = object[0].getAttributeAt(0).getData();
                    object = byArray2;
                    byArray = new byte[byArray2.length - 17];
                    try {
                        System.arraycopy(object, 17, byArray, 0, byArray.length);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        return this.a(this.getStateName() + " Cisco VSA data length error. expecting " + byArray.length + " VSA data contained " + ((VendorSpecific[])object).length + " bytes");
                    }
                    object = RADIUSEncode.saltDecode(byArray, this.a.getSecret(), this.a.getAuthenticator());
                    byArray = this.a.getPasswordType() == MSChap.PasswordType.PLAINTEXT ? this.a.NtPasswordHash(this.a.toUnicode(this.a.getPassword())) : this.a.getPassword();
                    byArray = this.a.HashNtPasswordHash(byArray);
                    byte[] byArray3 = new byte[16];
                    System.arraycopy(byArray, 0, byArray3, 0, 16);
                    try {
                        object2 = this.a.ChallengeResponse(this.A, byArray);
                    }
                    catch (RADIUSException rADIUSException) {
                        Util.clean(byArray);
                        Util.clean(byArray3);
                        object = "Can't access DES encoding algorithm - " + rADIUSException.getMessage();
                        return this.a(this.getStateName() + " " + (String)object);
                    }
                    if (!Util.cmp((byte[])object2, this.B)) {
                        Util.clean((byte[])object2);
                        return this.a(this.getStateName() + " AP response doesn't match expected response.");
                    }
                    Util.clean((byte[])object2);
                    this.logToDebug("SEND_APC_RESPONSE_STEP5:");
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: Session key creation.");
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: Password Hash Hash " + Util.toHexString(byArray3));
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: Peer Challenge " + Util.toHexString(this.y));
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: Peer Response " + Util.toHexString(this.z));
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: AP challenge " + Util.toHexString(this.A));
                    this.logToDebug("SEND_APC_RESPONSE_STEP5: AP response " + Util.toHexString(this.B));
                    MessageDigest messageDigest = c.d();
                    object2 = messageDigest;
                    messageDigest.getDigestLength();
                    ((MessageDigest)object2).update(byArray3);
                    ((MessageDigest)object2).update(this.A);
                    ((MessageDigest)object2).update(this.B);
                    ((MessageDigest)object2).update(this.y);
                    ((MessageDigest)object2).update(this.z);
                    byArray = ((MessageDigest)object2).digest();
                    if (!Util.cmp(byArray, (byte[])object)) {
                        Util.clean(byArray3);
                        Util.clean(byArray);
                        return this.a("Session key is incorrect.");
                    }
                    Util.clean(byArray3);
                    Util.clean(byArray);
                    this.a.g((byte[])object);
                    if (this.debug) {
                        this.logToDebug("EAP-LEAP: Session key - length " + this.a.getSessionKey().length + ", " + Util.toHexString(this.a.getSessionKey()));
                    }
                    this.T = 0;
                    object = this;
                    this.a = PublicState.COMPLETE;
                    super.clean();
                    return ((LEAPClient)object).a;
                }
                default: {
                    return this.a("Internal error - Unknown state found while receiving data: " + this.getStateName());
                }
            }
            try {
                object = this.a.transaction(this.a, (AttributeList)object);
            }
            catch (Exception exception) {
                return this.a("Exception: " + exception);
            }
            this.a.getPacketType();
            this.a = new a((AttributeList)object);
        } while (this.T != 7 || this.a.getCode() == 2);
        return this.a("Expecting EAP code RESPONSE, found " + this.a.getCodeName());
    }

    private String getStateName() {
        String string;
        switch (this.T) {
            case 3: {
                string = "AP_CHALLENGE_STEP1";
                break;
            }
            case 4: {
                string = "MSCHAP_RESPONSE_STEP2";
                break;
            }
            case 5: {
                string = "SEND_SUCCESS_STEP3";
                break;
            }
            case 6: {
                string = "APC_REQUEST_STEP4";
                break;
            }
            case 7: {
                string = "SEND_APC_RESPONSE_STEP5";
                break;
            }
            case 0: {
                string = "NO_STATE";
                break;
            }
            default: {
                string = "Unknown (" + this.T + ")";
            }
        }
        return string;
    }

    private PublicState a(String string) {
        this.a = PublicState.ERROR;
        this.a.setMessage(string);
        this.clean();
        return this.a;
    }

    private void clean() {
        Util.clean(this.y);
        Util.clean(this.z);
        Util.clean(this.A);
        Util.clean(this.B);
        Util.clean(null);
    }

    private void logToDebug(String string) {
        if (this.debug) {
            this.a.logToDebug(string);
        }
    }
}

