/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	resource "k8s.io/apimachinery/pkg/api/resource"
	types "k8s.io/apimachinery/pkg/types"
)

// DeviceRequestAllocationResultApplyConfiguration represents a declarative configuration of the DeviceRequestAllocationResult type for use
// with apply.
type DeviceRequestAllocationResultApplyConfiguration struct {
	Request                  *string                                             `json:"request,omitempty"`
	Driver                   *string                                             `json:"driver,omitempty"`
	Pool                     *string                                             `json:"pool,omitempty"`
	Device                   *string                                             `json:"device,omitempty"`
	AdminAccess              *bool                                               `json:"adminAccess,omitempty"`
	Tolerations              []DeviceTolerationApplyConfiguration                `json:"tolerations,omitempty"`
	BindingConditions        []string                                            `json:"bindingConditions,omitempty"`
	BindingFailureConditions []string                                            `json:"bindingFailureConditions,omitempty"`
	ShareID                  *types.UID                                          `json:"shareID,omitempty"`
	ConsumedCapacity         map[resourcev1beta2.QualifiedName]resource.Quantity `json:"consumedCapacity,omitempty"`
}

// DeviceRequestAllocationResultApplyConfiguration constructs a declarative configuration of the DeviceRequestAllocationResult type for use with
// apply.
func DeviceRequestAllocationResult() *DeviceRequestAllocationResultApplyConfiguration {
	return &DeviceRequestAllocationResultApplyConfiguration{}
}

// WithRequest sets the Request field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Request field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithRequest(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Request = &value
	return b
}

// WithDriver sets the Driver field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Driver field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithDriver(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Driver = &value
	return b
}

// WithPool sets the Pool field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Pool field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithPool(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Pool = &value
	return b
}

// WithDevice sets the Device field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Device field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithDevice(value string) *DeviceRequestAllocationResultApplyConfiguration {
	b.Device = &value
	return b
}

// WithAdminAccess sets the AdminAccess field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AdminAccess field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithAdminAccess(value bool) *DeviceRequestAllocationResultApplyConfiguration {
	b.AdminAccess = &value
	return b
}

// WithTolerations adds the given value to the Tolerations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Tolerations field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithTolerations(values ...*DeviceTolerationApplyConfiguration) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithTolerations")
		}
		b.Tolerations = append(b.Tolerations, *values[i])
	}
	return b
}

// WithBindingConditions adds the given value to the BindingConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingConditions field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithBindingConditions(values ...string) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		b.BindingConditions = append(b.BindingConditions, values[i])
	}
	return b
}

// WithBindingFailureConditions adds the given value to the BindingFailureConditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the BindingFailureConditions field.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithBindingFailureConditions(values ...string) *DeviceRequestAllocationResultApplyConfiguration {
	for i := range values {
		b.BindingFailureConditions = append(b.BindingFailureConditions, values[i])
	}
	return b
}

// WithShareID sets the ShareID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ShareID field is set to the value of the last call.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithShareID(value types.UID) *DeviceRequestAllocationResultApplyConfiguration {
	b.ShareID = &value
	return b
}

// WithConsumedCapacity puts the entries into the ConsumedCapacity field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the ConsumedCapacity field,
// overwriting an existing map entries in ConsumedCapacity field with the same key.
func (b *DeviceRequestAllocationResultApplyConfiguration) WithConsumedCapacity(entries map[resourcev1beta2.QualifiedName]resource.Quantity) *DeviceRequestAllocationResultApplyConfiguration {
	if b.ConsumedCapacity == nil && len(entries) > 0 {
		b.ConsumedCapacity = make(map[resourcev1beta2.QualifiedName]resource.Quantity, len(entries))
	}
	for k, v := range entries {
		b.ConsumedCapacity[k] = v
	}
	return b
}
