// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/channel/v1/repricing.proto

package channelpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	decimal "google.golang.org/genproto/googleapis/type/decimal"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the different costs that the modified bill can be based on.
type RebillingBasis int32

const (
	// Not used.
	RebillingBasis_REBILLING_BASIS_UNSPECIFIED RebillingBasis = 0
	// Use the list cost, also known as the MSRP.
	RebillingBasis_COST_AT_LIST RebillingBasis = 1
	// Pass through all discounts except the Reseller Program Discount. If this is
	// the default cost base and no adjustments are specified, the output cost
	// will be exactly what the customer would see if they viewed the bill in the
	// Google Cloud Console.
	RebillingBasis_DIRECT_CUSTOMER_COST RebillingBasis = 2
)

// Enum value maps for RebillingBasis.
var (
	RebillingBasis_name = map[int32]string{
		0: "REBILLING_BASIS_UNSPECIFIED",
		1: "COST_AT_LIST",
		2: "DIRECT_CUSTOMER_COST",
	}
	RebillingBasis_value = map[string]int32{
		"REBILLING_BASIS_UNSPECIFIED": 0,
		"COST_AT_LIST":                1,
		"DIRECT_CUSTOMER_COST":        2,
	}
)

func (x RebillingBasis) Enum() *RebillingBasis {
	p := new(RebillingBasis)
	*p = x
	return p
}

func (x RebillingBasis) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RebillingBasis) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_repricing_proto_enumTypes[0].Descriptor()
}

func (RebillingBasis) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_repricing_proto_enumTypes[0]
}

func (x RebillingBasis) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RebillingBasis.Descriptor instead.
func (RebillingBasis) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{0}
}

// Configuration for how a reseller will reprice a Customer.
type CustomerRepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the CustomerRepricingConfig.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/customerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The configuration for bill modifications made by a reseller
	// before sending it to customers.
	RepricingConfig *RepricingConfig `protobuf:"bytes,2,opt,name=repricing_config,json=repricingConfig,proto3" json:"repricing_config,omitempty"`
	// Output only. Timestamp of an update to the repricing rule. If `update_time`
	// is after
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// then it indicates this was set mid-month.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *CustomerRepricingConfig) Reset() {
	*x = CustomerRepricingConfig{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CustomerRepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CustomerRepricingConfig) ProtoMessage() {}

func (x *CustomerRepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CustomerRepricingConfig.ProtoReflect.Descriptor instead.
func (*CustomerRepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{0}
}

func (x *CustomerRepricingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CustomerRepricingConfig) GetRepricingConfig() *RepricingConfig {
	if x != nil {
		return x.RepricingConfig
	}
	return nil
}

func (x *CustomerRepricingConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration for how a distributor will rebill a channel partner
// (also known as a distributor-authorized reseller).
type ChannelPartnerRepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the ChannelPartnerRepricingConfig.
	// Format:
	// accounts/{account_id}/channelPartnerLinks/{channel_partner_id}/channelPartnerRepricingConfigs/{id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The configuration for bill modifications made by a reseller
	// before sending it to ChannelPartner.
	RepricingConfig *RepricingConfig `protobuf:"bytes,2,opt,name=repricing_config,json=repricingConfig,proto3" json:"repricing_config,omitempty"`
	// Output only. Timestamp of an update to the repricing rule. If `update_time`
	// is after
	// [RepricingConfig.effective_invoice_month][google.cloud.channel.v1.RepricingConfig.effective_invoice_month]
	// then it indicates this was set mid-month.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *ChannelPartnerRepricingConfig) Reset() {
	*x = ChannelPartnerRepricingConfig{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChannelPartnerRepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChannelPartnerRepricingConfig) ProtoMessage() {}

func (x *ChannelPartnerRepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ChannelPartnerRepricingConfig.ProtoReflect.Descriptor instead.
func (*ChannelPartnerRepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{1}
}

func (x *ChannelPartnerRepricingConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ChannelPartnerRepricingConfig) GetRepricingConfig() *RepricingConfig {
	if x != nil {
		return x.RepricingConfig
	}
	return nil
}

func (x *ChannelPartnerRepricingConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Configuration for repricing a Google bill over a period of time.
type RepricingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Defines the granularity for repricing.
	//
	// Types that are assignable to Granularity:
	//
	//	*RepricingConfig_EntitlementGranularity_
	//	*RepricingConfig_ChannelPartnerGranularity_
	Granularity isRepricingConfig_Granularity `protobuf_oneof:"granularity"`
	// Required. The YearMonth when these adjustments activate. The Day field
	// needs to be "0" since we only accept YearMonth repricing boundaries.
	EffectiveInvoiceMonth *date.Date `protobuf:"bytes,1,opt,name=effective_invoice_month,json=effectiveInvoiceMonth,proto3" json:"effective_invoice_month,omitempty"`
	// Required. Information about the adjustment.
	Adjustment *RepricingAdjustment `protobuf:"bytes,2,opt,name=adjustment,proto3" json:"adjustment,omitempty"`
	// Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
	// use for this bill. Specifies the relative cost based on repricing costs you
	// will apply.
	RebillingBasis RebillingBasis `protobuf:"varint,3,opt,name=rebilling_basis,json=rebillingBasis,proto3,enum=google.cloud.channel.v1.RebillingBasis" json:"rebilling_basis,omitempty"`
	// The conditional overrides to apply for this configuration. If you list
	// multiple overrides, only the first valid override is used.  If you don't
	// list any overrides, the API uses the normal adjustment and rebilling basis.
	ConditionalOverrides []*ConditionalOverride `protobuf:"bytes,6,rep,name=conditional_overrides,json=conditionalOverrides,proto3" json:"conditional_overrides,omitempty"`
}

func (x *RepricingConfig) Reset() {
	*x = RepricingConfig{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepricingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig) ProtoMessage() {}

func (x *RepricingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig.ProtoReflect.Descriptor instead.
func (*RepricingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2}
}

func (m *RepricingConfig) GetGranularity() isRepricingConfig_Granularity {
	if m != nil {
		return m.Granularity
	}
	return nil
}

func (x *RepricingConfig) GetEntitlementGranularity() *RepricingConfig_EntitlementGranularity {
	if x, ok := x.GetGranularity().(*RepricingConfig_EntitlementGranularity_); ok {
		return x.EntitlementGranularity
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/channel/v1/repricing.proto.
func (x *RepricingConfig) GetChannelPartnerGranularity() *RepricingConfig_ChannelPartnerGranularity {
	if x, ok := x.GetGranularity().(*RepricingConfig_ChannelPartnerGranularity_); ok {
		return x.ChannelPartnerGranularity
	}
	return nil
}

func (x *RepricingConfig) GetEffectiveInvoiceMonth() *date.Date {
	if x != nil {
		return x.EffectiveInvoiceMonth
	}
	return nil
}

func (x *RepricingConfig) GetAdjustment() *RepricingAdjustment {
	if x != nil {
		return x.Adjustment
	}
	return nil
}

func (x *RepricingConfig) GetRebillingBasis() RebillingBasis {
	if x != nil {
		return x.RebillingBasis
	}
	return RebillingBasis_REBILLING_BASIS_UNSPECIFIED
}

func (x *RepricingConfig) GetConditionalOverrides() []*ConditionalOverride {
	if x != nil {
		return x.ConditionalOverrides
	}
	return nil
}

type isRepricingConfig_Granularity interface {
	isRepricingConfig_Granularity()
}

type RepricingConfig_EntitlementGranularity_ struct {
	// Required. Applies the repricing configuration at the entitlement level.
	//
	// Note: If a
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// using
	// [RepricingConfig.EntitlementGranularity][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity]
	// becomes effective, then no existing or future
	// [RepricingConfig.ChannelPartnerGranularity][google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity]
	// will apply to the
	// [RepricingConfig.EntitlementGranularity.entitlement][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity.entitlement].
	// This is the recommended value for both
	// [CustomerRepricingConfig][google.cloud.channel.v1.CustomerRepricingConfig]
	// and
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig].
	EntitlementGranularity *RepricingConfig_EntitlementGranularity `protobuf:"bytes,4,opt,name=entitlement_granularity,json=entitlementGranularity,proto3,oneof"`
}

type RepricingConfig_ChannelPartnerGranularity_ struct {
	// Applies the repricing configuration at the channel partner level.
	// Only
	// [ChannelPartnerRepricingConfig][google.cloud.channel.v1.ChannelPartnerRepricingConfig]
	// supports this value. Deprecated: This is no longer supported. Use
	// [RepricingConfig.entitlement_granularity][google.cloud.channel.v1.RepricingConfig.entitlement_granularity]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/channel/v1/repricing.proto.
	ChannelPartnerGranularity *RepricingConfig_ChannelPartnerGranularity `protobuf:"bytes,5,opt,name=channel_partner_granularity,json=channelPartnerGranularity,proto3,oneof"`
}

func (*RepricingConfig_EntitlementGranularity_) isRepricingConfig_Granularity() {}

func (*RepricingConfig_ChannelPartnerGranularity_) isRepricingConfig_Granularity() {}

// A type that represents the various adjustments you can apply to a bill.
type RepricingAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A oneof that represents the different types for this adjustment.
	//
	// Types that are assignable to Adjustment:
	//
	//	*RepricingAdjustment_PercentageAdjustment
	Adjustment isRepricingAdjustment_Adjustment `protobuf_oneof:"adjustment"`
}

func (x *RepricingAdjustment) Reset() {
	*x = RepricingAdjustment{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepricingAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingAdjustment) ProtoMessage() {}

func (x *RepricingAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingAdjustment.ProtoReflect.Descriptor instead.
func (*RepricingAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{3}
}

func (m *RepricingAdjustment) GetAdjustment() isRepricingAdjustment_Adjustment {
	if m != nil {
		return m.Adjustment
	}
	return nil
}

func (x *RepricingAdjustment) GetPercentageAdjustment() *PercentageAdjustment {
	if x, ok := x.GetAdjustment().(*RepricingAdjustment_PercentageAdjustment); ok {
		return x.PercentageAdjustment
	}
	return nil
}

type isRepricingAdjustment_Adjustment interface {
	isRepricingAdjustment_Adjustment()
}

type RepricingAdjustment_PercentageAdjustment struct {
	// Flat markup or markdown on an entire bill.
	PercentageAdjustment *PercentageAdjustment `protobuf:"bytes,2,opt,name=percentage_adjustment,json=percentageAdjustment,proto3,oneof"`
}

func (*RepricingAdjustment_PercentageAdjustment) isRepricingAdjustment_Adjustment() {}

// An adjustment that applies a flat markup or markdown to an entire bill.
type PercentageAdjustment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The percentage of the bill to adjust.
	// For example:
	// Mark down by 1% => "-1.00"
	// Mark up by 1%   => "1.00"
	// Pass-Through    => "0.00"
	Percentage *decimal.Decimal `protobuf:"bytes,2,opt,name=percentage,proto3" json:"percentage,omitempty"`
}

func (x *PercentageAdjustment) Reset() {
	*x = PercentageAdjustment{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PercentageAdjustment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PercentageAdjustment) ProtoMessage() {}

func (x *PercentageAdjustment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PercentageAdjustment.ProtoReflect.Descriptor instead.
func (*PercentageAdjustment) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{4}
}

func (x *PercentageAdjustment) GetPercentage() *decimal.Decimal {
	if x != nil {
		return x.Percentage
	}
	return nil
}

// Specifies the override to conditionally apply.
type ConditionalOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Information about the applied override's adjustment.
	Adjustment *RepricingAdjustment `protobuf:"bytes,1,opt,name=adjustment,proto3" json:"adjustment,omitempty"`
	// Required. The [RebillingBasis][google.cloud.channel.v1.RebillingBasis] to
	// use for the applied override. Shows the relative cost based on your
	// repricing costs.
	RebillingBasis RebillingBasis `protobuf:"varint,2,opt,name=rebilling_basis,json=rebillingBasis,proto3,enum=google.cloud.channel.v1.RebillingBasis" json:"rebilling_basis,omitempty"`
	// Required. Specifies the condition which, if met, will apply the override.
	RepricingCondition *RepricingCondition `protobuf:"bytes,3,opt,name=repricing_condition,json=repricingCondition,proto3" json:"repricing_condition,omitempty"`
}

func (x *ConditionalOverride) Reset() {
	*x = ConditionalOverride{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ConditionalOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionalOverride) ProtoMessage() {}

func (x *ConditionalOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionalOverride.ProtoReflect.Descriptor instead.
func (*ConditionalOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{5}
}

func (x *ConditionalOverride) GetAdjustment() *RepricingAdjustment {
	if x != nil {
		return x.Adjustment
	}
	return nil
}

func (x *ConditionalOverride) GetRebillingBasis() RebillingBasis {
	if x != nil {
		return x.RebillingBasis
	}
	return RebillingBasis_REBILLING_BASIS_UNSPECIFIED
}

func (x *ConditionalOverride) GetRepricingCondition() *RepricingCondition {
	if x != nil {
		return x.RepricingCondition
	}
	return nil
}

// Represents the various repricing conditions you can use for a conditional
// override.
type RepricingCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Represents the types of existing conditional statements.
	//
	// Types that are assignable to Condition:
	//
	//	*RepricingCondition_SkuGroupCondition
	Condition isRepricingCondition_Condition `protobuf_oneof:"condition"`
}

func (x *RepricingCondition) Reset() {
	*x = RepricingCondition{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepricingCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingCondition) ProtoMessage() {}

func (x *RepricingCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingCondition.ProtoReflect.Descriptor instead.
func (*RepricingCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{6}
}

func (m *RepricingCondition) GetCondition() isRepricingCondition_Condition {
	if m != nil {
		return m.Condition
	}
	return nil
}

func (x *RepricingCondition) GetSkuGroupCondition() *SkuGroupCondition {
	if x, ok := x.GetCondition().(*RepricingCondition_SkuGroupCondition); ok {
		return x.SkuGroupCondition
	}
	return nil
}

type isRepricingCondition_Condition interface {
	isRepricingCondition_Condition()
}

type RepricingCondition_SkuGroupCondition struct {
	// SKU Group condition for override.
	SkuGroupCondition *SkuGroupCondition `protobuf:"bytes,1,opt,name=sku_group_condition,json=skuGroupCondition,proto3,oneof"`
}

func (*RepricingCondition_SkuGroupCondition) isRepricingCondition_Condition() {}

// A condition that applies the override if a line item SKU is found in the SKU
// group.
type SkuGroupCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies a SKU group (https://cloud.google.com/skus/sku-groups).
	// Resource name of SKU group. Format:
	// accounts/{account}/skuGroups/{sku_group}.
	// Example:
	// "accounts/C01234/skuGroups/3d50fd57-3157-4577-a5a9-a219b8490041".
	SkuGroup string `protobuf:"bytes,1,opt,name=sku_group,json=skuGroup,proto3" json:"sku_group,omitempty"`
}

func (x *SkuGroupCondition) Reset() {
	*x = SkuGroupCondition{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SkuGroupCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkuGroupCondition) ProtoMessage() {}

func (x *SkuGroupCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkuGroupCondition.ProtoReflect.Descriptor instead.
func (*SkuGroupCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{7}
}

func (x *SkuGroupCondition) GetSkuGroup() string {
	if x != nil {
		return x.SkuGroup
	}
	return ""
}

// Applies the repricing configuration at the entitlement level.
type RepricingConfig_EntitlementGranularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the entitlement.
	// Format:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}
	Entitlement string `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
}

func (x *RepricingConfig_EntitlementGranularity) Reset() {
	*x = RepricingConfig_EntitlementGranularity{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepricingConfig_EntitlementGranularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig_EntitlementGranularity) ProtoMessage() {}

func (x *RepricingConfig_EntitlementGranularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig_EntitlementGranularity.ProtoReflect.Descriptor instead.
func (*RepricingConfig_EntitlementGranularity) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2, 0}
}

func (x *RepricingConfig_EntitlementGranularity) GetEntitlement() string {
	if x != nil {
		return x.Entitlement
	}
	return ""
}

// Applies the repricing configuration at the channel partner level.
// The channel partner value is derived from the resource name. Takes an
// empty json object.
// Deprecated: This is no longer supported. Use
// [RepricingConfig.EntitlementGranularity][google.cloud.channel.v1.RepricingConfig.EntitlementGranularity]
// instead.
//
// Deprecated: Marked as deprecated in google/cloud/channel/v1/repricing.proto.
type RepricingConfig_ChannelPartnerGranularity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RepricingConfig_ChannelPartnerGranularity) Reset() {
	*x = RepricingConfig_ChannelPartnerGranularity{}
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RepricingConfig_ChannelPartnerGranularity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RepricingConfig_ChannelPartnerGranularity) ProtoMessage() {}

func (x *RepricingConfig_ChannelPartnerGranularity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_repricing_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RepricingConfig_ChannelPartnerGranularity.ProtoReflect.Descriptor instead.
func (*RepricingConfig_ChannelPartnerGranularity) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_repricing_proto_rawDescGZIP(), []int{2, 1}
}

var File_google_cloud_channel_v1_repricing_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_repricing_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xe8, 0x02, 0x0a, 0x17, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x3a, 0x97, 0x01, 0xea, 0x41, 0x93, 0x01, 0x0a, 0x33, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5c, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65,
	0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0x92, 0x03,
	0x0a, 0x1d, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x3a, 0xbb, 0x01, 0xea, 0x41, 0xb7, 0x01, 0x0a, 0x39, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7a, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x2f, 0x7b,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x7d,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x52,
	0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f,
	0x7b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
	0x5f, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x7d, 0x22, 0x94, 0x06, 0x0a, 0x0f, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7f, 0x0a, 0x17, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x61,
	0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52,
	0x16, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x88, 0x01, 0x0a, 0x1b, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x5f, 0x67, 0x72, 0x61, 0x6e,
	0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x50,
	0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74,
	0x79, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x19, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x47, 0x72, 0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x4e, 0x0a, 0x17, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x69, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x65, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x6e, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x4d, 0x6f, 0x6e,
	0x74, 0x68, 0x12, 0x51, 0x0a, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74,
	0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x55, 0x0a, 0x0f, 0x72, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x62, 0x61, 0x73, 0x69, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69,
	0x6e, 0x67, 0x42, 0x61, 0x73, 0x69, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65,
	0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x69, 0x73, 0x12, 0x61, 0x0a, 0x15,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x1a,
	0x68, 0x0a, 0x16, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x47, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x12, 0x4e, 0x0a, 0x0b, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x1a, 0x1f, 0x0a, 0x19, 0x43, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x50, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x47, 0x72, 0x61, 0x6e, 0x75,
	0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x3a, 0x02, 0x18, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x67, 0x72,
	0x61, 0x6e, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x22, 0x89, 0x01, 0x0a, 0x13, 0x52, 0x65,
	0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x64, 0x0a, 0x15, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x61, 0x67, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x14, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x0c, 0x0a, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73,
	0x74, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x14, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a,
	0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x44, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x61, 0x67, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x13, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x51, 0x0a, 0x0a, 0x61,
	0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x72, 0x69, 0x63,
	0x69, 0x6e, 0x67, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x55,
	0x0a, 0x0f, 0x72, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x73, 0x69,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x69, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x72, 0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67,
	0x42, 0x61, 0x73, 0x69, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69,
	0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70,
	0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x72, 0x65, 0x70, 0x72, 0x69, 0x63, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7f, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x72,
	0x69, 0x63, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5c,
	0x0a, 0x13, 0x73, 0x6b, 0x75, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11, 0x73, 0x6b, 0x75, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09,
	0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x11, 0x53, 0x6b, 0x75,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x09, 0x73, 0x6b, 0x75, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x73, 0x6b, 0x75, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2a, 0x5d, 0x0a, 0x0e, 0x52,
	0x65, 0x62, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x73, 0x69, 0x73, 0x12, 0x1f, 0x0a,
	0x1b, 0x52, 0x45, 0x42, 0x49, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x53,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10,
	0x0a, 0x0c, 0x43, 0x4f, 0x53, 0x54, 0x5f, 0x41, 0x54, 0x5f, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x01,
	0x12, 0x18, 0x0a, 0x14, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x43, 0x55, 0x53, 0x54, 0x4f,
	0x4d, 0x45, 0x52, 0x5f, 0x43, 0x4f, 0x53, 0x54, 0x10, 0x02, 0x42, 0x66, 0x0a, 0x1b, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x42, 0x0e, 0x52, 0x65, 0x70, 0x72, 0x69,
	0x63, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x35, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_repricing_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_repricing_proto_rawDescData = file_google_cloud_channel_v1_repricing_proto_rawDesc
)

func file_google_cloud_channel_v1_repricing_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_repricing_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_repricing_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_repricing_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_repricing_proto_rawDescData
}

var file_google_cloud_channel_v1_repricing_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_channel_v1_repricing_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_channel_v1_repricing_proto_goTypes = []any{
	(RebillingBasis)(0),                               // 0: google.cloud.channel.v1.RebillingBasis
	(*CustomerRepricingConfig)(nil),                   // 1: google.cloud.channel.v1.CustomerRepricingConfig
	(*ChannelPartnerRepricingConfig)(nil),             // 2: google.cloud.channel.v1.ChannelPartnerRepricingConfig
	(*RepricingConfig)(nil),                           // 3: google.cloud.channel.v1.RepricingConfig
	(*RepricingAdjustment)(nil),                       // 4: google.cloud.channel.v1.RepricingAdjustment
	(*PercentageAdjustment)(nil),                      // 5: google.cloud.channel.v1.PercentageAdjustment
	(*ConditionalOverride)(nil),                       // 6: google.cloud.channel.v1.ConditionalOverride
	(*RepricingCondition)(nil),                        // 7: google.cloud.channel.v1.RepricingCondition
	(*SkuGroupCondition)(nil),                         // 8: google.cloud.channel.v1.SkuGroupCondition
	(*RepricingConfig_EntitlementGranularity)(nil),    // 9: google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
	(*RepricingConfig_ChannelPartnerGranularity)(nil), // 10: google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
	(*timestamppb.Timestamp)(nil),                     // 11: google.protobuf.Timestamp
	(*date.Date)(nil),                                 // 12: google.type.Date
	(*decimal.Decimal)(nil),                           // 13: google.type.Decimal
}
var file_google_cloud_channel_v1_repricing_proto_depIdxs = []int32{
	3,  // 0: google.cloud.channel.v1.CustomerRepricingConfig.repricing_config:type_name -> google.cloud.channel.v1.RepricingConfig
	11, // 1: google.cloud.channel.v1.CustomerRepricingConfig.update_time:type_name -> google.protobuf.Timestamp
	3,  // 2: google.cloud.channel.v1.ChannelPartnerRepricingConfig.repricing_config:type_name -> google.cloud.channel.v1.RepricingConfig
	11, // 3: google.cloud.channel.v1.ChannelPartnerRepricingConfig.update_time:type_name -> google.protobuf.Timestamp
	9,  // 4: google.cloud.channel.v1.RepricingConfig.entitlement_granularity:type_name -> google.cloud.channel.v1.RepricingConfig.EntitlementGranularity
	10, // 5: google.cloud.channel.v1.RepricingConfig.channel_partner_granularity:type_name -> google.cloud.channel.v1.RepricingConfig.ChannelPartnerGranularity
	12, // 6: google.cloud.channel.v1.RepricingConfig.effective_invoice_month:type_name -> google.type.Date
	4,  // 7: google.cloud.channel.v1.RepricingConfig.adjustment:type_name -> google.cloud.channel.v1.RepricingAdjustment
	0,  // 8: google.cloud.channel.v1.RepricingConfig.rebilling_basis:type_name -> google.cloud.channel.v1.RebillingBasis
	6,  // 9: google.cloud.channel.v1.RepricingConfig.conditional_overrides:type_name -> google.cloud.channel.v1.ConditionalOverride
	5,  // 10: google.cloud.channel.v1.RepricingAdjustment.percentage_adjustment:type_name -> google.cloud.channel.v1.PercentageAdjustment
	13, // 11: google.cloud.channel.v1.PercentageAdjustment.percentage:type_name -> google.type.Decimal
	4,  // 12: google.cloud.channel.v1.ConditionalOverride.adjustment:type_name -> google.cloud.channel.v1.RepricingAdjustment
	0,  // 13: google.cloud.channel.v1.ConditionalOverride.rebilling_basis:type_name -> google.cloud.channel.v1.RebillingBasis
	7,  // 14: google.cloud.channel.v1.ConditionalOverride.repricing_condition:type_name -> google.cloud.channel.v1.RepricingCondition
	8,  // 15: google.cloud.channel.v1.RepricingCondition.sku_group_condition:type_name -> google.cloud.channel.v1.SkuGroupCondition
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_repricing_proto_init() }
func file_google_cloud_channel_v1_repricing_proto_init() {
	if File_google_cloud_channel_v1_repricing_proto != nil {
		return
	}
	file_google_cloud_channel_v1_repricing_proto_msgTypes[2].OneofWrappers = []any{
		(*RepricingConfig_EntitlementGranularity_)(nil),
		(*RepricingConfig_ChannelPartnerGranularity_)(nil),
	}
	file_google_cloud_channel_v1_repricing_proto_msgTypes[3].OneofWrappers = []any{
		(*RepricingAdjustment_PercentageAdjustment)(nil),
	}
	file_google_cloud_channel_v1_repricing_proto_msgTypes[6].OneofWrappers = []any{
		(*RepricingCondition_SkuGroupCondition)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_repricing_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_channel_v1_repricing_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_repricing_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_repricing_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_repricing_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_repricing_proto = out.File
	file_google_cloud_channel_v1_repricing_proto_rawDesc = nil
	file_google_cloud_channel_v1_repricing_proto_goTypes = nil
	file_google_cloud_channel_v1_repricing_proto_depIdxs = nil
}
