// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/devtools/artifactregistry/v1/export.proto

package artifactregistrypb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The request for exporting an artifact to a destination.
type ExportArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The artifact to be exported.
	//
	// Types that are assignable to SourceArtifact:
	//
	//	*ExportArtifactRequest_SourceVersion
	//	*ExportArtifactRequest_SourceTag
	SourceArtifact isExportArtifactRequest_SourceArtifact `protobuf_oneof:"source_artifact"`
	// The destination to export the artifact to.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportArtifactRequest_GcsPath
	Destination isExportArtifactRequest_Destination `protobuf_oneof:"destination"`
	// Required. The repository of the artifact to export.
	// Format: projects/{project}/locations/{location}/repositories/{repository}
	Repository string `protobuf:"bytes,1,opt,name=repository,proto3" json:"repository,omitempty"`
}

func (x *ExportArtifactRequest) Reset() {
	*x = ExportArtifactRequest{}
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportArtifactRequest) ProtoMessage() {}

func (x *ExportArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportArtifactRequest.ProtoReflect.Descriptor instead.
func (*ExportArtifactRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_export_proto_rawDescGZIP(), []int{0}
}

func (m *ExportArtifactRequest) GetSourceArtifact() isExportArtifactRequest_SourceArtifact {
	if m != nil {
		return m.SourceArtifact
	}
	return nil
}

func (x *ExportArtifactRequest) GetSourceVersion() string {
	if x, ok := x.GetSourceArtifact().(*ExportArtifactRequest_SourceVersion); ok {
		return x.SourceVersion
	}
	return ""
}

func (x *ExportArtifactRequest) GetSourceTag() string {
	if x, ok := x.GetSourceArtifact().(*ExportArtifactRequest_SourceTag); ok {
		return x.SourceTag
	}
	return ""
}

func (m *ExportArtifactRequest) GetDestination() isExportArtifactRequest_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportArtifactRequest) GetGcsPath() string {
	if x, ok := x.GetDestination().(*ExportArtifactRequest_GcsPath); ok {
		return x.GcsPath
	}
	return ""
}

func (x *ExportArtifactRequest) GetRepository() string {
	if x != nil {
		return x.Repository
	}
	return ""
}

type isExportArtifactRequest_SourceArtifact interface {
	isExportArtifactRequest_SourceArtifact()
}

type ExportArtifactRequest_SourceVersion struct {
	// The artifact version to export.
	// Format:
	// projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}
	SourceVersion string `protobuf:"bytes,2,opt,name=source_version,json=sourceVersion,proto3,oneof"`
}

type ExportArtifactRequest_SourceTag struct {
	// The artifact tag to export.
	// Format:projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/tags/{tag}
	SourceTag string `protobuf:"bytes,4,opt,name=source_tag,json=sourceTag,proto3,oneof"`
}

func (*ExportArtifactRequest_SourceVersion) isExportArtifactRequest_SourceArtifact() {}

func (*ExportArtifactRequest_SourceTag) isExportArtifactRequest_SourceArtifact() {}

type isExportArtifactRequest_Destination interface {
	isExportArtifactRequest_Destination()
}

type ExportArtifactRequest_GcsPath struct {
	// The Cloud Storage path to export the artifact to. Should start with the
	// bucket name, and optionally have a directory path. Examples:
	// `dst_bucket`, `dst_bucket/sub_dir`.
	// Existing objects with the same path will be overwritten.
	GcsPath string `protobuf:"bytes,3,opt,name=gcs_path,json=gcsPath,proto3,oneof"`
}

func (*ExportArtifactRequest_GcsPath) isExportArtifactRequest_Destination() {}

// The response for exporting an artifact to a destination.
type ExportArtifactResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported version. Should be the same as the request version with
	// fingerprint resource name.
	ExportedVersion *Version `protobuf:"bytes,1,opt,name=exported_version,json=exportedVersion,proto3" json:"exported_version,omitempty"`
}

func (x *ExportArtifactResponse) Reset() {
	*x = ExportArtifactResponse{}
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportArtifactResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportArtifactResponse) ProtoMessage() {}

func (x *ExportArtifactResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportArtifactResponse.ProtoReflect.Descriptor instead.
func (*ExportArtifactResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_export_proto_rawDescGZIP(), []int{1}
}

func (x *ExportArtifactResponse) GetExportedVersion() *Version {
	if x != nil {
		return x.ExportedVersion
	}
	return nil
}

// The LRO metadata for exporting an artifact.
type ExportArtifactMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The exported artifact files.
	ExportedFiles []*ExportArtifactMetadata_ExportedFile `protobuf:"bytes,1,rep,name=exported_files,json=exportedFiles,proto3" json:"exported_files,omitempty"`
}

func (x *ExportArtifactMetadata) Reset() {
	*x = ExportArtifactMetadata{}
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportArtifactMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportArtifactMetadata) ProtoMessage() {}

func (x *ExportArtifactMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportArtifactMetadata.ProtoReflect.Descriptor instead.
func (*ExportArtifactMetadata) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_export_proto_rawDescGZIP(), []int{2}
}

func (x *ExportArtifactMetadata) GetExportedFiles() []*ExportArtifactMetadata_ExportedFile {
	if x != nil {
		return x.ExportedFiles
	}
	return nil
}

// The exported artifact file.
type ExportArtifactMetadata_ExportedFile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination the file was exported to.
	//
	// Types that are assignable to Destination:
	//
	//	*ExportArtifactMetadata_ExportedFile_GcsObjectPath
	Destination isExportArtifactMetadata_ExportedFile_Destination `protobuf_oneof:"destination"`
	// Name of the exported artifact file.
	// Format: `projects/p1/locations/us/repositories/repo1/files/file1`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The hashes of the file content.
	Hashes []*Hash `protobuf:"bytes,3,rep,name=hashes,proto3" json:"hashes,omitempty"`
}

func (x *ExportArtifactMetadata_ExportedFile) Reset() {
	*x = ExportArtifactMetadata_ExportedFile{}
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportArtifactMetadata_ExportedFile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportArtifactMetadata_ExportedFile) ProtoMessage() {}

func (x *ExportArtifactMetadata_ExportedFile) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_artifactregistry_v1_export_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportArtifactMetadata_ExportedFile.ProtoReflect.Descriptor instead.
func (*ExportArtifactMetadata_ExportedFile) Descriptor() ([]byte, []int) {
	return file_google_devtools_artifactregistry_v1_export_proto_rawDescGZIP(), []int{2, 0}
}

func (m *ExportArtifactMetadata_ExportedFile) GetDestination() isExportArtifactMetadata_ExportedFile_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *ExportArtifactMetadata_ExportedFile) GetGcsObjectPath() string {
	if x, ok := x.GetDestination().(*ExportArtifactMetadata_ExportedFile_GcsObjectPath); ok {
		return x.GcsObjectPath
	}
	return ""
}

func (x *ExportArtifactMetadata_ExportedFile) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportArtifactMetadata_ExportedFile) GetHashes() []*Hash {
	if x != nil {
		return x.Hashes
	}
	return nil
}

type isExportArtifactMetadata_ExportedFile_Destination interface {
	isExportArtifactMetadata_ExportedFile_Destination()
}

type ExportArtifactMetadata_ExportedFile_GcsObjectPath struct {
	// Cloud Storage Object path of the exported file. Examples:
	// `dst_bucket/file1`, `dst_bucket/sub_dir/file1`
	GcsObjectPath string `protobuf:"bytes,2,opt,name=gcs_object_path,json=gcsObjectPath,proto3,oneof"`
}

func (*ExportArtifactMetadata_ExportedFile_GcsObjectPath) isExportArtifactMetadata_ExportedFile_Destination() {
}

var File_google_devtools_artifactregistry_v1_export_proto protoreflect.FileDescriptor

var file_google_devtools_artifactregistry_v1_export_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcc, 0x02, 0x0a, 0x15, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x55, 0x0a, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xfa, 0x41, 0x25,
	0x0a, 0x23, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x67, 0x48, 0x00, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54,
	0x61, 0x67, 0x12, 0x1b, 0x0a, 0x08, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x07, 0x67, 0x63, 0x73, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x52, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70,
	0x6f, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x6f, 0x72, 0x79, 0x42, 0x11, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x71, 0x0a, 0x16, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x57, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xd5, 0x02, 0x0a, 0x16, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x6f, 0x0a, 0x0e, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72,
	0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x0d, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x1a, 0xc9, 0x01, 0x0a, 0x0c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x65,
	0x64, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x28, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x6f, 0x62, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0d, 0x67, 0x63, 0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x50, 0x61, 0x74, 0x68, 0x12,
	0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xfa,
	0x41, 0x26, 0x0a, 0x24, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69,
	0x73, 0x74, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x41,
	0x0a, 0x06, 0x68, 0x61, 0x73, 0x68, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x52, 0x06, 0x68, 0x61, 0x73, 0x68, 0x65,
	0x73, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0xf6, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
	0x79, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x70, 0x62, 0x3b, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x70, 0x62, 0xaa, 0x02, 0x20,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x79,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x72, 0x79, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_devtools_artifactregistry_v1_export_proto_rawDescOnce sync.Once
	file_google_devtools_artifactregistry_v1_export_proto_rawDescData = file_google_devtools_artifactregistry_v1_export_proto_rawDesc
)

func file_google_devtools_artifactregistry_v1_export_proto_rawDescGZIP() []byte {
	file_google_devtools_artifactregistry_v1_export_proto_rawDescOnce.Do(func() {
		file_google_devtools_artifactregistry_v1_export_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_artifactregistry_v1_export_proto_rawDescData)
	})
	return file_google_devtools_artifactregistry_v1_export_proto_rawDescData
}

var file_google_devtools_artifactregistry_v1_export_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_devtools_artifactregistry_v1_export_proto_goTypes = []any{
	(*ExportArtifactRequest)(nil),               // 0: google.devtools.artifactregistry.v1.ExportArtifactRequest
	(*ExportArtifactResponse)(nil),              // 1: google.devtools.artifactregistry.v1.ExportArtifactResponse
	(*ExportArtifactMetadata)(nil),              // 2: google.devtools.artifactregistry.v1.ExportArtifactMetadata
	(*ExportArtifactMetadata_ExportedFile)(nil), // 3: google.devtools.artifactregistry.v1.ExportArtifactMetadata.ExportedFile
	(*Version)(nil),                             // 4: google.devtools.artifactregistry.v1.Version
	(*Hash)(nil),                                // 5: google.devtools.artifactregistry.v1.Hash
}
var file_google_devtools_artifactregistry_v1_export_proto_depIdxs = []int32{
	4, // 0: google.devtools.artifactregistry.v1.ExportArtifactResponse.exported_version:type_name -> google.devtools.artifactregistry.v1.Version
	3, // 1: google.devtools.artifactregistry.v1.ExportArtifactMetadata.exported_files:type_name -> google.devtools.artifactregistry.v1.ExportArtifactMetadata.ExportedFile
	5, // 2: google.devtools.artifactregistry.v1.ExportArtifactMetadata.ExportedFile.hashes:type_name -> google.devtools.artifactregistry.v1.Hash
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_devtools_artifactregistry_v1_export_proto_init() }
func file_google_devtools_artifactregistry_v1_export_proto_init() {
	if File_google_devtools_artifactregistry_v1_export_proto != nil {
		return
	}
	file_google_devtools_artifactregistry_v1_file_proto_init()
	file_google_devtools_artifactregistry_v1_version_proto_init()
	file_google_devtools_artifactregistry_v1_export_proto_msgTypes[0].OneofWrappers = []any{
		(*ExportArtifactRequest_SourceVersion)(nil),
		(*ExportArtifactRequest_SourceTag)(nil),
		(*ExportArtifactRequest_GcsPath)(nil),
	}
	file_google_devtools_artifactregistry_v1_export_proto_msgTypes[3].OneofWrappers = []any{
		(*ExportArtifactMetadata_ExportedFile_GcsObjectPath)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_artifactregistry_v1_export_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_artifactregistry_v1_export_proto_goTypes,
		DependencyIndexes: file_google_devtools_artifactregistry_v1_export_proto_depIdxs,
		MessageInfos:      file_google_devtools_artifactregistry_v1_export_proto_msgTypes,
	}.Build()
	File_google_devtools_artifactregistry_v1_export_proto = out.File
	file_google_devtools_artifactregistry_v1_export_proto_rawDesc = nil
	file_google_devtools_artifactregistry_v1_export_proto_goTypes = nil
	file_google_devtools_artifactregistry_v1_export_proto_depIdxs = nil
}
