/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FlexComponentSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="minimumCoreCount")
    private final Integer minimumCoreCount;
    @JsonProperty(value="availableCoreCount")
    private final Integer availableCoreCount;
    @JsonProperty(value="availableDbStorageInGBs")
    private final Integer availableDbStorageInGBs;

    @Deprecated
    @ConstructorProperties(value={"name", "minimumCoreCount", "availableCoreCount", "availableDbStorageInGBs"})
    public FlexComponentSummary(String name, Integer minimumCoreCount, Integer availableCoreCount, Integer availableDbStorageInGBs) {
        this.name = name;
        this.minimumCoreCount = minimumCoreCount;
        this.availableCoreCount = availableCoreCount;
        this.availableDbStorageInGBs = availableDbStorageInGBs;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getMinimumCoreCount() {
        return this.minimumCoreCount;
    }

    public Integer getAvailableCoreCount() {
        return this.availableCoreCount;
    }

    public Integer getAvailableDbStorageInGBs() {
        return this.availableDbStorageInGBs;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FlexComponentSummary(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", minimumCoreCount=").append(String.valueOf(this.minimumCoreCount));
        sb.append(", availableCoreCount=").append(String.valueOf(this.availableCoreCount));
        sb.append(", availableDbStorageInGBs=").append(String.valueOf(this.availableDbStorageInGBs));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FlexComponentSummary)) {
            return false;
        }
        FlexComponentSummary other = (FlexComponentSummary)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.minimumCoreCount, other.minimumCoreCount) && Objects.equals(this.availableCoreCount, other.availableCoreCount) && Objects.equals(this.availableDbStorageInGBs, other.availableDbStorageInGBs) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.minimumCoreCount == null ? 43 : this.minimumCoreCount.hashCode());
        result = result * 59 + (this.availableCoreCount == null ? 43 : this.availableCoreCount.hashCode());
        result = result * 59 + (this.availableDbStorageInGBs == null ? 43 : this.availableDbStorageInGBs.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="minimumCoreCount")
        private Integer minimumCoreCount;
        @JsonProperty(value="availableCoreCount")
        private Integer availableCoreCount;
        @JsonProperty(value="availableDbStorageInGBs")
        private Integer availableDbStorageInGBs;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder minimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
            this.__explicitlySet__.add("minimumCoreCount");
            return this;
        }

        public Builder availableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
            this.__explicitlySet__.add("availableCoreCount");
            return this;
        }

        public Builder availableDbStorageInGBs(Integer availableDbStorageInGBs) {
            this.availableDbStorageInGBs = availableDbStorageInGBs;
            this.__explicitlySet__.add("availableDbStorageInGBs");
            return this;
        }

        public FlexComponentSummary build() {
            FlexComponentSummary model = new FlexComponentSummary(this.name, this.minimumCoreCount, this.availableCoreCount, this.availableDbStorageInGBs);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FlexComponentSummary model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("minimumCoreCount")) {
                this.minimumCoreCount(model.getMinimumCoreCount());
            }
            if (model.wasPropertyExplicitlySet("availableCoreCount")) {
                this.availableCoreCount(model.getAvailableCoreCount());
            }
            if (model.wasPropertyExplicitlySet("availableDbStorageInGBs")) {
                this.availableDbStorageInGBs(model.getAvailableDbStorageInGBs());
            }
            return this;
        }
    }
}

