/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetExadataInfrastructureRequest
extends BmcRequest<Void> {
    private String exadataInfrastructureId;
    private String opcRequestId;
    private List<ExcludedFields> excludedFields;

    public String getExadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<ExcludedFields> getExcludedFields() {
        return this.excludedFields;
    }

    public Builder toBuilder() {
        return new Builder().exadataInfrastructureId(this.exadataInfrastructureId).opcRequestId(this.opcRequestId).excludedFields(this.excludedFields);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",exadataInfrastructureId=").append(String.valueOf(this.exadataInfrastructureId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",excludedFields=").append(String.valueOf(this.excludedFields));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetExadataInfrastructureRequest)) {
            return false;
        }
        GetExadataInfrastructureRequest other = (GetExadataInfrastructureRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.exadataInfrastructureId, other.exadataInfrastructureId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.excludedFields, other.excludedFields);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.exadataInfrastructureId == null ? 43 : this.exadataInfrastructureId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.excludedFields == null ? 43 : this.excludedFields.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetExadataInfrastructureRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String exadataInfrastructureId = null;
        private String opcRequestId = null;
        private List<ExcludedFields> excludedFields = null;

        public Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder excludedFields(List<ExcludedFields> excludedFields) {
            this.excludedFields = excludedFields;
            return this;
        }

        public Builder excludedFields(ExcludedFields singularValue) {
            return this.excludedFields(Arrays.asList(singularValue));
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetExadataInfrastructureRequest o) {
            this.exadataInfrastructureId(o.getExadataInfrastructureId());
            this.opcRequestId(o.getOpcRequestId());
            this.excludedFields(o.getExcludedFields());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetExadataInfrastructureRequest build() {
            GetExadataInfrastructureRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetExadataInfrastructureRequest buildWithoutInvocationCallback() {
            GetExadataInfrastructureRequest request = new GetExadataInfrastructureRequest();
            request.exadataInfrastructureId = this.exadataInfrastructureId;
            request.opcRequestId = this.opcRequestId;
            request.excludedFields = this.excludedFields;
            return request;
        }
    }

    public static enum ExcludedFields implements BmcEnum
    {
        MultiRackConfigurationFile("multiRackConfigurationFile");

        private final String value;
        private static Map<String, ExcludedFields> map;

        private ExcludedFields(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExcludedFields create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ExcludedFields: " + key);
        }

        static {
            map = new HashMap<String, ExcludedFields>();
            for (ExcludedFields v : ExcludedFields.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

