/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public class CompletionContext {
    private List<String> existingAttributes;
    private CompletionType completionType = CompletionType.NONE;
    private int caretOffset;
    private DocumentContext documentContext;
    private String typedChars = "";
    private char lastTypedChar;
    private XMLSyntaxSupport support;
    private FileObject fileObject;
    private BaseDocument internalDoc = new BaseDocument(true, "text/xml");
    private int queryType;

    public CompletionContext(Document doc, int caretOffset, int queryType) {
        this.caretOffset = caretOffset;
        this.fileObject = NbEditorUtilities.getFileObject((Document)doc);
        this.queryType = queryType;
        try {
            this.initContext((BaseDocument)doc);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initContext(BaseDocument bDoc) throws BadLocationException {
        boolean copyResult = this.copyDocument(bDoc, this.internalDoc);
        if (!copyResult) {
            return;
        }
        Object sdp = bDoc.getProperty((Object)"stream");
        this.internalDoc.putProperty((Object)"stream", sdp);
        this.support = XMLSyntaxSupport.getSyntaxSupport((Document)this.internalDoc);
        this.documentContext = DocumentContext.create((Document)this.internalDoc, this.caretOffset);
        this.lastTypedChar = this.support.lastTypedChar();
        if (this.documentContext == null) {
            return;
        }
        Token<XMLTokenId> token = this.documentContext.getCurrentToken();
        if (token == null) {
            return;
        }
        int tOffset = this.documentContext.getCurrentTokenOffset();
        String tokenText = token.text().toString();
        XMLTokenId id = (XMLTokenId)token.id();
        int tlen = token.length();
        if (token.id() == XMLTokenId.ERROR && token.text().toString().equals("/")) {
            tokenText = " ";
            id = XMLTokenId.WS;
            tlen = 1;
            tOffset = this.caretOffset;
        }
        boolean tokenBoundary = tOffset == this.caretOffset || tOffset + tlen == this.caretOffset;
        SyntaxElement element = this.documentContext.getCurrentElement();
        switch (id) {
            case TEXT: {
                String chars = tokenText.trim();
                Token previousTokenItem = this.support.getPreviousToken(tOffset);
                if (previousTokenItem == null) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                String text = previousTokenItem.text().toString().trim();
                if (chars != null && chars.equals("") && text.equals("/>")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.equals("") && text.trim().equals(">")) {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                if (chars != null && !chars.equals("<") && text.trim().equals(">")) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (chars != null && chars.startsWith("<")) {
                    this.typedChars = chars.substring(1);
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case TAG: {
                if (this.support.isEndTag(element)) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                if (this.support.isEmptyTag(element)) {
                    if (tokenText.trim().equals("/>")) {
                        Token prevToken = this.support.getPreviousToken(tOffset);
                        if (prevToken != null && prevToken.id() == XMLTokenId.WS && this.caretOffset == tOffset) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (element.getElementOffset() + 1 == this.caretOffset) {
                        this.completionType = CompletionType.TAG;
                        break;
                    }
                    String tagName = element.getNode().getNodeName();
                    if (this.caretOffset > element.getElementOffset() + 1 && this.caretOffset <= element.getElementOffset() + 1 + tagName.length()) {
                        this.completionType = CompletionType.TAG;
                        this.typedChars = tagName;
                        break;
                    }
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (this.support.isStartTag(element)) {
                    if (tokenText.toString().trim().equals(">")) {
                        Token prevToken = this.support.getPreviousToken(tOffset);
                        if (prevToken != null && prevToken.id() == XMLTokenId.WS && this.caretOffset == tOffset) {
                            this.completionType = CompletionType.ATTRIBUTE;
                            break;
                        }
                        this.completionType = CompletionType.NONE;
                        break;
                    }
                    if (element.getElementOffset() + 1 != this.caretOffset) {
                        this.typedChars = element.getNode().getNodeName();
                    }
                }
                if (this.lastTypedChar == '>') {
                    this.completionType = CompletionType.VALUE;
                    break;
                }
                this.completionType = CompletionType.TAG;
                break;
            }
            case ARGUMENT: {
                this.completionType = CompletionType.ATTRIBUTE;
                this.typedChars = tokenText.substring(0, this.caretOffset - tOffset);
                break;
            }
            case CHARACTER: 
            case OPERATOR: {
                this.completionType = CompletionType.NONE;
                break;
            }
            case VALUE: {
                if (!tokenBoundary) {
                    this.completionType = CompletionType.ATTRIBUTE_VALUE;
                    this.typedChars = tokenText.subSequence(1, this.caretOffset - tOffset).toString();
                    break;
                }
                this.completionType = CompletionType.NONE;
                break;
            }
            case WS: {
                this.completionType = CompletionType.NONE;
                int[] offset = new int[1];
                Token prev = (Token)this.support.runWithSequence(tOffset, ts -> {
                    boolean ok;
                    Token t = null;
                    while ((ok = ts.movePrevious()) && (t = ts.token()).id() == XMLTokenId.WS) {
                    }
                    if (ok) {
                        offset[0] = ts.offset();
                        return t;
                    }
                    return null;
                });
                if (prev == null) {
                    this.completionType = CompletionType.NONE;
                    break;
                }
                int prevOffset = offset[0];
                if (prev.id() == XMLTokenId.ARGUMENT && prevOffset + prev.length() == this.caretOffset) {
                    this.typedChars = prev.text().toString();
                    this.completionType = CompletionType.ATTRIBUTE;
                    break;
                }
                if (prev.id() != XMLTokenId.VALUE && prev.id() != XMLTokenId.TAG || tokenBoundary) break;
                this.completionType = CompletionType.ATTRIBUTE;
                break;
            }
            default: {
                this.completionType = CompletionType.NONE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDocument(final BaseDocument src, final BaseDocument dest) {
        final boolean[] retVal = new boolean[]{true};
        src.readLock();
        try {
            dest.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        String docText = src.getText(0, src.getLength());
                        dest.insertString(0, docText, null);
                    }
                    catch (BadLocationException ble) {
                        Exceptions.printStackTrace((Throwable)ble);
                        retVal[0] = false;
                    }
                }
            });
        }
        finally {
            src.readUnlock();
        }
        return retVal[0];
    }

    public CompletionType getCompletionType() {
        return this.completionType;
    }

    public String getTypedPrefix() {
        return this.typedChars;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public Node getTag() {
        SyntaxElement element = this.documentContext.getCurrentElement();
        return element.getType() == 1 ? element.getNode() : null;
    }

    public Token<XMLTokenId> getCurrentToken() {
        return this.documentContext.getCurrentToken();
    }

    public int getCurrentTokenOffset() {
        return this.documentContext.getCurrentTokenOffset();
    }

    private List<String> getExistingAttributesLocked(TokenSequence ts) {
        Token item;
        XMLTokenId tokenId;
        ArrayList<String> existingAttributes = new ArrayList<String>();
        while (ts.movePrevious() && (tokenId = (XMLTokenId)(item = ts.token()).id()) != XMLTokenId.TAG) {
            if (tokenId != XMLTokenId.ARGUMENT) continue;
            existingAttributes.add(item.text().toString());
        }
        return existingAttributes;
    }

    public List<String> getExistingAttributes() {
        if (this.existingAttributes == null) {
            try {
                this.existingAttributes = (List)this.support.runWithSequence(this.documentContext.getCurrentTokenOffset(), this::getExistingAttributesLocked);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.existingAttributes;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public Document getDocument() {
        return this.internalDoc;
    }

    public static enum CompletionType {
        TAG,
        VALUE,
        ATTRIBUTE,
        ATTRIBUTE_VALUE,
        NONE;

    }
}

