/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.spring.beans.editor.ContextUtilities;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.XMLSyntaxSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DocumentContext {
    private Document document;
    private XMLSyntaxSupport syntaxSupport;
    private int caretOffset = -1;
    private SyntaxElement element;
    private Token<XMLTokenId> token;
    private int tokenOffset;
    private HashMap<String, String> declaredNamespaces = new HashMap();

    public static DocumentContext create(Document document, int caretOffset) {
        try {
            return new DocumentContext(document, caretOffset);
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private DocumentContext(Document document, int caretOffset) throws BadLocationException {
        this.document = document;
        this.syntaxSupport = XMLSyntaxSupport.getSyntaxSupport((Document)document);
        this.caretOffset = caretOffset;
        this.initialize();
    }

    private void initialize() throws BadLocationException {
        this.element = this.syntaxSupport.getElementChain(this.caretOffset);
        this.syntaxSupport.runWithSequence(this.caretOffset, ts -> {
            this.token = this.syntaxSupport.getNextToken(this.caretOffset);
            this.tokenOffset = ts.offset();
            return null;
        });
        this.populateNamespaces();
    }

    public XMLSyntaxSupport getSyntaxSupport() {
        return this.syntaxSupport;
    }

    public <T> T runWithTokenSequence(int offset, XMLSyntaxSupport.SequenceCallable<T> callable) throws BadLocationException {
        return (T)this.syntaxSupport.runWithSequence(offset, callable);
    }

    public int getCurrentTokenOffset() {
        return this.tokenOffset;
    }

    public Token<XMLTokenId> getCurrentToken() {
        return this.token;
    }

    public String getCurrentTokenImage() {
        return this.token.text().toString();
    }

    public SyntaxElement getCurrentElement() {
        return this.element;
    }

    public String lookupNamespacePrefix(String prefix) {
        return this.declaredNamespaces.get(prefix);
    }

    public String getNamespacePrefix(String namespace) {
        for (Map.Entry<String, String> entry : this.declaredNamespaces.entrySet()) {
            if (!entry.getValue().equals(namespace)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Collection<String> getDeclaredNamespaces() {
        return this.declaredNamespaces.values();
    }

    public Map<String, String> getDeclaredNamespacesMap() {
        return this.declaredNamespaces;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    private void populateNamespaces() {
        SyntaxElement element;
        for (element = this.element; element != null && !this.syntaxSupport.isStartTag(element) && !this.syntaxSupport.isEmptyTag(element); element = element.getPrevious()) {
        }
        if (element == null) {
            return;
        }
        while (element != null) {
            Node node = element.getNode();
            if (this.syntaxSupport.isStartTag(element) || this.syntaxSupport.isEmptyTag(element)) {
                NamedNodeMap attributes = node.getAttributes();
                for (int index = 0; index < attributes.getLength(); ++index) {
                    String prefix;
                    Attr attr = (Attr)attributes.item(index);
                    String attrName = attr.getName();
                    String attrValue = attr.getValue();
                    if (attrName == null || attrValue == null || (prefix = ContextUtilities.getPrefixFromNamespaceDeclaration(attrName)) == null || this.declaredNamespaces.containsKey(prefix)) continue;
                    this.declaredNamespaces.put(prefix, attrValue);
                }
            }
            element = element.getParentElement();
        }
    }

    public int getNodeOffset(Node n) {
        return this.syntaxSupport.getNodeOffset(n);
    }

    public boolean isTag(SyntaxElement e) {
        return this.syntaxSupport.isStartTag(e) || this.syntaxSupport.isEmptyTag(e) || this.syntaxSupport.isEndTag(e);
    }
}

