/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.keymanagement.Ekm;
import com.oracle.bmc.keymanagement.EkmPaginators;
import com.oracle.bmc.keymanagement.EkmWaiters;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpoint;
import com.oracle.bmc.keymanagement.model.EkmsPrivateEndpointSummary;
import com.oracle.bmc.keymanagement.requests.CreateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.DeleteEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.GetEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.requests.ListEkmsPrivateEndpointsRequest;
import com.oracle.bmc.keymanagement.requests.UpdateEkmsPrivateEndpointRequest;
import com.oracle.bmc.keymanagement.responses.CreateEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.DeleteEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.GetEkmsPrivateEndpointResponse;
import com.oracle.bmc.keymanagement.responses.ListEkmsPrivateEndpointsResponse;
import com.oracle.bmc.keymanagement.responses.UpdateEkmsPrivateEndpointResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EkmClient
extends BaseSyncClient
implements Ekm {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EKM").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(EkmClient.class);
    private final EkmWaiters waiters;
    private final EkmPaginators paginators;

    EkmClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Ekm-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new EkmWaiters(executorService, this);
        this.paginators = new EkmPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CreateEkmsPrivateEndpointResponse createEkmsPrivateEndpoint(CreateEkmsPrivateEndpointRequest request) {
        Objects.requireNonNull(request.getCreateEkmsPrivateEndpointDetails(), "createEkmsPrivateEndpointDetails is required");
        return (CreateEkmsPrivateEndpointResponse)this.clientCall(request, CreateEkmsPrivateEndpointResponse::builder).logger(LOG, "createEkmsPrivateEndpoint").serviceDetails("Ekm", "CreateEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/CreateEkmsPrivateEndpoint").method(Method.POST).requestBuilder(CreateEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(EkmsPrivateEndpoint.class, CreateEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("etag", CreateEkmsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateEkmsPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateEkmsPrivateEndpointResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteEkmsPrivateEndpointResponse deleteEkmsPrivateEndpoint(DeleteEkmsPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (DeleteEkmsPrivateEndpointResponse)this.clientCall(request, DeleteEkmsPrivateEndpointResponse::builder).logger(LOG, "deleteEkmsPrivateEndpoint").serviceDetails("Ekm", "DeleteEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/DeleteEkmsPrivateEndpoint").method(Method.DELETE).requestBuilder(DeleteEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteEkmsPrivateEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteEkmsPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetEkmsPrivateEndpointResponse getEkmsPrivateEndpoint(GetEkmsPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        return (GetEkmsPrivateEndpointResponse)this.clientCall(request, GetEkmsPrivateEndpointResponse::builder).logger(LOG, "getEkmsPrivateEndpoint").serviceDetails("Ekm", "GetEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/GetEkmsPrivateEndpoint").method(Method.GET).requestBuilder(GetEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(EkmsPrivateEndpoint.class, GetEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("opc-request-id", GetEkmsPrivateEndpointResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetEkmsPrivateEndpointResponse.Builder::etag).callSync();
    }

    @Override
    public ListEkmsPrivateEndpointsResponse listEkmsPrivateEndpoints(ListEkmsPrivateEndpointsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListEkmsPrivateEndpointsResponse)this.clientCall(request, ListEkmsPrivateEndpointsResponse::builder).logger(LOG, "listEkmsPrivateEndpoints").serviceDetails("Ekm", "ListEkmsPrivateEndpoints", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpointSummary/ListEkmsPrivateEndpoints").method(Method.GET).requestBuilder(ListEkmsPrivateEndpointsRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(EkmsPrivateEndpointSummary.class, ListEkmsPrivateEndpointsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListEkmsPrivateEndpointsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListEkmsPrivateEndpointsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateEkmsPrivateEndpointResponse updateEkmsPrivateEndpoint(UpdateEkmsPrivateEndpointRequest request) {
        Validate.notBlank((String)request.getEkmsPrivateEndpointId(), (String)"ekmsPrivateEndpointId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateEkmsPrivateEndpointDetails(), "updateEkmsPrivateEndpointDetails is required");
        return (UpdateEkmsPrivateEndpointResponse)this.clientCall(request, UpdateEkmsPrivateEndpointResponse::builder).logger(LOG, "updateEkmsPrivateEndpoint").serviceDetails("Ekm", "UpdateEkmsPrivateEndpoint", "https://docs.oracle.com/iaas/api/#/en/key/release/EkmsPrivateEndpoint/UpdateEkmsPrivateEndpoint").method(Method.PUT).requestBuilder(UpdateEkmsPrivateEndpointRequest::builder).basePath("/").appendPathParam("20180608").appendPathParam("ekmsPrivateEndpoints").appendPathParam(request.getEkmsPrivateEndpointId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(EkmsPrivateEndpoint.class, UpdateEkmsPrivateEndpointResponse.Builder::ekmsPrivateEndpoint).handleResponseHeaderString("etag", UpdateEkmsPrivateEndpointResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateEkmsPrivateEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EkmWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public EkmPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public EkmClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)EkmClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(EkmClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public EkmClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)EkmClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EkmClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "keymanagement";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"keymanagement");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public EkmClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new EkmClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

