/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class ScriptResolver
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;

    public ScriptResolver() {
    }

    ScriptResolver(BuildEnvironment env) {
        this.env = env;
    }

    @Override
    public void visitScript(FxScriptFragment script) {
        String srcPath = script.getSourcePath();
        if (srcPath == null) {
            return;
        }
        if ("".equals(srcPath)) {
            TextPositions pos = this.env.getTreeUtilities().positions(script);
            this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "empty-script-source-path", Bundle.ERR_emptySourcePath(), script));
            this.env.getAccessor().makeBroken(script);
            return;
        }
        FileObject targetFo = null;
        if (srcPath.startsWith("/")) {
            ClassPath cp = this.env.getCompilationInfo().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
            if (cp != null) {
                targetFo = cp.findResource(srcPath);
            }
            if (targetFo == null && (cp = this.env.getCompilationInfo().getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE)) != null) {
                targetFo = cp.findResource(srcPath);
            }
        } else {
            try {
                URL u = new URL(this.env.getModel().getBaseURL(), srcPath);
                targetFo = URLMapper.findFileObject((URL)u);
            }
            catch (MalformedURLException ex) {
                TextPositions pos = this.env.getTreeUtilities().positions(script);
                this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "invalid-script-path", Bundle.ERR_invalidScriptPath(srcPath, ex.getLocalizedMessage()), script));
                this.env.getAccessor().makeBroken(script);
                return;
            }
        }
        if (targetFo == null) {
            TextPositions pos = this.env.getTreeUtilities().positions(script);
            this.env.addError(new ErrorMark(pos.getStart(), pos.getEnd() - pos.getStart(), "unresolved-script-path", Bundle.ERR_unresolvedScriptPath(srcPath), script));
            this.env.getAccessor().makeBroken(script);
        } else {
            URL resolvedUrl = targetFo.toURL();
            this.env.getAccessor().resolveResource(script, resolvedUrl);
        }
        super.visitScript(script);
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new ScriptResolver(env);
    }
}

