/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.swing.ButtonModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.jumpto.EntityComparator;
import org.netbeans.modules.jumpto.common.HighlightingNameFormatter;
import org.netbeans.modules.jumpto.common.UiUtils;
import org.netbeans.modules.jumpto.settings.GoToSettings;
import org.openide.util.ImageUtilities;
import org.openide.util.Parameters;

public final class ItemRenderer<T>
extends DefaultListCellRenderer
implements ChangeListener {
    private static final String SAMPLE_ITEM_ICON = "org/netbeans/modules/jumpto/type/sample.png";
    private static final int DARKER_COLOR_COMPONENT = 15;
    private static final int LIGHTER_COLOR_COMPONENT = 80;
    private final GoToSettings.HighlightingMode highlightMode;
    private final HighlightingNameFormatter nameFormater;
    private final String mainProjectName = EntityComparator.getMainProjectName();
    private final Convertor<T> convertor;
    private final MyPanel<T> rendererComponent;
    private final JLabel jlName;
    private final JLabel jlOwner = new JLabel();
    private final JLabel jlPrj = new JLabel();
    private final Color fgColor;
    private final Color fgColorLighter;
    private final Color bgColor;
    private final Color bgColorDarker;
    private final Color bgSelectionColor;
    private final Color fgSelectionColor;
    private final Color bgColorGreener;
    private final Color bgColorDarkerGreener;
    private final JList<T> jList;
    private final ButtonModel caseSensitive;
    private final ButtonModel colorPrefered;
    private final ButtonModel searchFolders;
    private Class<T> clzCache;

    private ItemRenderer(@NonNull JList<T> list, @NonNull ButtonModel caseSensitive, @NullAllowed ButtonModel colorPrefered, @NullAllowed ButtonModel searchFolders, @NonNull Convertor<T> convertor, @NullAllowed String separatorPattern) {
        Parameters.notNull((CharSequence)"list", list);
        Parameters.notNull((CharSequence)"caseSensitive", (Object)caseSensitive);
        Parameters.notNull((CharSequence)"convertor", convertor);
        this.jList = list;
        this.caseSensitive = caseSensitive;
        this.colorPrefered = colorPrefered;
        this.searchFolders = searchFolders;
        this.convertor = convertor;
        GoToSettings hs = GoToSettings.getDefault();
        this.highlightMode = hs.getHighlightingMode();
        this.nameFormater = ItemRenderer.createNameFormatter(hs.getHighlightingType(), separatorPattern);
        this.jlName = new JLabel();
        this.resetNameLabel();
        Container container = list.getParent();
        if (container instanceof JViewport) {
            JViewport vp = (JViewport)container;
            vp.addChangeListener(this);
            this.stateChanged(new ChangeEvent(vp));
        }
        this.rendererComponent = new MyPanel<T>(convertor);
        this.rendererComponent.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 7);
        this.rendererComponent.add((Component)this.jlName, c);
        this.jlOwner.setOpaque(false);
        this.jlOwner.setFont(list.getFont());
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 7);
        this.rendererComponent.add((Component)this.jlOwner, c);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 13;
        this.rendererComponent.add((Component)this.jlPrj, c);
        this.jlPrj.setOpaque(false);
        this.jlPrj.setFont(list.getFont());
        this.jlPrj.setHorizontalAlignment(4);
        this.jlPrj.setHorizontalTextPosition(2);
        this.fgColor = list.getForeground();
        this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + 80), Math.min(255, this.fgColor.getGreen() + 80), Math.min(255, this.fgColor.getBlue() + 80));
        this.bgColor = new Color(list.getBackground().getRGB());
        this.bgColorDarker = new Color(Math.abs(this.bgColor.getRed() - 15), Math.abs(this.bgColor.getGreen() - 15), Math.abs(this.bgColor.getBlue() - 15));
        this.bgSelectionColor = list.getSelectionBackground();
        this.fgSelectionColor = list.getSelectionForeground();
        this.bgColorGreener = new Color(Math.abs(this.bgColor.getRed() - 20), Math.min(255, this.bgColor.getGreen() + 10), Math.abs(this.bgColor.getBlue() - 20));
        this.bgColorDarkerGreener = new Color(Math.abs(this.bgColorDarker.getRed() - 35), Math.min(255, this.bgColorDarker.getGreen() + 5), Math.abs(this.bgColorDarker.getBlue() - 35));
    }

    @Override
    @NonNull
    public Component getListCellRendererComponent(@NonNull JList<?> list, @NullAllowed Object value, int index, boolean isSelected, boolean hasFocus) {
        int height = list.getFixedCellHeight();
        int width = list.getFixedCellWidth() - 1;
        width = width < 200 ? 200 : width;
        Dimension size = new Dimension(width, height);
        this.rendererComponent.setMaximumSize(size);
        this.rendererComponent.setPreferredSize(size);
        this.resetNameLabel();
        if (isSelected) {
            this.jlName.setForeground(this.fgSelectionColor);
            this.jlOwner.setForeground(this.fgSelectionColor);
            this.jlPrj.setForeground(this.fgSelectionColor);
            this.rendererComponent.setBackground(this.bgSelectionColor);
        } else {
            this.jlName.setForeground(this.fgColor);
            this.jlOwner.setForeground(this.fgColorLighter);
            this.jlPrj.setForeground(this.fgColor);
            this.rendererComponent.setBackground(index % 2 == 0 ? this.bgColor : this.bgColorDarker);
        }
        T item = this.dynamic_cast(value);
        if (item != null) {
            this.jlName.setIcon(this.convertor.getItemIcon(item));
            this.jlName.setText(this.convertor.getName(item));
            this.jlOwner.setText(this.convertor.getOwnerName(item));
            if (this.shouldHighlight(isSelected)) {
                String textToFormat;
                JLabel highlightedTarget;
                if (this.searchFolders != null && this.searchFolders.isSelected()) {
                    highlightedTarget = this.jlOwner;
                    textToFormat = this.convertor.getOwnerName(item);
                } else {
                    highlightedTarget = this.jlName;
                    textToFormat = this.convertor.getName(item);
                }
                String formattedName = this.highlight(textToFormat, this.convertor.getHighlightText(item), this.caseSensitive.isSelected(), isSelected ? this.fgSelectionColor : this.fgColor);
                highlightedTarget.setText(formattedName);
            }
            this.setProjectName(this.jlPrj, this.convertor.getProjectName(item));
            this.jlPrj.setIcon(this.convertor.getProjectIcon(item));
            if (!isSelected) {
                boolean cprj;
                boolean bl = cprj = this.colorPrefered != null && this.colorPrefered.isSelected() && this.convertor.isFromCurrentProject(item);
                Color bgc = index % 2 == 0 ? (cprj ? this.bgColorGreener : this.bgColor) : (cprj ? this.bgColorDarkerGreener : this.bgColorDarker);
                this.jlName.setBackground(bgc);
                this.rendererComponent.setBackground(bgc);
            }
            this.rendererComponent.setItem(item);
        } else {
            this.jlName.setText(String.valueOf(value));
        }
        return this.rendererComponent;
    }

    @Override
    public void stateChanged(@NonNull ChangeEvent event) {
        JViewport jv = (JViewport)event.getSource();
        this.jlName.setText("Sample");
        this.jlName.setIcon(ImageUtilities.loadImageIcon((String)SAMPLE_ITEM_ICON, (boolean)false));
        this.jList.setFixedCellHeight(this.jlName.getPreferredSize().height);
        this.jList.setFixedCellWidth(jv.getExtentSize().width);
    }

    @CheckForNull
    private T dynamic_cast(@NullAllowed Object obj) {
        if (this.clzCache == null) {
            for (Type type : this.convertor.getClass().getGenericInterfaces()) {
                if (!(type instanceof ParameterizedType) || Convertor.class != ((ParameterizedType)type).getRawType()) continue;
                this.clzCache = (Class)((ParameterizedType)type).getActualTypeArguments()[0];
                break;
            }
        }
        return this.clzCache != null && this.clzCache.isInstance(obj) ? (T)this.clzCache.cast(obj) : null;
    }

    private void setProjectName(JLabel jlPrj, String projectName) {
        if (this.isMainProject(projectName)) {
            jlPrj.setText(this.getBoldText(projectName));
        } else {
            jlPrj.setText(projectName);
        }
    }

    private String getBoldText(String text) {
        StringBuilder sb = new StringBuilder("<html><b>");
        sb.append(text);
        sb.append("</b></html>");
        return sb.toString();
    }

    private boolean isMainProject(String projectName) {
        return projectName != null && projectName.equals(this.mainProjectName);
    }

    private void resetNameLabel() {
        Font font = this.jList.getFont();
        this.jlName.setFont(font);
        this.jlName.setOpaque(false);
    }

    private boolean shouldHighlight(boolean selectedItem) {
        return switch (this.highlightMode) {
            default -> throw new IncompatibleClassChangeError();
            case GoToSettings.HighlightingMode.NONE -> false;
            case GoToSettings.HighlightingMode.ACTIVE -> selectedItem;
            case GoToSettings.HighlightingMode.ALL -> true;
        };
    }

    @NonNull
    private String highlight(@NonNull String name, @NonNull String highlightText, boolean caseSensitive, @NonNull Color color) {
        return "<html><nobr>" + this.nameFormater.formatName(UiUtils.htmlize(name), UiUtils.htmlize(highlightText), caseSensitive, color) + "</nobr>";
    }

    private static HighlightingNameFormatter createNameFormatter(@NonNull GoToSettings.HighlightingType type, @NullAllowed String separatorPattern) {
        switch (type) {
            case BACKGROUND: {
                AttributeSet attrs;
                Color back = new Color(236, 235, 163);
                Color front = Color.BLACK;
                FontColorSettings colors = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
                if (colors != null && (attrs = colors.getFontColors("mark-occurrences")) != null) {
                    Object object = attrs.getAttribute(StyleConstants.Background);
                    if (object instanceof Color) {
                        Color bg;
                        back = bg = (Color)object;
                    }
                    if ((object = attrs.getAttribute(StyleConstants.Foreground)) instanceof Color) {
                        Color fg;
                        front = fg = (Color)object;
                    }
                }
                return HighlightingNameFormatter.Builder.create().setCamelCaseSeparator(separatorPattern).buildColorFormatter(back, front);
            }
            case BOLD: {
                return HighlightingNameFormatter.Builder.create().setCamelCaseSeparator(separatorPattern).buildBoldFormatter();
            }
        }
        throw new IllegalStateException(String.valueOf((Object)type));
    }

    public static interface Convertor<T> {
        public String getName(T var1);

        public String getHighlightText(T var1);

        public String getOwnerName(T var1);

        public String getProjectName(T var1);

        public String getFilePath(T var1);

        public Icon getItemIcon(T var1);

        public Icon getProjectIcon(T var1);

        public boolean isFromCurrentProject(T var1);
    }

    private static class MyPanel<T>
    extends JPanel {
        private final Convertor<T> convertor;
        private T item;

        MyPanel(@NonNull Convertor<T> convertor) {
            this.convertor = convertor;
        }

        void setItem(T item) {
            this.item = item;
            this.putClientProperty("ToolTipText", null);
        }

        @Override
        public String getToolTipText() {
            String text = (String)this.getClientProperty("ToolTipText");
            if (text == null) {
                if (this.item != null) {
                    text = this.convertor.getFilePath(this.item);
                }
                this.putClientProperty("ToolTipText", text);
            }
            return text;
        }
    }

    public static final class Builder<T> {
        private final JList<T> list;
        private final ButtonModel caseSensitive;
        private final Convertor<T> convertor;
        private String separatorPattern;
        private ButtonModel colorPrefered;
        private ButtonModel searchFolders;

        private Builder(@NonNull JList<T> list, @NonNull ButtonModel caseSensitive, @NonNull Convertor<T> convertor) {
            this.list = list;
            this.caseSensitive = caseSensitive;
            this.convertor = convertor;
        }

        @NonNull
        public ItemRenderer<T> build() {
            return new ItemRenderer<T>(this.list, this.caseSensitive, this.colorPrefered, this.searchFolders, this.convertor, this.separatorPattern);
        }

        @NonNull
        public Builder setCamelCaseSeparator(@NullAllowed String separatorPattern) {
            this.separatorPattern = separatorPattern;
            return this;
        }

        @NonNull
        public Builder setColorPreferedProject(@NullAllowed ButtonModel colorPrefered) {
            this.colorPrefered = colorPrefered;
            return this;
        }

        @NonNull
        public Builder setSearchFolders(@NullAllowed ButtonModel searchFolders) {
            this.searchFolders = searchFolders;
            return this;
        }

        @NonNull
        public static <T> Builder<T> create(@NonNull JList<T> list, @NonNull ButtonModel caseSensitive, @NonNull Convertor<T> convertor) {
            return new Builder<T>(list, caseSensitive, convertor);
        }
    }
}

