/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.WizardUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.Bundle;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class LayoutSummaryPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JLabel filler;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;

    public LayoutSummaryPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", Bundle.LBL_LayoutSummaryTitle());
    }

    @Override
    protected void storeToDataModel() {
    }

    @Override
    protected void readFromDataModel() {
        NewTCIterator.generateFileChanges(this.data);
        this.createdFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getCreatedPaths()));
        this.modifiedFilesValue.setText(WizardUtils.generateTextAreaContent(this.data.getCreatedModifiedFiles().getModifiedPaths()));
        String[] invalid = this.data.getCreatedModifiedFiles().getInvalidPaths();
        if (invalid.length > 0) {
            this.setError(NbBundle.getMessage(LayoutSummaryPanel.class, (String)"ERR_ToBeCreateFileExists", (Object)invalid[0]));
        }
    }

    @Override
    protected String getPanelName() {
        return Bundle.LBL_LayoutSummaryTitle();
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(LayoutSummaryPanel.class);
    }

    private void initComponents() {
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.filler = new JLabel();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValue = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.createdFiles.setLabelFor(this.createdFilesValue);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/librarydescriptor/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)bundle.getString("LBL_CreatedFiles"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add(this.createdFiles, gridBagConstraints);
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)bundle.getString("LBL_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.modifiedFiles, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler, gridBagConstraints);
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add(this.createdFilesValue, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText("modifiedFilesValue");
        this.modifiedFilesValue.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add(this.modifiedFilesValue, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Bundle.ACS_LayoutSummaryPanel());
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(Bundle.ACS_CTL_Layout_CreatedFilesValue());
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(Bundle.ACS_CTL_Layout_ModifiedFilesValue());
    }
}

