/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.view.DesignViewPopupProvider;
import org.netbeans.modules.websvc.design.view.actions.AddOperationAction;
import org.netbeans.modules.websvc.design.view.actions.RemoveOperationAction;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.FlushableWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.ObjectSceneAdapter;
import org.netbeans.modules.websvc.design.view.widget.OperationWidget;
import org.openide.util.NbBundle;

public class OperationsWidget
extends FlushableWidget {
    private transient ServiceModel serviceModel;
    private transient Action addAction;
    private transient RemoveOperationAction removeAction;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private ObjectSceneListener operationSelectionListener;

    public OperationsWidget(ObjectScene scene, final ProjectService service, final ServiceModel serviceModel) {
        super(scene, 12, BORDER_COLOR);
        this.serviceModel = serviceModel;
        serviceModel.addServiceChangeListener(new ServiceChangeListener(){

            @Override
            public void propertyChanged(String propertyName, String oldValue, String newValue) {
            }

            @Override
            public void operationAdded(final MethodModel method) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OperationWidget operationWidget = new OperationWidget(OperationsWidget.this.getObjectScene(), serviceModel, service, method);
                            OperationsWidget.this.getContentWidget().addChild((Widget)operationWidget);
                            OperationsWidget.this.updateHeaderLabel();
                            OperationsWidget.this.getScene().validate();
                        }
                    });
                } else {
                    OperationWidget operationWidget = new OperationWidget(OperationsWidget.this.getObjectScene(), serviceModel, service, method);
                    OperationsWidget.this.getContentWidget().addChild((Widget)operationWidget);
                    OperationsWidget.this.updateHeaderLabel();
                    OperationsWidget.this.getScene().validate();
                }
            }

            @Override
            public void operationRemoved(MethodModel method) {
                final Widget operationWidget = OperationsWidget.this.getObjectScene().findWidget((Object)method);
                if (operationWidget != null) {
                    if (!EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OperationsWidget.this.getContentWidget().removeChild(operationWidget);
                                OperationsWidget.this.updateHeaderLabel();
                                OperationsWidget.this.getScene().validate();
                            }
                        });
                    } else {
                        OperationsWidget.this.getContentWidget().removeChild(operationWidget);
                        OperationsWidget.this.updateHeaderLabel();
                        OperationsWidget.this.getScene().validate();
                    }
                }
            }

            @Override
            public void operationChanged(final MethodModel oldMethod, final MethodModel newMethod) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationRemoved(oldMethod);
                            this.operationAdded(newMethod);
                        }
                    });
                } else {
                    this.operationRemoved(oldMethod);
                    this.operationAdded(newMethod);
                }
            }
        });
        this.addAction = new AddOperationAction(service, serviceModel.getImplementationClass());
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new DesignViewPopupProvider(new Action[]{this.addAction})));
        this.createContent(service);
    }

    private void createContent(ProjectService service) {
        if (this.serviceModel == null) {
            return;
        }
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), null, NbBundle.getMessage(OperationWidget.class, (String)"LBL_Operations"));
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.updateHeaderLabel();
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        ButtonWidget addButton = new ButtonWidget(this.getScene(), this.addAction);
        addButton.setOpaque(true);
        addButton.setRoundedBorder(3, 4, 0, null);
        this.removeAction = new RemoveOperationAction(service);
        ButtonWidget removeButton = new ButtonWidget(this.getScene(), this.removeAction);
        removeButton.setOpaque(true);
        removeButton.setRoundedBorder(3, 4, 0, null);
        this.buttons.addChild((Widget)addButton);
        this.buttons.addChild((Widget)removeButton);
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12));
        if (this.serviceModel.getOperations() != null) {
            for (MethodModel operation : this.serviceModel.getOperations()) {
                OperationWidget operationWidget = new OperationWidget(this.getObjectScene(), this.serviceModel, service, operation);
                this.getContentWidget().addChild((Widget)operationWidget);
            }
        }
    }

    private void updateHeaderLabel() {
        int noOfOperations = this.serviceModel.getOperations() == null ? 0 : this.serviceModel.getOperations().size();
        this.headerLabelWidget.setComment("(" + noOfOperations + ")");
    }

    @Override
    public Object hashKey() {
        return this.serviceModel;
    }

    @Override
    protected void notifyAdded() {
        super.notifyAdded();
        this.operationSelectionListener = new ObjectSceneAdapter(){

            @Override
            public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
                HashSet<MethodModel> methods = new HashSet<MethodModel>();
                if (newSelection != null) {
                    for (Object obj : newSelection) {
                        if (!(obj instanceof MethodModel)) continue;
                        methods.add((MethodModel)obj);
                    }
                }
                OperationsWidget.this.removeAction.setWorkingSet(methods);
            }
        };
        this.getObjectScene().addObjectSceneListener(this.operationSelectionListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
    }

    @Override
    protected void notifyRemoved() {
        super.notifyRemoved();
        if (this.operationSelectionListener != null) {
            this.getObjectScene().removeObjectSceneListener(this.operationSelectionListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
            this.operationSelectionListener = null;
        }
    }

    public void addToolbarActions(JToolBar toolbar) {
        toolbar.add(this.addAction);
    }
}

