/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.jpda;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.openide.util.Lookup;

public interface Evaluator<PreprocessedInfo> {
    public Result evaluate(Expression<PreprocessedInfo> var1, Context var2) throws InvalidExpressionException;

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String language();
    }

    public static final class Result {
        private Variable var;
        private Value v;

        public Result(Variable var) {
            this.var = var;
        }

        public Result(Value v) {
            this.v = v;
        }

        public Variable getVariable() {
            return this.var;
        }

        public Value getValue() {
            return this.v;
        }
    }

    public static final class Context {
        private CallStackFrame callStackFrame;
        private ObjectVariable contextVariable;
        private StackFrame stackFrame;
        private int stackDepth;
        private ObjectReference contextObject;
        private Runnable methodToBeInvokedNotifier;

        public Context(Lookup context) {
            this.callStackFrame = (CallStackFrame)context.lookup(CallStackFrame.class);
            this.contextVariable = (ObjectVariable)context.lookup(ObjectVariable.class);
            this.stackFrame = (StackFrame)context.lookup(StackFrame.class);
            this.stackDepth = (Integer)context.lookup(Integer.class);
            this.contextObject = (ObjectReference)context.lookup(ObjectReference.class);
            this.methodToBeInvokedNotifier = (Runnable)context.lookup(Runnable.class);
        }

        public CallStackFrame getCallStackFrame() {
            return this.callStackFrame;
        }

        public ObjectVariable getContextVariable() {
            return this.contextVariable;
        }

        public StackFrame getStackFrame() {
            return this.stackFrame;
        }

        public int getStackDepth() {
            return this.stackDepth;
        }

        public ObjectReference getContextObject() {
            return this.contextObject;
        }

        public void notifyMethodToBeInvoked() {
            this.methodToBeInvokedNotifier.run();
        }
    }

    public static final class Expression<PreprocessedInfo> {
        private String expression;
        private PreprocessedInfo preprocessed;

        public Expression(String expression) {
            this.expression = expression;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setPreprocessedObject(PreprocessedInfo preprocessed) {
            this.preprocessed = preprocessed;
        }

        public PreprocessedInfo getPreprocessedObject() {
            return this.preprocessed;
        }
    }
}

