/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.options;

import java.awt.EventQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.netbeans.modules.php.project.annotations.UserAnnotations;
import org.netbeans.modules.php.project.ui.PhpAnnotationsPanel;
import org.netbeans.modules.php.project.ui.options.BaseOptionsPanelController;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class PhpAnnotationsPanelController
extends BaseOptionsPanelController {
    private static final Logger LOGGER = Logger.getLogger(PhpAnnotationsPanelController.class.getName());
    public static final String ID = "Annotations";
    private PhpAnnotationsPanel panel = null;

    @Override
    protected boolean validateComponent() {
        assert (EventQueue.isDispatchThread());
        return true;
    }

    @Override
    protected void updateInternal() {
        assert (EventQueue.isDispatchThread());
        this.getPanel();
        this.panel.setAnnotations(UserAnnotations.getGlobal().getAnnotations());
        this.panel.setResolveDeprecatedElements(PhpOptions.getInstance().isAnnotationsResolveDeprecatedElements());
        this.panel.setUnknownAsType(PhpOptions.getInstance().isAnnotationsUnknownAnnotationsAsTypeAnnotations());
    }

    @Override
    protected void applyChangesInternal() {
        assert (EventQueue.isDispatchThread());
        this.getPanel();
        UserAnnotations.getGlobal().setAnnotations(this.panel.getAnnotations());
        boolean resolveDeprecatedElements = this.panel.isResolveDeprecatedElements();
        LOGGER.log(Level.INFO, "Resolving of deprecated PHP elements: {0}", resolveDeprecatedElements);
        PhpOptions.getInstance().setAnnotationsResolveDeprecatedElements(resolveDeprecatedElements);
        PhpOptions.getInstance().setAnnotationsUnknownAnnotationsAsTypeAnnotations(this.panel.isUnknownAsType());
    }

    @Override
    protected boolean areOptionsChanged() {
        this.getPanel();
        return PhpOptions.getInstance().isAnnotationsResolveDeprecatedElements() != this.panel.isResolveDeprecatedElements() || PhpOptions.getInstance().isAnnotationsUnknownAnnotationsAsTypeAnnotations() != this.panel.isUnknownAsType() || !UserAnnotations.getGlobal().getAnnotations().equals(this.panel.getAnnotations());
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.ui.options.PhpAnnotationsPanelController");
    }

    private PhpAnnotationsPanel getPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.panel == null) {
            this.panel = PhpAnnotationsPanel.forOptions();
            this.panel.addChangeListener(this);
        }
        return this.panel;
    }
}

