/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;

public class GenericResourceBean {
    public static final String RESOURCE_SUFFIX = "Resource";
    public static final Constants.MimeType[] supportedMimeTypes = new Constants.MimeType[]{Constants.MimeType.XML, Constants.MimeType.JSON, Constants.MimeType.TEXT, Constants.MimeType.HTML};
    public static final Constants.HttpMethodType[] CONTAINER_METHODS = new Constants.HttpMethodType[]{Constants.HttpMethodType.GET, Constants.HttpMethodType.POST};
    public static final Constants.HttpMethodType[] ITEM_METHODS = new Constants.HttpMethodType[]{Constants.HttpMethodType.GET, Constants.HttpMethodType.PUT, Constants.HttpMethodType.DELETE};
    public static final Constants.HttpMethodType[] STAND_ALONE_METHODS = new Constants.HttpMethodType[]{Constants.HttpMethodType.GET, Constants.HttpMethodType.PUT};
    public static final Constants.HttpMethodType[] CLIENT_CONTROL_CONTAINER_METHODS = new Constants.HttpMethodType[]{Constants.HttpMethodType.GET};
    private String name;
    private String packageName;
    private String uriTemplate;
    private Constants.MimeType[] mimeTypes;
    private String[] representationTypes;
    private Set<Constants.HttpMethodType> methodTypes;
    private boolean privateFieldForQueryParam;
    private boolean generateUriTemplate = true;
    private List<GenericResourceBean> subResources;
    private Constants.HttpMethodType httpMethod;
    private String[] uriParams = null;

    public GenericResourceBean(String name, String packageName, String uriTemplate) {
        this(name, packageName, uriTemplate, supportedMimeTypes, Constants.HttpMethodType.values());
    }

    public GenericResourceBean(String name, String packageName, String uriTemplate, Constants.MimeType[] mediaTypes, Constants.HttpMethodType[] methodTypes) {
        this(name, packageName, uriTemplate, mediaTypes, null, methodTypes);
    }

    public GenericResourceBean(String name, String packageName, String uriTemplate, Constants.MimeType[] mediaTypes, String[] representationTypes, Constants.HttpMethodType[] methodTypes) {
        this.name = name;
        this.packageName = packageName;
        this.uriTemplate = uriTemplate;
        this.methodTypes = new HashSet<Constants.HttpMethodType>(Arrays.asList(methodTypes));
        this.subResources = new ArrayList<GenericResourceBean>();
        if (representationTypes == null) {
            representationTypes = new String[mediaTypes.length];
            for (int i = 0; i < representationTypes.length; ++i) {
                representationTypes[i] = String.class.getName();
            }
        }
        if (mediaTypes.length != representationTypes.length) {
            throw new IllegalArgumentException("Unmatched media types and representation types");
        }
        this.mimeTypes = mediaTypes;
        this.representationTypes = representationTypes == null ? new String[]{} : representationTypes;
    }

    public static Constants.MimeType[] getSupportedMimeTypes() {
        return supportedMimeTypes;
    }

    public static String getDefaultRepresetationClass(Constants.MimeType mime) {
        if (mime == Constants.MimeType.XML || mime == Constants.MimeType.TEXT || mime == Constants.MimeType.HTML || mime == Constants.MimeType.JSON) {
            return String.class.getName();
        }
        return String.class.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return GenericResourceBean.getShortName(this.name);
    }

    public static String getShortName(String name) {
        if (name.endsWith(RESOURCE_SUFFIX)) {
            return name.substring(0, name.length() - 8);
        }
        return name;
    }

    public String getUriWhenUsedAsSubResource() {
        return Util.lowerFirstChar(this.getShortName()) + "/";
    }

    public void setPackageName(String name) {
        this.packageName = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getUriTemplate() {
        return this.uriTemplate;
    }

    public void setUriTemplate(String uriTemplate) {
        this.uriTemplate = uriTemplate;
    }

    public Constants.MimeType[] getMimeTypes() {
        return this.mimeTypes;
    }

    public void setMimeTypes(Constants.MimeType[] mimeTypes) {
        this.mimeTypes = mimeTypes;
    }

    public String[] getRepresentationTypes() {
        return this.representationTypes;
    }

    public Set<Constants.HttpMethodType> getMethodTypes() {
        return this.methodTypes;
    }

    public void setMethodTypes(Constants.HttpMethodType[] types) {
        this.methodTypes = new HashSet<Constants.HttpMethodType>(Arrays.asList(types));
    }

    public String[] getUriParams() {
        if (this.uriParams == null) {
            this.uriParams = GenericResourceBean.getUriParams(this.uriTemplate);
        }
        return this.uriParams;
    }

    public static String[] getUriParams(String template) {
        if (template == null) {
            return new String[0];
        }
        String[] segments = template.split("/");
        ArrayList<String> res = new ArrayList<String>();
        for (String segment : segments) {
            if (!segment.startsWith("{")) continue;
            if (segment.length() > 2 && segment.endsWith("}")) {
                res.add(segment.substring(1, segment.length() - 1));
                continue;
            }
            throw new IllegalArgumentException(template);
        }
        return res.toArray(new String[0]);
    }

    public String getQualifiedClassName() {
        return this.getPackageName() + "." + this.getName();
    }

    public void addSubResource(GenericResourceBean bean) {
        this.subResources.add(bean);
    }

    public List<GenericResourceBean> getSubResources() {
        return this.subResources;
    }

    public boolean isPrivateFieldForQueryParam() {
        return this.privateFieldForQueryParam;
    }

    public void setPrivateFieldForQueryParam(boolean privateFieldForQueryParam) {
        this.privateFieldForQueryParam = privateFieldForQueryParam;
    }

    public boolean isGenerateUriTemplate() {
        return this.generateUriTemplate;
    }

    public void setGenerateUriTemplate(boolean flag) {
        this.generateUriTemplate = flag;
    }

    public List<ParameterInfo> getInputParameters() {
        return Collections.emptyList();
    }

    public List<ParameterInfo> getQueryParameters() {
        return Collections.emptyList();
    }

    public static String getGetMethodName(Constants.MimeType mime) {
        return "get" + mime.suffix();
    }

    public Constants.HttpMethodType getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(Constants.HttpMethodType httpMethod) {
        this.httpMethod = httpMethod;
    }

    public static String getHttpMethodName(Constants.HttpMethodType httpMethod, Constants.MimeType mime) {
        return httpMethod.value().toLowerCase() + mime.suffix();
    }

    public Constants.SaasAuthenticationType getAuthenticationType() {
        return Constants.SaasAuthenticationType.PLAIN;
    }

    public SaasBean.SaasAuthentication getAuthentication() {
        return null;
    }

    public List<ParameterInfo> filterParametersByAuth(List<ParameterInfo> params) {
        return Util.filterParametersByAuth(this.getAuthenticationType(), this.getAuthentication(), params);
    }

    public List<ParameterInfo> filterParameters(ParameterInfo.ParamFilter[] filters) {
        return this.filterParameters(this.getInputParameters(), filters);
    }

    public List<ParameterInfo> filterParameters(List<ParameterInfo> params, ParameterInfo.ParamFilter[] filters) {
        return Util.filterParameters(params, filters);
    }
}

