/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.util.concurrent.TimeUnit;
import org.netbeans.modules.nativeexecution.ProcessStatusAccessor;

public final class ProcessStatusEx {
    private final int exitCode;
    private final String termSignal;
    private final boolean ifCoreDump;
    private final long rtime;
    private final long utime;
    private final long stime;
    private final long maxRSS;

    private ProcessStatusEx(String[] data) {
        int _exitCode = -1;
        String _termSignal = null;
        boolean _ifCoreDump = false;
        long _rtime = 0L;
        long _utime = 0L;
        long _stime = 0L;
        long _maxRSS = 0L;
        for (String line : data) {
            int pos = line.indexOf(58);
            if (pos < 0) continue;
            String param = line.substring(0, pos);
            String value = line.substring(pos + 1).trim();
            if ("RC".equals(param)) {
                _exitCode = Integer.parseInt(value);
                continue;
            }
            if ("SIG".equals(param)) {
                _termSignal = "-".equals(value) ? null : value;
                continue;
            }
            if ("CORE".equals(param)) {
                _ifCoreDump = "1".equals(value);
                continue;
            }
            if ("RTIME".equals(param)) {
                _rtime = Long.parseLong(value);
                continue;
            }
            if ("STIME".equals(param)) {
                _stime = Long.parseLong(value);
                continue;
            }
            if ("UTIME".equals(param)) {
                _utime = Long.parseLong(value);
                continue;
            }
            if (!"MAXRSS".equals(param)) continue;
            _maxRSS = Long.parseLong(value);
        }
        this.exitCode = _exitCode;
        this.termSignal = _termSignal;
        this.ifCoreDump = _ifCoreDump;
        this.rtime = _rtime;
        this.stime = _stime;
        this.utime = _utime;
        this.maxRSS = _maxRSS;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public long realTime(TimeUnit unit) {
        return unit.convert(this.rtime, TimeUnit.MILLISECONDS);
    }

    public long usrTime(TimeUnit unit) {
        return unit.convert(this.utime, TimeUnit.MILLISECONDS);
    }

    public long sysTime(TimeUnit unit) {
        return unit.convert(this.stime, TimeUnit.MILLISECONDS);
    }

    public long maxRSS() {
        return this.maxRSS;
    }

    public boolean ifCoreDump() {
        return this.ifCoreDump;
    }

    public boolean ifSignalled() {
        return this.termSignal != null;
    }

    public boolean ifExited() {
        return !this.ifSignalled();
    }

    public String termSignal() {
        return this.termSignal;
    }

    static {
        ProcessStatusAccessor.setDefault(new Accessor());
    }

    private static class Accessor
    extends ProcessStatusAccessor {
        private Accessor() {
        }

        @Override
        public ProcessStatusEx create(String[] data) {
            return new ProcessStatusEx(data);
        }
    }
}

