/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.websvc.api.support.InvokeOperationCookie;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.core.WebServiceActionProvider;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CallWsOperationGenerator
implements CodeGenerator {
    private FileObject targetSource;
    private JTextComponent targetComponent;
    private InvokeOperationCookie invokeOperationCookie;

    CallWsOperationGenerator(FileObject targetSource, JTextComponent targetComponent, InvokeOperationCookie invokeOperationCookie) {
        this.targetSource = targetSource;
        this.targetComponent = targetComponent;
        this.invokeOperationCookie = invokeOperationCookie;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CallWsOperationGenerator.class, (String)"LBL_CallWebServiceOperation");
    }

    public void invoke() {
        InvokeOperationCookie.ClientSelectionPanel innerPanel = this.invokeOperationCookie.getDialogDescriptorPanel();
        final DialogDescriptor descriptor = new DialogDescriptor((Object)innerPanel, NbBundle.getMessage(CallWsOperationGenerator.class, (String)"TTL_SelectOperation"));
        descriptor.setValid(false);
        innerPanel.addPropertyChangeListener(InvokeOperationCookie.ClientSelectionPanel.PROPERTY_SELECTION_VALID, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                descriptor.setValid(((Boolean)evt.getNewValue()).booleanValue());
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (DialogDescriptor.OK_OPTION.equals(descriptor.getValue())) {
            Lookup selectedClient = innerPanel.getSelectedClient();
            this.invokeOperationCookie.invokeOperation(selectedClient, this.targetComponent);
            Object[] params = new Object[2];
            String cookieClassName = this.invokeOperationCookie.getClass().getName();
            params[0] = cookieClassName.contains("jaxrpc") ? "JAX-RPC" : "JAX-WS";
            params[1] = "CALL WS OPERATION";
            LogUtils.logWsAction((Object[])params);
        }
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            CompilationController controller = (CompilationController)context.lookup(CompilationController.class);
            ArrayList<CallWsOperationGenerator> ret = new ArrayList<CallWsOperationGenerator>();
            if (controller != null) {
                try {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject targetSource = controller.getFileObject();
                    if (targetSource != null) {
                        JTextComponent targetComponent = (JTextComponent)context.lookup(JTextComponent.class);
                        InvokeOperationCookie invokeOperationCookie = WebServiceActionProvider.getInvokeOperationAction(targetSource);
                        if (invokeOperationCookie != null) {
                            ret.add(new CallWsOperationGenerator(targetSource, targetComponent, invokeOperationCookie));
                        }
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            return ret;
        }
    }
}

