/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ParamEditor
extends JPanel {
    private static final Dimension valueSize = new Dimension(400, 150);
    private Dialog dialog = null;
    private Dialog d2 = null;
    private DialogDescriptor editDialog = null;
    private String errorMessage = null;
    private boolean dialogOK = false;
    private String name = "";
    private String value = "";
    private Editable editable;
    private Condition condition;
    private String title = "";
    private boolean repainting = false;

    public ParamEditor(String name, String value, Editable e, Condition c, String title) {
        this.name = name;
        this.value = value;
        this.editable = e;
        this.condition = c;
        this.title = title;
        this.initialize();
    }

    public boolean getDialogOK() {
        return this.dialogOK;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints labelC = new GridBagConstraints();
        labelC.gridx = 0;
        labelC.gridy = -1;
        labelC.anchor = 17;
        labelC.fill = 2;
        labelC.insets = new Insets(4, 15, 4, 15);
        GridBagConstraints firstC = new GridBagConstraints();
        firstC.gridx = 0;
        firstC.gridy = -1;
        firstC.gridwidth = 1;
        firstC.anchor = 17;
        firstC.insets = new Insets(4, 15, 4, 0);
        GridBagConstraints tfC = new GridBagConstraints();
        tfC.gridx = -1;
        tfC.gridy = 0;
        tfC.gridwidth = 7;
        tfC.fill = 2;
        tfC.insets = new Insets(4, 0, 4, 15);
        GridBagConstraints taC = new GridBagConstraints();
        taC.gridx = 0;
        taC.gridy = -1;
        taC.gridheight = 3;
        taC.gridwidth = 8;
        taC.weightx = 1.0;
        taC.weighty = 1.0;
        taC.fill = 1;
        taC.anchor = 17;
        taC.insets = new Insets(0, 15, 4, 15);
        JLabel nameLabel = new JLabel();
        nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_NameA11yDesc"));
        if (this.name == null || this.name.length() == 0) {
            this.getAccessibleContext().setAccessibleDescription(this.title);
        } else {
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParamEditor.class, (String)"ACS_ParamEditorA11yDesc", (Object)this.title, (Object)this.name));
        }
        String text = NbBundle.getMessage(ParamEditor.class, (String)"MON_Param_Name");
        if (this.editable == Editable.BOTH) {
            final JTextField nameText = new JTextField(25);
            nameText.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent evt) {
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    ParamEditor.this.name = nameText.getText();
                }
            });
            nameLabel.setLabelFor(nameText);
            nameText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_NameTextFieldA11yName"));
            nameText.setToolTipText(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_NameTextFieldA11yDesc"));
            nameText.setText(this.name);
            nameText.setBackground(Color.white);
            nameText.setEditable(this.editable == Editable.BOTH);
            this.add((Component)nameLabel, firstC);
            this.add((Component)nameText, tfC);
        } else {
            this.add((Component)nameLabel, labelC);
            text = text.concat(this.name);
        }
        Mnemonics.setLocalizedText((JLabel)nameLabel, (String)text);
        JLabel valueLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)valueLabel, (String)NbBundle.getMessage(ParamEditor.class, (String)"MON_Param_Value"));
        valueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_ValueA11yDesc"));
        ++firstC.gridy;
        this.add((Component)valueLabel, labelC);
        final JTextArea valueText = new JTextArea();
        valueText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent evt) {
            }

            @Override
            public void focusLost(FocusEvent evt) {
                ParamEditor.this.value = valueText.getText();
            }
        });
        valueLabel.setLabelFor(valueText);
        valueText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_ValueTextAreaA11yName"));
        valueText.setToolTipText(NbBundle.getMessage(ParamEditor.class, (String)"ACS_MON_ValueTextAreaA11yDesc"));
        if (this.editable == Editable.NEITHER) {
            valueText.setEditable(false);
            valueText.setBackground(this.getBackground());
            valueText.setForeground(Color.BLACK);
            valueText.setBorder(BorderFactory.createLoweredBevelBorder());
        }
        valueText.setText(this.value);
        valueText.setLineWrap(true);
        valueText.setWrapStyleWord(false);
        JScrollPane scrollpane = new JScrollPane(valueText);
        scrollpane.setPreferredSize(valueSize);
        this.add((Component)scrollpane, taC);
        this.repaint();
    }

    public void showDialog() {
        if (this.editable == Editable.NEITHER) {
            NotifyDescriptor d = new NotifyDescriptor((Object)this, this.title, -1, -1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
            DialogDisplayer.getDefault().notify(d);
        } else {
            this.editDialog = new DialogDescriptor((Object)this, this.title, true, 2, DialogDescriptor.CANCEL_OPTION, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ParamEditor.this.evaluateInput();
                }
            });
            this.dialog = DialogDisplayer.getDefault().createDialog(this.editDialog);
            this.dialog.setVisible(true);
            this.repaint();
        }
    }

    public void evaluateInput() {
        if (this.editDialog.getValue().equals(NotifyDescriptor.CANCEL_OPTION)) {
            this.dialog.dispose();
            this.dialogOK = false;
            return;
        }
        if (this.editable == Editable.NEITHER) {
            this.dialog.dispose();
            this.dialogOK = false;
            return;
        }
        this.errorMessage = null;
        if (this.name.equals("")) {
            this.errorMessage = NbBundle.getMessage(ParamEditor.class, (String)"MSG_no_name");
        } else if (this.condition == Condition.COOKIE && this.name.equalsIgnoreCase("jsessionid")) {
            this.errorMessage = NbBundle.getMessage(ParamEditor.class, (String)"MSG_no_jsession");
        } else if (this.condition == Condition.VALUE && this.value.equals("")) {
            this.errorMessage = NbBundle.getMessage(ParamEditor.class, (String)"MSG_no_value");
        } else if (this.condition == Condition.HEADER && this.name.equalsIgnoreCase("cookie") && (this.value.indexOf("jsessionid") > -1 || this.value.indexOf("JSESSIONID") > -1)) {
            this.errorMessage = NbBundle.getMessage(ParamEditor.class, (String)"MSG_no_jsession");
        }
        if (this.errorMessage == null) {
            this.dialog.dispose();
            this.dialogOK = true;
        } else {
            this.editDialog.setValue(NotifyDescriptor.CLOSED_OPTION);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)this.errorMessage, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        if (this.dialog != null && !this.repainting) {
            this.repainting = true;
            this.dialog.repaint();
            this.repainting = false;
        }
    }

    static class Editable {
        private String editable;
        public static final Editable BOTH = new Editable("both");
        public static final Editable VALUE = new Editable("value");
        public static final Editable NEITHER = new Editable("neither");

        private Editable(String editable) {
            this.editable = editable;
        }

        public String toString() {
            return this.editable;
        }
    }

    static class Condition {
        private String condition;
        public static final Condition NONE = new Condition("none");
        public static final Condition VALUE = new Condition("value");
        public static final Condition COOKIE = new Condition("cookie");
        public static final Condition HEADER = new Condition("header");

        private Condition(String condition) {
            this.condition = condition;
        }

        public String toString() {
            return this.condition;
        }
    }
}

