/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFConfigModel;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationCase;
import org.netbeans.modules.web.jsf.api.facesmodel.NavigationRule;
import org.openide.util.Exceptions;

public class FacesModelUtility {
    private static final Logger LOGGER = Logger.getLogger(FacesModelUtility.class.getName());

    private FacesModelUtility() {
    }

    public static String getToViewIdFiltered(NavigationCase navCase) {
        String viewId = navCase.getToViewId();
        return FacesModelUtility.getViewIdFiltiered(viewId);
    }

    public static String getFromViewIdFiltered(NavigationRule navRule) {
        String viewId = navRule.getFromViewId();
        return FacesModelUtility.getViewIdFiltiered(viewId);
    }

    public static String getViewIdFiltiered(String paramViewId) {
        String viewId = paramViewId;
        if (viewId != null && viewId.length() > 0 && viewId.charAt(0) == '/') {
            viewId = viewId.replaceFirst("/", "");
        }
        return viewId;
    }

    public static void setToViewId(NavigationCase navCase, String filteredName) {
        if (filteredName != null && filteredName.length() > 0) {
            String unfilteredName = "/".concat(filteredName);
            navCase.setToViewId(unfilteredName);
        } else {
            navCase.setToViewId(filteredName);
        }
    }

    public static void setFromViewId(NavigationRule navRule, String filteredName) {
        if (filteredName != null && filteredName.length() > 0) {
            String unfilteredName = "/".concat(filteredName);
            navRule.setFromViewId(unfilteredName);
        } else {
            navRule.setFromViewId(filteredName);
        }
    }

    public static void renamePageInModel(JSFConfigModel configModel, String oldDisplayName, String newDisplayName) {
        if (oldDisplayName.equals(newDisplayName)) {
            return;
        }
        configModel.startTransaction();
        FacesConfig facesConfig = configModel.getRootComponent();
        List navRules = facesConfig.getNavigationRules();
        for (NavigationRule navRule : navRules) {
            String fromViewId = FacesModelUtility.getFromViewIdFiltered(navRule);
            if (fromViewId != null && fromViewId.equals(oldDisplayName)) {
                FacesModelUtility.setFromViewId(navRule, newDisplayName);
            }
            List navCases = navRule.getNavigationCases();
            for (NavigationCase navCase : navCases) {
                String toViewId = FacesModelUtility.getToViewIdFiltered(navCase);
                if (toViewId == null || !toViewId.equals(oldDisplayName)) continue;
                FacesModelUtility.setToViewId(navCase, newDisplayName);
            }
        }
        try {
            configModel.endTransaction();
            configModel.sync();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalStateException ise) {
            Exceptions.printStackTrace((Throwable)ise);
        }
    }
}

