/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITListItem;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;
import org.netbeans.modules.cpplite.debugger.CPPThread;
import org.netbeans.modules.cpplite.debugger.CPPVariable;
import org.netbeans.modules.cpplite.debugger.Command;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.spi.debug.filters.FrameDisplayer;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.Pair;

public final class CPPFrame
implements DebuggingView.DVFrame {
    private static final Logger LOGGER = Logger.getLogger(CPPFrame.class.getName());
    private final CPPThread thread;
    private final FrameDisplayer.DisplayedFrame displayedFrame;
    private final NIFrame niFrame;
    public final int level;
    private volatile Map<String, NIVariable> variables;
    private static final String MI_ERROR = "MI parse error: ";

    private CPPFrame(CPPThread thread, FrameDisplayer.DisplayedFrame displayedFrame, NIFrame niFrame) {
        Objects.requireNonNull(thread);
        Objects.requireNonNull(displayedFrame);
        Objects.requireNonNull(niFrame);
        this.thread = thread;
        this.displayedFrame = displayedFrame;
        this.niFrame = niFrame;
        this.level = niFrame.getLevel();
    }

    static CPPFrame create(CPPThread thread, MITList frame) {
        FrameDisplayer.DisplayedFrame displayedFrame;
        NIFrameImpl niFrame = new NIFrameImpl(thread.getId(), frame);
        FrameDisplayer frameDisplayer = (FrameDisplayer)thread.getDebugger().getContextProvider().lookupFirst(null, FrameDisplayer.class);
        FrameDisplayer.DisplayedFrame displayedFrame2 = displayedFrame = frameDisplayer != null ? frameDisplayer.displayed((NIFrame)niFrame) : CPPFrame.createDisplayedFrame(niFrame);
        if (displayedFrame == null) {
            return null;
        }
        return new CPPFrame(thread, displayedFrame, niFrame);
    }

    NIFrame getFrame() {
        return this.niFrame;
    }

    public String getName() {
        return this.displayedFrame.getDisplayName();
    }

    public String getDescription() {
        return this.displayedFrame.getDescription();
    }

    @CheckForNull
    public Line location() {
        FileObject file;
        URI sourceURI = this.displayedFrame.getSourceURI();
        if (sourceURI == null) {
            return null;
        }
        try {
            file = URLMapper.findFileObject((URL)sourceURI.toURL());
        }
        catch (MalformedURLException ex) {
            return null;
        }
        if (file == null) {
            return null;
        }
        LineCookie lc = (LineCookie)file.getLookup().lookup(LineCookie.class);
        return lc.getLineSet().getOriginal(this.displayedFrame.getLine() - 1);
    }

    public CPPThread getThread() {
        return this.thread;
    }

    public void makeCurrent() {
        this.thread.getDebugger().setCurrentStackFrame(this);
    }

    public URI getSourceURI() {
        return this.displayedFrame.getSourceURI();
    }

    public int getLine() {
        return this.displayedFrame.getLine();
    }

    public int getColumn() {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, NIVariable> getVariables() {
        Map<String, NIVariable> vars = this.variables;
        if (vars == null) {
            CPPFrame cPPFrame = this;
            synchronized (cPPFrame) {
                vars = this.variables;
                if (vars == null) {
                    this.variables = vars = CPPFrame.retrieveVariables(this, null);
                }
            }
        }
        return vars;
    }

    static Map<String, NIVariable> retrieveVariables(CPPFrame frame, CPPVariable parentVar) {
        MIRecord record;
        try {
            record = parentVar == null ? frame.thread.getDebugger().sendAndGet("-stack-list-variables --thread " + frame.thread.getId() + " --frame " + frame.level + " --no-frame-filters 2") : frame.thread.getDebugger().sendAndGet("-var-list-children --thread " + frame.thread.getId() + " --frame " + frame.level + " --all-values \"" + parentVar.getUniqueName() + "\"");
        }
        catch (InterruptedException ex) {
            return Collections.emptyMap();
        }
        if (record.isError()) {
            return Collections.singletonMap(record.error(), null);
        }
        MITList results = record.results();
        if (results.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, NIVariable> map = new LinkedHashMap<String, NIVariable>(results.size());
        MIValue children = results.valueOf("children");
        if (children != null) {
            for (MITListItem item : children.asList()) {
                MITList child = ((MIResult)item).value().asTList();
                String uniqueName = child.getConstValue("name");
                String name = child.getConstValue("exp");
                int numChildren = Integer.parseInt(child.getConstValue("numchild"));
                String type = child.getConstValue("type");
                MIValue value = child.valueOf("value");
                map.put(name, new CPPVariable(frame, parentVar, uniqueName, name, type, value, numChildren));
            }
        } else {
            MIValue resultValue = results.valueOf("variables");
            if (resultValue == null) {
                return Collections.emptyMap();
            }
            if (resultValue.isConst()) {
                return Collections.singletonMap(((MIConst)resultValue).value(), null);
            }
            results = (MITList)resultValue;
            LOGGER.log(Level.FINE, "retrieveVariables: have {0} variables:", results.size());
            for (MITListItem item : results) {
                MITList varList = (MITList)item;
                String name = varList.getConstValue("name");
                String type = varList.getConstValue("type");
                MIValue value = varList.valueOf("value");
                Pair<String, Integer> uniqueVar = CPPFrame.createVariable(frame, name);
                String uniqueName = (String)uniqueVar.first();
                if (uniqueName == null) continue;
                int numChildren = (Integer)uniqueVar.second();
                LOGGER.log(Level.FINE, "  {0} = ({1}) {2} ; [{3}]", new Object[]{name, type, value, numChildren});
                map.put(name, new CPPVariable(frame, parentVar, uniqueName, name, type, value, numChildren));
            }
        }
        return map;
    }

    private static Pair<String, Integer> createVariable(CPPFrame frame, String variableName) {
        String uniqueName = null;
        int numChildren = 0;
        try {
            String name;
            MIRecord record = frame.thread.getDebugger().sendAndGet("-var-create --thread " + frame.thread.getId() + " --frame " + frame.level + " - * " + variableName);
            if (!(record.isError() || record.isEmpty() || (name = record.results().getConstValue("name")).isEmpty())) {
                uniqueName = name;
                String numchild = record.results().getConstValue("numchild");
                numChildren = Integer.parseInt(numchild);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Pair.of(uniqueName, (Object)numChildren);
    }

    private static int retrieveNumChildren(CPPFrame frame, String variableName) {
        int numChildren = 0;
        try {
            String numchild;
            MIRecord record = frame.thread.getDebugger().sendAndGet("-var-info-num-children --thread " + frame.thread.getId() + " --frame " + frame.level + " " + variableName);
            if (!(record.isError() || record.isEmpty() || (numchild = record.results().getConstValue("numchild")).isEmpty())) {
                numChildren = Integer.parseInt(numchild);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return numChildren;
    }

    public CompletableFuture<NIVariable> evaluateAsync(String expression) {
        return this.evaluateAsync(expression, null);
    }

    public CompletableFuture<NIVariable> evaluateAsync(String expression, String resultName) {
        final String resultVarName = resultName != null ? resultName : expression;
        final CompletableFuture<NIVariable> result = new CompletableFuture<NIVariable>();
        NIVariable value = this.getVariables().get(expression);
        if (value != null) {
            result.complete(value);
            return result;
        }
        this.thread.getDebugger().send(new Command("-var-create --thread " + this.thread.getId() + " --frame " + this.level + " - * \"" + expression + "\""){

            @Override
            protected void onDone(MIRecord record) {
                MITList results = record.results();
                String varName = results.valueOf("name").asConst().value();
                MIValue typeValue = results.valueOf("type");
                String type = typeValue != null ? typeValue.asConst().value() : null;
                MIValue resultValue = results.valueOf("value");
                MIValue numchildValue = results.valueOf("numchild");
                int numChildren = numchildValue != null ? Integer.parseInt(numchildValue.asConst().value()) : CPPFrame.retrieveNumChildren(CPPFrame.this, varName);
                result.complete(new CPPVariable(CPPFrame.this, null, varName, resultVarName, type, resultValue, numChildren));
            }

            @Override
            protected void onError(MIRecord record) {
                String error = record.error();
                if (error.startsWith(CPPFrame.MI_ERROR)) {
                    error = error.substring(CPPFrame.MI_ERROR.length());
                    result.completeExceptionally((Throwable)new EvaluateException(error));
                }
            }
        });
        return result;
    }

    private static FrameDisplayer.DisplayedFrame createDisplayedFrame(NIFrame frame) {
        return FrameDisplayer.DisplayedFrame.newBuilder((String)CPPFrame.getDisplayName(frame)).description(CPPFrame.getDescription(frame)).line(frame.getLine()).sourceURISupplier(() -> CPPFrame.getSourceURI(frame)).build();
    }

    private static String getDisplayName(NIFrame frame) {
        int line;
        StringBuilder builder = new StringBuilder(frame.getFunctionName());
        String shortName = frame.getShortFileName();
        if (shortName != null) {
            builder.append("; ");
            builder.append(shortName);
        }
        if ((line = frame.getLine()) > 0) {
            builder.append(':');
            builder.append(line);
        }
        return builder.toString();
    }

    private static String getDescription(NIFrame frame) {
        int line;
        StringBuilder builder = new StringBuilder(frame.getFunctionName());
        String fullName = frame.getFullFileName();
        if (fullName != null) {
            builder.append("; ");
            builder.append(fullName);
        }
        if ((line = frame.getLine()) > 0) {
            builder.append(':');
            builder.append(line);
        }
        return builder.toString();
    }

    private static URI getSourceURI(NIFrame frame) {
        FileObject file;
        String fullFileName = frame.getFullFileName();
        if (fullFileName != null && !fullFileName.isEmpty() && (file = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(fullFileName)))) != null) {
            return file.toURI();
        }
        return null;
    }

    private static final class NIFrameImpl
    implements NIFrame {
        private final String threadId;
        private final int level;
        private final String address;
        private final String shortFileName;
        private final String fullFileName;
        private final String functionName;
        private final int line;

        NIFrameImpl(String threadId, MITList frame) {
            this.threadId = threadId;
            this.address = frame.getConstValue("addr");
            this.shortFileName = frame.valueOf("file") != null ? frame.valueOf("file").asConst().value() : null;
            this.functionName = frame.valueOf("func").asConst().value();
            this.fullFileName = frame.valueOf("fullname") != null ? frame.valueOf("fullname").asConst().value() : null;
            this.line = frame.valueOf("line") != null ? Integer.parseInt(frame.valueOf("line").asConst().value()) : -1;
            this.level = frame.valueOf("level") != null ? Integer.parseInt(frame.valueOf("level").asConst().value()) : 0;
        }

        public String getAddress() {
            return this.address;
        }

        public String getShortFileName() {
            return this.shortFileName;
        }

        public String getFullFileName() {
            return this.fullFileName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public int getLine() {
            return this.line;
        }

        public String getThreadId() {
            return this.threadId;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

