/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.StreamBoundException;
import nu.validator.servlet.DelegatingServletInputStream;

public final class InboundSizeLimitFilter
implements Filter {
    private long sizeLimit;

    public InboundSizeLimitFilter(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public InboundSizeLimitFilter() {
        this(Long.MAX_VALUE);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        chain.doFilter((ServletRequest)new RequestWrapper(request), res);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private ServletInputStream stream;

        public RequestWrapper(HttpServletRequest req) throws IOException {
            super(req);
            this.stream = null;
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.stream == null) {
                if ((long)super.getContentLength() > InboundSizeLimitFilter.this.sizeLimit) {
                    throw new StreamBoundException("Resource size exceeds limit.");
                }
                this.stream = new DelegatingServletInputStream(new BoundedInputStream((InputStream)super.getInputStream(), InboundSizeLimitFilter.this.sizeLimit, super.getHeader("Content-Location")));
            }
            return this.stream;
        }
    }
}

