/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.debug.CommentNode;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class CommentsNode
extends AbstractNode
implements OffsetProvider {
    private List<Comment> comments;

    public CommentsNode(String displayName, List<Comment> comments) {
        super((Children)new ChildrenImpl(comments));
        this.comments = comments;
        this.setDisplayName(displayName);
    }

    @Override
    public int getStart() {
        int start = Integer.MAX_VALUE;
        for (Comment c : this.comments) {
            if (start <= c.pos()) continue;
            start = c.pos();
        }
        return start == Integer.MAX_VALUE ? -1 : start;
    }

    @Override
    public int getEnd() {
        int end = -1;
        for (Comment c : this.comments) {
            if (end >= c.endPos()) continue;
            end = c.endPos();
        }
        return end;
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    private static final class ChildrenImpl
    extends Children.Keys {
        private List<Comment> comments;

        public ChildrenImpl(List<Comment> comments) {
            this.comments = comments;
        }

        public void addNotify() {
            this.setKeys(this.comments);
        }

        public void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        protected Node[] createNodes(Object key) {
            return new Node[]{new CommentNode((Comment)key)};
        }
    }
}

