/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.javascript.nodejs.ui.wizard.Bundle;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;

abstract class BaseWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    protected static final String NODEJS_PROJECT_ICON = "org/netbeans/modules/javascript/nodejs/ui/resources/new-nodejs-project.png";
    protected volatile WizardDescriptor wizardDescriptor;
    private int index;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;

    BaseWizardIterator() {
    }

    abstract String getWizardTitle();

    abstract WizardDescriptor.Panel<WizardDescriptor>[] createPanels();

    abstract String[] createSteps();

    abstract void uninitializeInternal();

    public final void initialize(WizardDescriptor wizard) {
        this.wizardDescriptor = wizard;
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                BaseWizardIterator.this.initialize();
            }
        });
    }

    final void initialize() {
        assert (EventQueue.isDispatchThread());
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            assert (steps[i] != null) : "Missing name for step: " + i;
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.setName(steps[i]);
        }
    }

    public final void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
        this.uninitializeInternal();
    }

    public final Set<FileObject> instantiate() throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        this.wizardDescriptor.putProperty("NewProjectWizard_Title", (Object)this.getWizardTitle());
        return this.panels[this.index];
    }

    public String name() {
        return Bundle.BaseWizardIterator_name(this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }
}

