/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassFishSettings;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.parser.DomainXMLChangeListener;
import org.netbeans.modules.glassfish.common.utils.ServerUtils;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.RegisteredDDCatalog;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.admin.CommandSetProperty;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.server.config.ConfigBuilderProvider;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbPreferences;
import org.openide.util.lookup.Lookups;

public final class GlassfishInstanceProvider
implements ServerInstanceProvider,
LookupListener {
    private static final Logger LOGGER = GlassFishLogger.get(GlassfishInstanceProvider.class);
    public static final String GLASSFISH_AUTOREGISTERED_INSTANCE = "glassfish_autoregistered_instance";
    private static final String AUTOINSTANCECOPIED = "autoinstance-copied";
    private static volatile GlassfishInstanceProvider glassFishProvider;
    public static final String EE6_DEPLOYER_FRAGMENT = "deployer:gfv3ee6";
    public static final String EE7_DEPLOYER_FRAGMENT = "deployer:gfv4ee7";
    public static final String EE8_DEPLOYER_FRAGMENT = "deployer:gfv5ee8";
    public static final String JAKARTAEE8_DEPLOYER_FRAGMENT = "deployer:gfv510ee8";
    public static final String JAKARTAEE9_DEPLOYER_FRAGMENT = "deployer:gfv6ee9";
    public static final String JAKARTAEE91_DEPLOYER_FRAGMENT = "deployer:gfv610ee9";
    public static final String JAKARTAEE10_DEPLOYER_FRAGMENT = "deployer:gfv700ee10";
    public static final String JAKARTAEE11_DEPLOYER_FRAGMENT = "deployer:gfv800ee11";
    public static final String EE6WC_DEPLOYER_FRAGMENT = "deployer:gfv3ee6wc";
    public static final String PRELUDE_DEPLOYER_FRAGMENT = "deployer:gfv3";
    private static String EE6_INSTANCES_PATH;
    private static String EE7_INSTANCES_PATH;
    private static String EE8_INSTANCES_PATH;
    private static String JAKARTAEE8_INSTANCES_PATH;
    private static String JAKARTAEE9_INSTANCES_PATH;
    private static String JAKARTAEE91_INSTANCES_PATH;
    private static String JAKARTAEE10_INSTANCES_PATH;
    private static String JAKARTAEE11_INSTANCES_PATH;
    private static String EE6WC_INSTANCES_PATH;
    public static String PRELUDE_DEFAULT_NAME;
    public static String EE6WC_DEFAULT_NAME;
    public static final Set<String> activeRegistrationSet;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private static final Set<String> activeDisplayNames;
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private final String[] instancesDirNames;
    private final String displayName;
    private final String[] uriFragments;
    private final boolean needsJdk6;
    private final List<String> noPasswordOptions;
    private final CommandFactory cf;
    private final Lookup.Result<RegisteredDDCatalog> lookupResult = Lookups.forPath((String)"Servers/GlassFish").lookupResult(RegisteredDDCatalog.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlassfishInstanceProvider getProvider() {
        if (glassFishProvider != null) {
            return glassFishProvider;
        }
        boolean runInit = false;
        Class<GlassfishInstanceProvider> clazz = GlassfishInstanceProvider.class;
        synchronized (GlassfishInstanceProvider.class) {
            if (glassFishProvider == null) {
                runInit = true;
                glassFishProvider = new GlassfishInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT, EE6WC_DEPLOYER_FRAGMENT, EE7_DEPLOYER_FRAGMENT, EE8_DEPLOYER_FRAGMENT, JAKARTAEE8_DEPLOYER_FRAGMENT, JAKARTAEE9_DEPLOYER_FRAGMENT, JAKARTAEE91_DEPLOYER_FRAGMENT, JAKARTAEE10_DEPLOYER_FRAGMENT, JAKARTAEE11_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH, EE6WC_INSTANCES_PATH, EE7_INSTANCES_PATH, EE8_INSTANCES_PATH, JAKARTAEE8_INSTANCES_PATH, JAKARTAEE9_INSTANCES_PATH, JAKARTAEE91_INSTANCES_PATH, JAKARTAEE10_INSTANCES_PATH, JAKARTAEE11_INSTANCES_PATH}, null, true, new String[]{"--nopassword"}, new CommandFactory(){

                    @Override
                    public CommandSetProperty getSetPropertyCommand(String property, String value) {
                        return new CommandSetProperty(property, value, "DEFAULT={0}={1}");
                    }
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (runInit) {
                glassFishProvider.init();
            }
            return glassFishProvider;
        }
    }

    private GlassfishInstanceProvider(String[] uriFragments, String[] instancesDirNames, String displayName, boolean needsJdk6, String[] noPasswordOptionsArray, CommandFactory cf) {
        this.instancesDirNames = instancesDirNames;
        this.displayName = displayName;
        this.uriFragments = uriFragments;
        this.needsJdk6 = needsJdk6;
        this.noPasswordOptions = new ArrayList<String>();
        if (null != noPasswordOptionsArray) {
            this.noPasswordOptions.addAll(Arrays.asList(noPasswordOptionsArray));
        }
        this.cf = cf;
        this.lookupResult.allInstances();
        this.lookupResult.addLookupListener((LookupListener)this);
    }

    public void resultChanged(LookupEvent ev) {
        LOGGER.log(Level.FINE, "***** resultChanged fired ********  {0}", this.hashCode());
        RegisteredDDCatalog catalog = GlassfishInstanceProvider.getDDCatalog();
        if (null != catalog) {
            catalog.registerEE6RunTimeDDCatalog(this);
        }
        GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, GlassfishInstanceProvider.getDDCatalog());
    }

    public static synchronized boolean initialized() {
        return glassFishProvider != null;
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookups.forPath((String)"Servers/GlassFish").lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(GlassfishInstanceProvider gip, RegisteredDDCatalog catalog) {
        GlassfishInstance firstInstance = gip.getFirstServerInstance();
        if (null != firstInstance) {
            catalog.refreshRunTimeDDCatalog(gip, firstInstance.getGlassfishRoot());
        }
    }

    public static ServerInstance getInstanceByUri(String uri) {
        return GlassfishInstanceProvider.getProvider().getInstance(uri);
    }

    public static GlassfishInstance getGlassFishInstanceByUri(String uri) {
        return GlassfishInstanceProvider.getProvider().getGlassfishInstance(uri);
    }

    private GlassfishInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlassfishInstance getGlassfishInstance(String uri) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            return this.instanceMap.get(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance si) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog catalog;
                this.instanceMap.put(si.getDeployerUri(), si);
                activeDisplayNames.add(si.getDisplayName());
                if (this.instanceMap.size() == 1 && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, si.getGlassfishRoot());
                }
                GlassfishInstance.writeInstanceToFile(si);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not store GlassFish server attributes", ex);
            }
        }
        if (!si.isRemote()) {
            DomainXMLChangeListener.registerListener(si);
        }
        this.support.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance si) {
        boolean result = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(si.getDeployerUri()) != null) {
                RegisteredDDCatalog catalog;
                result = true;
                this.removeInstanceFromFile(si.getDeployerUri());
                activeDisplayNames.remove(si.getDisplayName());
                if (this.instanceMap.isEmpty() && null != (catalog = GlassfishInstanceProvider.getDDCatalog())) {
                    catalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        GlassFishStatus.remove((GlassFishServer)si);
        if (result) {
            ConfigBuilderProvider.destroyBuilder((GlassFishServer)si);
            if (!si.isRemote()) {
                DomainXMLChangeListener.unregisterListener(si);
            }
            this.support.fireChange();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance instance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance gfInstance : this.instanceMap.values()) {
                if (!gfInstance.getCommonInstance().equals(instance)) continue;
                return gfInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String uri) {
        return this.instanceMap.get(uri);
    }

    public <T> T getInstanceByCapability(String uri, Class<T> serverFacadeClass) {
        Object result = null;
        GlassfishInstance instance = this.instanceMap.get(uri);
        if (instance != null) {
            result = instance.getLookup().lookup(serverFacadeClass);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> serverFacadeClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                Object serverFacade = instance.getLookup().lookup(serverFacadeClass);
                if (serverFacade == null) continue;
                result.add(serverFacade);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> result = new ArrayList<ServerInstance>();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance instance : this.instanceMap.values()) {
                ServerInstance si = instance.getCommonInstance();
                if (null != si) {
                    result.add(si);
                    continue;
                }
                String message = "invalid commonInstance for " + instance.getDeployerUri();
                LOGGER.log(Level.WARNING, message);
                if (null == instance.getDeployerUri()) continue;
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return result;
    }

    public void addChangeListener(ChangeListener listener) {
        this.support.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.support.removeChangeListener(listener);
    }

    public boolean hasServer(String uri) {
        return this.getInstance(uri) != null;
    }

    public ServerInstance getInstance(String uri) {
        ServerInstance rv = null;
        GlassfishInstance instance = this.instanceMap.get(uri);
        if (null != instance && null == (rv = instance.getCommonInstance())) {
            String message = "invalid commonInstance for " + instance.getDeployerUri();
            LOGGER.log(Level.WARNING, message);
            if (null != instance.getDeployerUri()) {
                this.instanceMap.remove(instance.getDeployerUri());
            }
        }
        return rv;
    }

    String getInstancesDirFirstName() {
        return this.instancesDirNames[0];
    }

    Collection<GlassfishInstance> getInternalInstances() {
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                this.loadServerInstances();
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            RegisteredDDCatalog catalog = GlassfishInstanceProvider.getDDCatalog();
            if (null != catalog) {
                catalog.registerEE6RunTimeDDCatalog(this);
                GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, catalog);
            }
        }
        for (GlassfishInstance gi : this.instanceMap.values()) {
            GlassfishInstance.updateModuleSupport(gi);
        }
    }

    private void loadServerInstances() {
        LinkedList<FileObject> installedInstances = new LinkedList<FileObject>();
        for (int j = 0; j < this.instancesDirNames.length; ++j) {
            FileObject[] instanceFOs;
            FileObject dir = ServerUtils.getRepositoryDir(this.instancesDirNames[j], false);
            if (dir == null || (instanceFOs = dir.getChildren()) == null || instanceFOs.length <= 0) continue;
            for (int i = 0; i < instanceFOs.length; ++i) {
                try {
                    if (instanceFOs[i].getName().startsWith(GLASSFISH_AUTOREGISTERED_INSTANCE)) {
                        installedInstances.add(instanceFOs[i]);
                        continue;
                    }
                    GlassfishInstance si = GlassfishInstance.readInstanceFromFile(instanceFOs[i], false);
                    if (si != null) {
                        activeDisplayNames.add(si.getDisplayName());
                        continue;
                    }
                    LOGGER.log(Level.FINER, "Unable to create glassfish instance for {0}", instanceFOs[i].getPath());
                    continue;
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
        }
        if (!installedInstances.isEmpty() && null == NbPreferences.forModule(this.getClass()).get(AUTOINSTANCECOPIED, null)) {
            try {
                for (FileObject installedInstance : installedInstances) {
                    GlassfishInstance igi = GlassfishInstance.readInstanceFromFile(installedInstance, true);
                    activeDisplayNames.add(igi.getDisplayName());
                }
                try {
                    NbPreferences.forModule(this.getClass()).put(AUTOINSTANCECOPIED, "true");
                    NbPreferences.forModule(this.getClass()).flush();
                }
                catch (BackingStoreException ex) {
                    LOGGER.log(Level.INFO, "auto-registered instance may reappear", ex);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private void removeInstanceFromFile(String url) {
        FileObject instanceFO = this.getInstanceFileObject(url);
        if (instanceFO != null && instanceFO.isValid()) {
            try {
                instanceFO.delete();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
    }

    private FileObject getInstanceFileObject(String url) {
        for (String instancesDirName : this.instancesDirNames) {
            FileObject dir = ServerUtils.getRepositoryDir(instancesDirName, false);
            if (dir == null) continue;
            FileObject[] installedServers = dir.getChildren();
            for (int i = 0; i < installedServers.length; ++i) {
                String val = ServerUtils.getStringAttribute(installedServers[i], "url");
                if (val == null || !val.equals(url) || installedServers[i].getName().startsWith(GLASSFISH_AUTOREGISTERED_INSTANCE)) continue;
                return installedServers[i];
            }
        }
        return null;
    }

    String[] getNoPasswordCreatDomainCommand(String startScript, String jarLocation, String domainDir, String portBase, String uname, String domain) {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.addAll(Arrays.asList(startScript, "-client", "-jar", jarLocation, "create-domain", "--user", uname, "--domaindir", domainDir));
        if (null != portBase) {
            retVal.add("--portbase");
            retVal.add(portBase);
        }
        if (this.noPasswordOptions.size() > 0) {
            retVal.addAll(this.noPasswordOptions);
        }
        retVal.add(domain);
        return (String[])retVal.toArray(String[]::new);
    }

    public CommandFactory getCommandFactory() {
        return this.cf;
    }

    static {
        EE6_INSTANCES_PATH = "/GlassFishEE6/Instances";
        EE7_INSTANCES_PATH = "/GlassFishEE7/Instances";
        EE8_INSTANCES_PATH = "/GlassFishEE8/Instances";
        JAKARTAEE8_INSTANCES_PATH = "/GlassFishJakartaEE8/Instances";
        JAKARTAEE9_INSTANCES_PATH = "/GlassFishJakartaEE9/Instances";
        JAKARTAEE91_INSTANCES_PATH = "/GlassFishJakartaEE91/Instances";
        JAKARTAEE10_INSTANCES_PATH = "/GlassFishJakartaEE10/Instances";
        JAKARTAEE11_INSTANCES_PATH = "/GlassFishJakartaEE11/Instances";
        EE6WC_INSTANCES_PATH = "/GlassFishEE6WC/Instances";
        PRELUDE_DEFAULT_NAME = "GlassFish_v3_Prelude";
        EE6WC_DEFAULT_NAME = "GlassFish_Server_3.1";
        GlassFishSettings.toolingLibraryconfig();
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
        activeDisplayNames = Collections.synchronizedSet(new HashSet());
    }
}

