/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.util.LinkedList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.debugger.jpda.projectsui.BreakpointAnnotationProvider;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    private final Line line;
    private final String type;
    private final Breakpoint breakpoint;

    DebuggerBreakpointAnnotation(String type, Line line, Breakpoint breakpoint) {
        this.type = type;
        this.line = line;
        this.breakpoint = breakpoint;
        this.attach((Annotatable)line);
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle;
        LinkedList<String> list = new LinkedList<String>();
        String condition = BreakpointAnnotationProvider.getCondition(this.breakpoint);
        if (!condition.trim().isEmpty()) {
            list.add(condition);
        }
        if (null != (hitCountFilteringStyle = this.breakpoint.getHitCountFilteringStyle())) {
            int hcf = this.breakpoint.getHitCountFilter();
            list.add(switch (hitCountFilteringStyle) {
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.EQUAL -> NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_HITCOUNT_EQUAL", (Object)hcf);
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER -> NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_HITCOUNT_GREATER", (Object)hcf);
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.MULTIPLE -> NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_HITCOUNT_MULTIPLE", (Object)hcf);
                default -> throw new IllegalStateException("Unknown HitCountFilteringStyle: " + hitCountFilteringStyle);
            });
        }
        String shortDesc = this.getShortDescriptionIntern();
        if (list.isEmpty()) {
            return shortDesc;
        }
        StringBuilder result = new StringBuilder();
        if (null != shortDesc) {
            result.append(shortDesc);
        }
        result.append("\n");
        result.append(NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_CONDITION"));
        for (String text : list) {
            result.append("\n");
            result.append(text);
        }
        return result.toString();
    }

    private String getShortDescriptionIntern() {
        if (this.type.endsWith("_broken")) {
            if (this.breakpoint.getValidity() == Breakpoint.VALIDITY.INVALID) {
                String msg = this.breakpoint.getValidityMessage();
                return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_BREAKPOINT_BROKEN_INVALID", (Object)msg);
            }
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_BREAKPOINT_BROKEN");
        }
        if (this.type.endsWith("_stroke")) {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_BREAKPOINT_STROKE");
        }
        if (this.type == "Breakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_BREAKPOINT");
        }
        if (this.type == "DisabledBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_BREAKPOINT");
        }
        if (this.type == "CondBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "DisabledCondBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_CONDITIONAL_BREAKPOINT");
        }
        if (this.type == "FieldBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_FIELD_BREAKPOINT");
        }
        if (this.type == "DisabledFieldBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_FIELD_BREAKPOINT");
        }
        if (this.type == "MethodBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_METHOD_BREAKPOINT");
        }
        if (this.type == "DisabledMethodBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_METHOD_BREAKPOINT");
        }
        if (this.type == "ClassBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_CLASS_BREAKPOINT");
        }
        if (this.type == "DisabledClassBreakpoint") {
            return NbBundle.getMessage(DebuggerBreakpointAnnotation.class, (String)"TOOLTIP_DISABLED_CLASS_BREAKPOINT");
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown breakpoint type '" + this.type + "'."));
        return null;
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

