/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.completion;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class JsfDocumentation
implements HelpResolver {
    private static final Logger LOGGER = Logger.getLogger(JsfDocumentation.class.getName());
    private static final JsfDocumentation SINGLETON = new JsfDocumentation();
    private static final String DOC_ZIP_FILE_NAME = "docs/jsf-api-docs.zip";
    private static URL DOC_ZIP_URL;
    private static final String JAVADOC_FOLDER_NAME = "javadocs/";
    private static Map<String, String> HELP_FILES_CACHE;

    public static JsfDocumentation getDefault() {
        return SINGLETON;
    }

    static URL getZipURL() {
        if (DOC_ZIP_URL == null) {
            File file = InstalledFileLocator.getDefault().locate(DOC_ZIP_FILE_NAME, null, false);
            if (file != null) {
                try {
                    URL url = Utilities.toURI((File)file).toURL();
                    DOC_ZIP_URL = FileUtil.getArchiveRoot((URL)url);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(JsfDocumentation.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                Logger.getAnonymousLogger().warning(String.format("Cannot locate the %s documentation file.", DOC_ZIP_FILE_NAME));
            }
        }
        return DOC_ZIP_URL;
    }

    public URL resolveLink(URL baseURL, String relativeLink) {
        String link;
        LOGGER.log(Level.FINE, "relativeLink = ''{0}''", relativeLink);
        LOGGER.log(Level.FINE, "baseURL = ''{0}''", baseURL);
        try {
            URI u = new URI(relativeLink);
            if (u.isAbsolute()) {
                LOGGER.log(Level.FINE, "resolved to = ''{0}''", u.toURL());
                return u.toURL();
            }
        }
        catch (MalformedURLException | URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        int javadocIndex = relativeLink.indexOf(JAVADOC_FOLDER_NAME);
        if (javadocIndex != -1) {
            relativeLink = relativeLink.substring(javadocIndex + JAVADOC_FOLDER_NAME.length());
        }
        if (relativeLink.startsWith("#")) {
            assert (baseURL != null) : "Base URL must be provided for local relative links (anchors).";
            String base = baseURL.toExternalForm();
            int hashIdx = base.indexOf(35);
            if (hashIdx != -1) {
                base = base.substring(0, hashIdx);
            }
            link = base + relativeLink;
        } else {
            if (baseURL != null) {
                URL url = this.getRelativeURL(baseURL, relativeLink);
                LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
                return url;
            }
            link = JsfDocumentation.getZipURL() + relativeLink;
        }
        try {
            URL url = new URI(link).toURL();
            LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
            return url;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            Logger.getLogger(JsfDocumentation.class.getName()).log(Level.INFO, null, ex);
            LOGGER.fine("cannot be resolved!");
            return null;
        }
    }

    private URL getRelativeURL(URL baseurl, String link) {
        URL newURL;
        if (link.startsWith("./")) {
            link = link.substring(2);
        }
        Object url = baseurl.toString();
        if (link.trim().charAt(0) == '#') {
            int index = ((String)url).indexOf(35);
            if (index > -1) {
                url = ((String)url).substring(0, ((String)url).indexOf(35));
            }
            url = (String)url + link;
        } else {
            int index = 0;
            url = ((String)url).substring(0, ((String)url).lastIndexOf(47));
            while ((index = link.indexOf("../", index)) > -1) {
                url = ((String)url).substring(0, ((String)url).lastIndexOf(47));
                link = link.substring(index + 3);
            }
            url = (String)url + "/" + link;
        }
        try {
            newURL = new URL((String)url);
        }
        catch (MalformedURLException e) {
            Logger.getLogger(JsfDocumentation.class.getName()).log(Level.INFO, null, e);
            return null;
        }
        return newURL;
    }

    public String getHelpContent(URL url) {
        return JsfDocumentation.getContentAsString(url, null);
    }

    static String getContentAsString(URL url, Charset charset) {
        String filePath = url.getPath();
        String cachedContent = HELP_FILES_CACHE.get(filePath);
        if (cachedContent != null) {
            return cachedContent;
        }
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            int read;
            URLConnection con = url.openConnection();
            con.connect();
            InputStreamReader r = new InputStreamReader((InputStream)new BufferedInputStream(con.getInputStream()), charset);
            char[] buf = new char[2048];
            StringBuilder content = new StringBuilder();
            while ((read = r.read(buf)) != -1) {
                content.append(buf, 0, read);
            }
            ((Reader)r).close();
            String strContent = content.toString();
            HELP_FILES_CACHE.put(filePath, strContent);
            return strContent;
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.log(Level.INFO, "Document at this link is not available: {0}", filePath);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return null;
    }

    static {
        HELP_FILES_CACHE = new WeakHashMap<String, String>();
    }
}

