/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.javaee.specs.support.api.JaxRsStackSupport;
import org.netbeans.modules.websvc.api.support.SourceGroups;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.spi.MiscUtilities;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.wizard.AbstractJaxRsFeatureIterator;
import org.netbeans.modules.websvc.rest.wizard.HttpMethodsPanel;
import org.netbeans.modules.websvc.rest.wizard.RestFilterPanel;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class OriginResourceIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final String CLASS = ".class";
    private static final String CONTAINER_CONTAINER_RESPONSE = "com.sun.jersey.spi.container.ContainerResponse";
    private static final String CONTAINER_CONTAINER_REQUEST = "com.sun.jersey.spi.container.ContainerRequest";
    private static final String CONTAINER_RESPONSE_FILTER = "com.sun.jersey.spi.container.ContainerResponseFilter";
    private WizardDescriptor myWizard;
    private WizardDescriptor.Panel[] myPanels;
    private WizardDescriptor.Panel myRestFilterPanel;
    private int myIndex;

    public Set instantiate() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void initialize(WizardDescriptor wizard) {
        WizardDescriptor.Panel panel;
        this.myWizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        SourceGroup[] sourceGroups = SourceGroups.getJavaSourceGroups((Project)project);
        this.myRestFilterPanel = new RestFilterPanel(wizard);
        if (sourceGroups.length == 0) {
            SourceGroup[] genericSourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            panel = Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])genericSourceGroups).bottomPanel(this.myRestFilterPanel).create();
        } else {
            panel = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])sourceGroups, (WizardDescriptor.Panel)this.myRestFilterPanel, (boolean)true);
        }
        this.myPanels = new WizardDescriptor.Panel[]{panel};
        this.setSteps();
    }

    public void uninitialize(WizardDescriptor arg0) {
        this.myPanels = null;
    }

    public void addChangeListener(ChangeListener arg0) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.myPanels[this.myIndex];
    }

    public boolean hasNext() {
        return this.myIndex < this.myPanels.length - 1;
    }

    public boolean hasPrevious() {
        return this.myIndex > 0;
    }

    public String name() {
        return null;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.myIndex;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.myIndex;
    }

    public void removeChangeListener(ChangeListener arg0) {
    }

    public Set instantiate(ProgressHandle handle) throws IOException {
        boolean hasJaxRs2;
        handle.start();
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.myWizard);
        String filterName = Templates.getTargetName((WizardDescriptor)this.myWizard);
        FileObject filterClass = GenerationUtils.createClass((FileObject)dir, (String)filterName, null);
        Project project = Templates.getProject((WizardDescriptor)this.myWizard);
        RestSupport support = (RestSupport)project.getLookup().lookup(RestSupport.class);
        boolean bl = hasJaxRs2 = support.isEE7() || support.hasJersey2(true);
        if (!hasJaxRs2) {
            this.extendClasspath(handle, support);
            hasJaxRs2 = support.hasJersey2(false);
        }
        handle.progress(NbBundle.getMessage(OriginResourceIterator.class, (String)"MSG_GenerateClassFilter"));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)filterClass);
        if (javaSource != null) {
            String fqn = this.generateFilter(javaSource, hasJaxRs2);
            handle.progress(NbBundle.getMessage(OriginResourceIterator.class, (String)"MSG_UpdateDescriptor"));
            if (!hasJaxRs2) {
                assert (fqn != null);
                if (support.isEE6() && support.hasJersey1(true) && "ide".equals(support.getProjectProperty("rest.config.type"))) {
                    List apps = support.getRestApplications();
                    if (apps.size() > 0) {
                        MiscUtilities.addCORSFilter((RestSupport)support, (String)((RestApplication)apps.get(0)).getApplicationClass(), (String)fqn);
                    }
                } else {
                    MiscUtilities.addInitParam((RestSupport)support, (String)"com.sun.jersey.spi.container.ContainerResponseFilters", (String)fqn);
                }
            }
        }
        return Collections.singleton(filterClass);
    }

    private String generateFilter(JavaSource javaSource, boolean hasJaxRs2) throws IOException {
        if (hasJaxRs2) {
            this.generateJaxRs20Filter(javaSource);
            return null;
        }
        return this.generateJerseyFilter(javaSource);
    }

    private void generateJaxRs20Filter(JavaSource javaSource) throws IOException {
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy copy) throws Exception {
                ClassTree classTree;
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree newTree = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                TreeMaker treeMaker = copy.getTreeMaker();
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)copy);
                AnnotationTree provider = genUtils.createAnnotation("javax.ws.rs.ext.Provider");
                newTree = genUtils.addAnnotation(newTree, provider);
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put("requestContext", "javax.ws.rs.container.ContainerRequestContext");
                params.put("response", "javax.ws.rs.container.ContainerResponseContext");
                newTree = genUtils.addImplementsClause(newTree, "javax.ws.rs.container.ContainerResponseFilter");
                MethodTree method = AbstractJaxRsFeatureIterator.createMethod(genUtils, treeMaker, "filter", params, OriginResourceIterator.this.getFilterBody(false));
                newTree = treeMaker.addClassMember(newTree, (Tree)method);
                copy.rewrite((Tree)classTree, (Tree)newTree);
            }
        }).commit();
    }

    private String generateJerseyFilter(JavaSource javaSource) throws IOException {
        final String[] fqn = new String[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy copy) throws Exception {
                copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
                fqn[0] = JavaSourceHelper.getTopLevelClassElement((CompilationController)copy).getQualifiedName().toString();
                TreeMaker maker = copy.getTreeMaker();
                ClassTree newTree = maker.addClassImplementsClause(classTree, (Tree)maker.QualIdent(OriginResourceIterator.CONTAINER_RESPONSE_FILTER));
                ArrayList<VariableTree> params = new ArrayList<VariableTree>(2);
                ModifiersTree paramModifiers = maker.Modifiers(Collections.emptySet());
                params.add(maker.Variable(paramModifiers, (CharSequence)"request", (Tree)maker.QualIdent(OriginResourceIterator.CONTAINER_CONTAINER_REQUEST), null));
                params.add(maker.Variable(paramModifiers, (CharSequence)"response", (Tree)maker.QualIdent(OriginResourceIterator.CONTAINER_CONTAINER_RESPONSE), null));
                MethodTree method = maker.Method(maker.Modifiers(EnumSet.of(Modifier.PUBLIC), Collections.singletonList(maker.Annotation((Tree)maker.QualIdent(Override.class.getName()), Collections.emptyList()))), (CharSequence)"filter", (Tree)maker.QualIdent(OriginResourceIterator.CONTAINER_CONTAINER_RESPONSE), Collections.emptyList(), params, Collections.emptyList(), OriginResourceIterator.this.getFilterBody(true), null);
                newTree = maker.addClassMember(newTree, (Tree)method);
                copy.rewrite((Tree)classTree, (Tree)newTree);
            }
        }).commit();
        return fqn[0];
    }

    private boolean extendClasspath(ProgressHandle handle, RestSupport support) throws IOException {
        Project project = Templates.getProject((WizardDescriptor)this.myWizard);
        if (support != null) {
            boolean hasRequest = RestUtils.hasClass(project, CONTAINER_CONTAINER_REQUEST.replace('.', '/') + CLASS);
            boolean hasFilter = RestUtils.hasClass(project, CONTAINER_RESPONSE_FILTER.replace('.', '/') + CLASS);
            boolean hasResponse = RestUtils.hasClass(project, CONTAINER_CONTAINER_RESPONSE.replace('.', '/') + CLASS);
            if (!(hasRequest && hasFilter && hasResponse)) {
                handle.progress(NbBundle.getMessage(OriginResourceIterator.class, (String)"MSG_ExtendsClasspath"));
                JaxRsStackSupport jaxRsSupport = support.getJaxRsStackSupport();
                if (jaxRsSupport == null) {
                    jaxRsSupport = JaxRsStackSupport.getDefault();
                }
                jaxRsSupport.extendsJerseyProjectClasspath(project);
                return true;
            }
        }
        return false;
    }

    private String getFilterBody(boolean isJersey) {
        String headers = isJersey ? "response.getHttpHeaders()" : "response.getHeaders()";
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        builder.append(headers);
        builder.append(".putSingle(\"Access-Control-Allow-Origin\",\"");
        builder.append(this.myWizard.getProperty("origin"));
        builder.append("\");");
        builder.append(headers);
        builder.append(".putSingle(\"Access-Control-Allow-Methods\",\"");
        List methods = (List)this.myWizard.getProperty("http-methods");
        for (HttpMethodsPanel.HttpMethods httpMethod : methods) {
            builder.append(httpMethod.toString().toUpperCase(Locale.ENGLISH));
            builder.append(", ");
        }
        if (!methods.isEmpty()) {
            builder.delete(builder.length() - 2, builder.length());
        }
        builder.append("\");");
        builder.append(headers);
        builder.append(".putSingle(\"Access-Control-Allow-Headers\",\"");
        builder.append(this.myWizard.getProperty("headers"));
        builder.append("\");");
        if (isJersey) {
            builder.append("return response;");
        }
        builder.append('}');
        return builder.toString();
    }

    private void setSteps() {
        Object contentData = this.myWizard.getProperty("WizardPanel_contentData");
        if (contentData instanceof String[]) {
            String[] steps = (String[])contentData;
            steps[steps.length - 1] = NbBundle.getMessage(OriginResourceIterator.class, (String)"TXT_ConfigureFilter");
            for (int i = 0; i < this.myPanels.length; ++i) {
                WizardDescriptor.Panel panel = this.myPanels[i];
                JComponent component = (JComponent)panel.getComponent();
                component.putClientProperty("WizardPanel_contentData", steps);
                component.putClientProperty("WizardPanel_contentSelectedIndex", i);
            }
        }
    }
}

