/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.classpath.AbstractBootPathImpl;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;

public class PlatformModulesPathImpl
extends AbstractBootPathImpl {
    private static final String PROTOCOL_NBJRT = "nbjrt";
    private static final Logger LOGGER = Logger.getLogger(PlatformModulesPathImpl.class.getName());

    public PlatformModulesPathImpl(NbMavenProjectImpl project) {
        super(project);
    }

    @Override
    protected List<PathResourceImplementation> createResources() {
        ArrayList<PathResourceImplementation> res = new ArrayList<PathResourceImplementation>();
        JavaPlatform pf = this.findActivePlatform();
        Arrays.stream(new JavaPlatform[]{this.findActivePlatform()}).flatMap(plat -> plat.getBootstrapLibraries().entries().stream()).map(entry -> entry.getURL()).filter(root -> PROTOCOL_NBJRT.equals(root.getProtocol())).forEach(root -> res.add(ClassPathSupport.createResource((URL)root)));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "PlatformModulesPath for project {0} and platform {1}", new Object[]{this.project.getProjectDirectory().getPath(), pf.getDisplayName()});
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            StringBuilder sb = new StringBuilder();
            Iterator it = res.iterator();
            while (it.hasNext()) {
                sb.append(it.next());
                if (!it.hasNext()) continue;
                sb.append("\n");
            }
            LOGGER.log(Level.FINER, sb.toString());
        }
        return res;
    }
}

