/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.ModelList;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.queries.Bundle;
import org.netbeans.modules.maven.queries.MavenDependenciesImplementation;
import org.netbeans.modules.project.dependency.ArtifactSpec;
import org.netbeans.modules.project.dependency.DependencyResult;
import org.netbeans.modules.project.dependency.ProjectScopes;
import org.netbeans.modules.project.dependency.Scope;
import org.netbeans.modules.project.dependency.SourceLocation;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

class MavenDependencyResult
implements DependencyResult,
ProjectScopes,
PropertyChangeListener {
    final Project ideProject;
    final NbMavenProject mavenProject;
    final org.netbeans.modules.project.dependency.Dependency rootNode;
    final Collection<Scope> scopes;
    final Collection<ArtifactSpec> problems;
    PropertyChangeListener wL;
    volatile Model effectiveModel;
    Map<FileObject, StyledDocument> openedPoms = new HashMap<FileObject, StyledDocument>();
    private List<ChangeListener> listeners;
    private List<ChangeListener> sourceListeners;
    private Map<FileObject, DW> documentWatchers = new HashMap<FileObject, DW>();
    private volatile boolean valid;

    public MavenDependencyResult(MavenProject proj, org.netbeans.modules.project.dependency.Dependency rootNode, Collection<Scope> scopes, Collection<ArtifactSpec> problems, Project project, NbMavenProject mavenProject) {
        this.ideProject = project;
        this.mavenProject = mavenProject;
        this.rootNode = rootNode;
        this.scopes = scopes;
        this.problems = problems;
    }

    public ProjectScopes getScopes() {
        return this;
    }

    public Collection<? extends Scope> scopes() {
        return MavenDependenciesImplementation.scope2Maven.keySet();
    }

    public Collection<? extends Scope> implies(Scope s, boolean direct) {
        return (direct ? MavenDependenciesImplementation.directScopes : MavenDependenciesImplementation.impliedScopes).getOrDefault(s, Collections.emptySet());
    }

    public Collection<FileObject> getDependencyFiles() {
        File file = this.mavenProject.getMavenProject().getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(FileUtil.toFileObject((File)file));
    }

    public Project getProject() {
        return this.ideProject;
    }

    public Collection<ArtifactSpec> getProblemArtifacts() {
        return Collections.unmodifiableCollection(this.problems);
    }

    public org.netbeans.modules.project.dependency.Dependency getRoot() {
        return this.rootNode;
    }

    public boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener l) {
        boolean attach = false;
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            if (this.listeners == null) {
                attach = true;
                this.listeners = new ArrayList<ChangeListener>();
                this.wL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.mavenProject);
                this.mavenProject.addPropertyChangeListener(this.wL);
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener l) {
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(l);
            if (this.listeners.isEmpty()) {
                this.mavenProject.removePropertyChangeListener(this.wL);
                this.listeners = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ArrayList<ChangeListener> ll;
        if (!"MavenProject".equals(evt.getPropertyName())) {
            return;
        }
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            this.valid = false;
            if (this.listeners == null || this.listeners.isEmpty()) {
                return;
            }
            ll = new ArrayList<ChangeListener>(this.listeners);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSourceChangeListener(ChangeListener l) {
        FileObject fo;
        boolean attach = false;
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            if (this.sourceListeners == null) {
                this.sourceListeners = new ArrayList<ChangeListener>();
                attach = true;
            }
            this.sourceListeners.add(l);
        }
        if (attach && (fo = FileUtil.toFileObject((File)this.mavenProject.getMavenProject().getFile())) != null) {
            this.addDocumentWatcher(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSourceChangeListener(ChangeListener l) {
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            if (this.sourceListeners == null || this.sourceListeners.isEmpty()) {
                return;
            }
        }
    }

    public String toString() {
        return "Depdenencies for " + this.getRoot().getArtifact() + " " + this.scopes.toString();
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocumentWatcher(FileObject f) {
        DW dw;
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            if (f == null || this.documentWatchers.containsKey(f)) {
                return;
            }
        }
        EditorCookie cake = (EditorCookie)f.getLookup().lookup(EditorCookie.class);
        StyledDocument doc = null;
        if (cake != null) {
            doc = cake.getDocument();
        }
        MavenDependencyResult mavenDependencyResult2 = this;
        synchronized (mavenDependencyResult2) {
            if (this.documentWatchers.containsKey(f)) {
                return;
            }
            dw = new DW(f, doc);
            this.documentWatchers.put(f, dw);
        }
        if (doc != null) {
            doc.addDocumentListener((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)dw, (Object)doc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void documentChanged(FileObject f) {
        ChangeListener[] ll;
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            this.effectiveModel = null;
            if (this.sourceListeners == null || this.sourceListeners.isEmpty()) {
                return;
            }
            ll = this.sourceListeners.toArray(new ChangeListener[0]);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener l : ll) {
            l.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceLocation getDeclarationRange(org.netbeans.modules.project.dependency.Dependency dep, String part) throws IOException {
        DependencyNode pd;
        if (this.effectiveModel == null) {
            ModelBuildingResult res;
            FileObject fo = FileUtil.toFileObject((File)this.mavenProject.getMavenProject().getFile());
            this.addDocumentWatcher(fo);
            try {
                res = EmbedderFactory.getProjectEmbedder().executeModelBuilder(this.mavenProject.getMavenProject().getFile());
            }
            catch (ModelBuildingException ex) {
                throw new IOException(Bundle.ERR_ModelBuildFailed(), ex);
            }
            MavenDependencyResult ex = this;
            synchronized (ex) {
                if (this.effectiveModel == null) {
                    this.effectiveModel = res.getEffectiveModel();
                }
            }
        }
        org.netbeans.modules.project.dependency.Dependency topLevel = null;
        org.netbeans.modules.project.dependency.Dependency search = dep;
        Dependency selected = null;
        if (part != null && !"container".equals(part)) {
            return null;
        }
        if (dep.getProjectData() instanceof DependencyNode && (pd = (DependencyNode)dep.getProjectData()) != this.rootNode.getProjectData() && pd.getParent() != this.rootNode.getProjectData()) {
            while ((pd = pd.getParent()).getParent() != this.rootNode.getProjectData()) {
            }
            List rootDeps = this.rootNode.getChildren();
            for (org.netbeans.modules.project.dependency.Dependency cd : rootDeps) {
                if (!MavenDependenciesImplementation.artifactEquals(cd.getArtifact(), pd.getArtifact())) continue;
                search = cd;
                topLevel = cd;
                break;
            }
        }
        if ("container".equals(part)) {
            InputLocation location = this.effectiveModel.getLocation((Object)"dependencies");
            if (location != null) {
                return this.fromInputLocation(location, topLevel);
            }
            FileObject pomFileObject = FileUtil.toFileObject((File)this.mavenProject.getMavenProject().getFile());
            ModelSource source = Utilities.createModelSource((FileObject)pomFileObject);
            POMModel model = POMModelFactory.getDefault().getModel(source);
            if (model == null) {
                return null;
            }
            org.netbeans.modules.maven.model.pom.Project project = model.getProject();
            for (ModelList ml : project.getChildren(ModelList.class)) {
                if (ml.getListClass() != org.netbeans.modules.maven.model.pom.Dependency.class || !"dependencies".equals(ml.getPeer().getNodeName())) continue;
                int from = ml.findPosition();
                int to = ml.findEndPosition();
                if (from == 0 && to == 0) {
                    from = -1;
                    to = -1;
                }
                return new SourceLocation(pomFileObject, from, to, null);
            }
            return this.fromInputLocation(this.effectiveModel.getLocation((Object)"dependencies"), topLevel);
        }
        for (Dependency d : this.effectiveModel.getDependencies()) {
            if (!MavenDependenciesImplementation.dependencyEquals(search, d)) continue;
            selected = d;
            break;
        }
        if (selected == null) {
            return null;
        }
        return this.fromInputLocation(selected.getLocation((Object)""), topLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StyledDocument openDocument(FileObject fo) throws IOException {
        StyledDocument d;
        if (fo == null) {
            return null;
        }
        MavenDependencyResult mavenDependencyResult = this;
        synchronized (mavenDependencyResult) {
            d = this.openedPoms.get(fo);
        }
        if (d == null) {
            DataObject dobj = DataObject.find((FileObject)fo);
            EditorCookie cake = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
            if (cake == null) {
                return null;
            }
            d = cake.openDocument();
            MavenDependencyResult mavenDependencyResult2 = this;
            synchronized (mavenDependencyResult2) {
                this.openedPoms.putIfAbsent(fo, d);
            }
        }
        return d;
    }

    private SourceLocation fromInputLocation(InputLocation l, Object topLevel) throws IOException {
        if (l == null) {
            return null;
        }
        InputSource s = l.getSource();
        String path = s.getLocation();
        FileObject fo = FileUtil.toFileObject((File)new File(path));
        StyledDocument d = this.openDocument(fo);
        LineDocument ld = (LineDocument)LineDocumentUtils.as((Document)d, LineDocument.class);
        if (ld == null) {
            return new SourceLocation(fo, -1, -1, topLevel);
        }
        int so = LineDocumentUtils.getLineStartFromIndex((LineDocument)ld, (int)(l.getLineNumber() - 1)) + l.getColumnNumber() - 1;
        int[] depStart = new int[]{so};
        int[] depEnd = new int[]{so};
        d.render(() -> {
            try {
                int end;
                int from = Math.max(0, so - 15);
                String text = ld.getText(from, ld.getLength() - from);
                int start = text.lastIndexOf("<dependency", so - from);
                if (start > -1) {
                    depStart[0] = start + from;
                }
                if ((end = text.indexOf("</dependency", so - from)) != -1) {
                    int end2 = text.indexOf(">", end += 10);
                    if (end2 > 0) {
                        end = end2 + 1;
                    }
                    depEnd[0] = end + from;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        });
        return new SourceLocation(fo, depStart[0], depEnd[0], topLevel);
    }

    class DW
    implements DocumentListener {
        final Document doc;
        final FileObject file;

        public DW(FileObject file, Document doc) {
            this.file = file;
            this.doc = doc;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MavenDependencyResult.this.documentChanged(this.file);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MavenDependencyResult.this.documentChanged(this.file);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

