/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.profiler.results.CCTNode;

public abstract class LockCCTNode
extends CCTNode {
    public static final LockCCTNode EMPTY = new LockCCTNode(null){

        @Override
        public LockCCTNode getChild(int index) {
            return null;
        }

        @Override
        public LockCCTNode[] getChildren() {
            return new LockCCTNode[0];
        }

        @Override
        public int getIndexOfChild(Object child) {
            return -1;
        }

        @Override
        public int getNChildren() {
            return 0;
        }

        @Override
        public String getNodeName() {
            return "";
        }

        @Override
        public long getTime() {
            return 0L;
        }

        @Override
        public double getTimeInPerCent() {
            return 0.0;
        }

        @Override
        public long getWaits() {
            return 0L;
        }
    };
    private List<LockCCTNode> children;
    private final LockCCTNode parent;

    LockCCTNode(LockCCTNode p) {
        this.parent = p;
    }

    @Override
    public LockCCTNode getChild(int index) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.get(index);
    }

    public LockCCTNode[] getChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.toArray(new LockCCTNode[0]);
    }

    @Override
    public int getIndexOfChild(Object child) {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.indexOf(child);
    }

    @Override
    public int getNChildren() {
        if (this.children == null) {
            this.computeChildrenImpl();
        }
        return this.children.size();
    }

    @Override
    public LockCCTNode getParent() {
        return this.parent;
    }

    void addChild(LockCCTNode child) {
        if (this.children == null) {
            this.children = new ArrayList<LockCCTNode>();
        }
        this.children.add(child);
    }

    void computeChildren() {
        this.children = new ArrayList<LockCCTNode>();
    }

    private void computeChildrenImpl() {
        this.computeChildren();
    }

    public double getTimeInPerCent() {
        LockCCTNode p = this.getParent();
        long allTime = p.getTime();
        double ppercent = p.getTimeInPerCent();
        long time = this.getTime();
        return ppercent * (double)time / (double)allTime;
    }

    public abstract String getNodeName();

    public abstract long getTime();

    public abstract long getWaits();

    public boolean isThreadLockNode() {
        return false;
    }

    public boolean isMonitorNode() {
        return false;
    }

    public String toString() {
        return this.getNodeName();
    }

    public void debug() {
        if (this.parent != null) {
            String offset = "";
            for (CCTNode p = this.parent; p != null; p = ((CCTNode)p).getParent()) {
                offset = offset + "  ";
            }
            System.out.println(offset + this.getNodeName() + " Waits: " + this.getWaits() + " Time: " + this.getTime() + " " + NumberFormat.getPercentInstance().format(this.getTimeInPerCent() / 100.0));
        }
        for (LockCCTNode ch : this.getChildren()) {
            if (!(ch instanceof LockCCTNode)) continue;
            ch.debug();
        }
    }
}

