/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.apisupport.project.ModuleDependency;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.ui.ActionFilterNode;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.Bundle;
import org.netbeans.modules.apisupport.project.ui.ImportantFilesNodeFactory;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.LibrariesSourceGroup;
import org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel;
import org.netbeans.modules.apisupport.project.ui.customizer.EditTestDependencyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SingleModuleProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.actions.CookieAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class UnitTestLibrariesNode
extends AbstractNode {
    private static final Logger LOG = Logger.getLogger(UnitTestLibrariesNode.class.getName());
    private final String testType;
    private final NbModuleProject project;
    private boolean missingJUnit4;

    UnitTestLibrariesNode(String testType, NbModuleProject project) {
        super((Children)new LibrariesChildren(testType, project), Lookups.fixed((Object[])new Object[]{project}));
        this.testType = testType;
        this.project = project;
        this.setName(testType);
        if (testType.equals("unit")) {
            this.setDisplayName(Bundle.LBL_unit_test_libraries());
        } else if (testType.equals("qa-functional")) {
            this.setDisplayName(Bundle.LBL_qa_functional_test_libraries());
        }
    }

    public Image getIcon(int type) {
        return this.getIcon(false);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(true);
    }

    private void setMissingJUnit4(boolean missingJUnit4) {
        this.missingJUnit4 = missingJUnit4;
        this.fireIconChange();
        this.fireOpenedIconChange();
        this.fireShortDescriptionChange(null, null);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/apisupport/project/ui/resources/libraries-badge.png", (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)ApisupportAntUIUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        if (this.missingJUnit4) {
            badge = ImageUtilities.loadImage((String)"org/netbeans/modules/java/api/common/project/ui/resources/brokenProjectBadge.gif", (boolean)true);
            img = ImageUtilities.mergeImages((Image)img, (Image)badge, (int)0, (int)0);
        }
        return img;
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>(2);
        if (this.missingJUnit4) {
            actions.add(new AddJUnit4Action(this.testType, this.project));
        }
        actions.add(new AddUnitTestDependencyAction(this.testType, this.project));
        return actions.toArray(new Action[0]);
    }

    public String getShortDescription() {
        if (this.missingJUnit4) {
            return Bundle.HINT_missing_junit4();
        }
        return null;
    }

    private static String createHtmlDescription(TestModuleDependency dep) {
        StringBuilder shortDesc = new StringBuilder("<html><u>" + dep.getModule().getCodeNameBase() + "</u><br>");
        if (dep.isTest()) {
            shortDesc.append("<br>").append(Bundle.CTL_test());
        }
        if (dep.isCompile()) {
            shortDesc.append("<br>").append(Bundle.CTL_compile());
        }
        if (dep.isRecursive()) {
            shortDesc.append("<br>").append(Bundle.CTL_recursive());
        }
        shortDesc.append("</html>");
        return shortDesc.toString();
    }

    private static final class LibrariesChildren
    extends Children.Keys<TestModuleDependency>
    implements AntProjectListener {
        static final Action REMOVE_DEPENDENCY_ACTION = new RemoveDependencyAction();
        private final String testType;
        private final NbModuleProject project;
        private ImageIcon librariesIcon;
        private boolean refreshScheduled = false;

        LibrariesChildren(String testType, NbModuleProject project) {
            this.testType = testType;
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
            super.removeNotify();
        }

        private void refreshKeys() {
            ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                            public Object run() throws Exception {
                                final TreeSet<TestModuleDependency> deps = new TreeSet<TestModuleDependency>(TestModuleDependency.CNB_COMPARATOR);
                                final AtomicBoolean missingJUnit4 = new AtomicBoolean(true);
                                Set<TestModuleDependency> tmds = new ProjectXMLManager(project).getTestDependencies(project.getModuleList()).get(testType);
                                if (tmds != null) {
                                    for (TestModuleDependency tmd : tmds) {
                                        deps.add(tmd);
                                        if (!tmd.getModule().getCodeNameBase().equals("org.netbeans.libs.junit4")) continue;
                                        missingJUnit4.set(false);
                                    }
                                }
                                ImportantFilesNodeFactory.getNodesSyncRP().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        ((UnitTestLibrariesNode)this.getNode()).setMissingJUnit4(missingJUnit4.get());
                                        this.setKeys(deps);
                                    }
                                });
                                return null;
                            }
                        });
                    }
                    catch (MutexException e) {
                        LOG.log(Level.INFO, null, e);
                    }
                }
            });
        }

        protected Node[] createNodes(TestModuleDependency dep) {
            Object node;
            ModuleEntry me = dep.getModule();
            File srcF = me.getSourceLocation();
            if (srcF == null) {
                File jarF = me.getJarLocation();
                URL jarRootURL = FileUtil.urlForArchiveOrDir((File)jarF);
                assert (jarRootURL != null);
                String name = me.getLocalizedName() + " - " + me.getCodeNameBase();
                Icon icon = this.getLibrariesIcon();
                FileObject root = URLMapper.findFileObject((URL)jarRootURL);
                if (root == null) {
                    LOG.log(Level.WARNING, "#195341: no FO for {0}", jarRootURL);
                    root = FileUtil.createMemoryFileSystem().getRoot();
                }
                ActionFilterNode pvNode = ActionFilterNode.create(PackageView.createPackageView((SourceGroup)new LibrariesSourceGroup(root, name, icon, icon)));
                node = new LibraryDependencyNode(dep, this.testType, this.project, (Node)pvNode);
            } else {
                node = new ProjectDependencyNode(dep, this.testType, this.project);
            }
            assert (node != null);
            return new Node[]{node};
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            if (this.project.getHelper().resolveFileObject("nbproject/project.xml") != null) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        this.refreshKeys();
                        refreshScheduled = false;
                    }
                };
                if (this.project.isRunInAtomicAction()) {
                    if (!this.refreshScheduled) {
                        this.refreshScheduled = true;
                        EventQueue.invokeLater(r);
                    }
                } else {
                    r.run();
                }
            }
        }

        public void propertiesChanged(AntProjectEvent ev) {
            LOG.log(Level.FINE, "propertiesChanged: {0}, expected: {1}", new Object[]{ev.getPath(), ev.isExpected()});
        }

        private Icon getLibrariesIcon() {
            if (this.librariesIcon == null) {
                this.librariesIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/apisupport/project/api/libraries.gif", (boolean)true);
            }
            return this.librariesIcon;
        }
    }

    private static class AddJUnit4Action
    extends AbstractAction {
        private final String testType;
        private final NbModuleProject project;
        private static final String JUNIT_MODULE = "org.netbeans.libs.junit4";
        private static final String NBJUNIT_MODULE = "org.netbeans.modules.nbjunit";

        AddJUnit4Action(String testType, NbModuleProject project) {
            super(Bundle.LBL_resolve_missing_junit4());
            this.testType = testType;
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModuleList moduleList;
            boolean addNBJUnit;
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.LBL_also_add_nbjunit_question(), Bundle.LBL_also_add_nbjunit_title()));
            if (result == NotifyDescriptor.NO_OPTION) {
                addNBJUnit = false;
            } else if (result == NotifyDescriptor.YES_OPTION) {
                addNBJUnit = true;
            } else {
                return;
            }
            try {
                moduleList = this.project.getModuleList();
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
                return;
            }
            try {
                AddJUnit4Action.resolveJUnitDependencies(this.project, moduleList, this.testType, addNBJUnit);
            }
            catch (IOException ex) {
                String msg = Exceptions.findLocalizedMessage((Throwable)ex);
                if (msg == null) {
                    msg = Bundle.LBL_cannot_resolve_missing_junit4();
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg, 0));
                return;
            }
            try {
                ProjectManager.getDefault().saveProject((Project)this.project);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private static void resolveJUnitDependencies(NbModuleProject project, ModuleList moduleList, String testType, boolean addNBJUnit) throws IOException {
            ModuleEntry junit4 = moduleList.getEntry(JUNIT_MODULE);
            if (junit4 == null) {
                IOException e = new IOException("no libs.junit4");
                Exceptions.attachLocalizedMessage((Throwable)e, (String)Bundle.ERR_could_not_find_junit4());
                throw e;
            }
            ModuleEntry nbjunit = moduleList.getEntry(NBJUNIT_MODULE);
            if (addNBJUnit && nbjunit == null) {
                IOException e = new IOException("no nbjunit");
                Exceptions.attachLocalizedMessage((Throwable)e, (String)Bundle.ERR_could_not_find_nbjunit());
                throw e;
            }
            ProjectXMLManager pxm = new ProjectXMLManager(project);
            pxm.addTestDependency(testType, new TestModuleDependency(junit4, false, false, true));
            if (addNBJUnit) {
                pxm.addTestDependency(testType, new TestModuleDependency(nbjunit, false, true, true));
            }
        }
    }

    static final class AddUnitTestDependencyAction
    extends AbstractAction {
        private final String testType;
        private final NbModuleProject project;

        AddUnitTestDependencyAction(String testType, NbModuleProject project) {
            if (testType.equals("unit")) {
                this.putValue("Name", Bundle.CTL_AddTestDependency_unit());
            } else if (testType.equals("qa-functional")) {
                this.putValue("Name", Bundle.CTL_AddTestDependency_qa_functional());
            }
            this.testType = testType;
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            SingleModuleProperties props = SingleModuleProperties.getInstance(this.project);
            final AddModulePanel addPanel = new AddModulePanel(props);
            String title = this.testType.equals("unit") ? Bundle.CTL_AddTestDependency_unit() : Bundle.CTL_AddTestDependency_qa_functional();
            DialogDescriptor descriptor = new DialogDescriptor((Object)addPanel, title);
            descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.AddModulePanel"));
            descriptor.setClosingOptions(new Object[0]);
            final Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            descriptor.setButtonListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DialogDescriptor.OK_OPTION.equals(e.getSource()) && addPanel.getSelectedDependencies().length == 0) {
                        return;
                    }
                    d.setVisible(false);
                    d.dispose();
                }
            });
            d.setVisible(true);
            if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                ModuleDependency[] newDeps = addPanel.getSelectedDependencies();
                ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                try {
                    for (int i = 0; i < newDeps.length; ++i) {
                        pxm.addTestDependency(this.testType, new TestModuleDependency(newDeps[i].getModuleEntry(), false, false, true));
                        ProjectManager.getDefault().saveProject((Project)this.project);
                    }
                }
                catch (Exception e) {
                    Exceptions.attachMessage((Throwable)e, (String)("Cannot add dependencies, probably IO error: " + Arrays.asList(newDeps)));
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            d.dispose();
        }
    }

    static final class EditTestDependencyAction
    extends AbstractAction {
        private final TestModuleDependency testDep;
        private final String testType;
        private final NbModuleProject project;

        EditTestDependencyAction(TestModuleDependency testDep, String testType, NbModuleProject project) {
            super(Bundle.CTL_EditDependency());
            this.testDep = testDep;
            this.testType = testType;
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            EditTestDependencyPanel editTestPanel = new EditTestDependencyPanel(this.testDep);
            DialogDescriptor descriptor = new DialogDescriptor((Object)editTestPanel, Bundle.CTL_EditModuleDependencyTitle(this.testDep.getModule().getLocalizedName()));
            descriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.apisupport.project.ui.customizer.EditTestDependencyPanel"));
            Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
            d.setVisible(true);
            if (descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                TestModuleDependency editedDep = editTestPanel.getEditedDependency();
                try {
                    ProjectXMLManager pxm = new ProjectXMLManager(this.project);
                    pxm.removeTestDependency(this.testType, this.testDep.getModule().getCodeNameBase());
                    pxm.addTestDependency(this.testType, editedDep);
                    ProjectManager.getDefault().saveProject((Project)this.project);
                }
                catch (IOException e) {
                    Exceptions.attachMessage((Throwable)e, (String)("Cannot store dependency: " + editedDep));
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
            d.dispose();
        }
    }

    static final class RemoveDependencyAction
    extends CookieAction {
        RemoveDependencyAction() {
        }

        protected void performAction(Node[] activatedNodes) {
            HashMap<NbModuleProject, HashSet<Pair<TestModuleDependency, Object>>> map = new HashMap<NbModuleProject, HashSet<Pair<TestModuleDependency, Object>>>();
            for (int i = 0; i < activatedNodes.length; ++i) {
                Lookup lkp = activatedNodes[i].getLookup();
                TestModuleDependency dep = (TestModuleDependency)lkp.lookup(TestModuleDependency.class);
                assert (dep != null);
                NbModuleProject project = (NbModuleProject)lkp.lookup(NbModuleProject.class);
                assert (project != null);
                String testType = (String)lkp.lookup(String.class);
                assert (testType != null);
                HashSet<Pair<TestModuleDependency, Object>> deps = (HashSet<Pair<TestModuleDependency, Object>>)map.get(project);
                if (deps == null) {
                    deps = new HashSet<Pair<TestModuleDependency, Object>>();
                    map.put(project, deps);
                }
                deps.add(new Pair<TestModuleDependency, Object>(dep, testType));
            }
            for (Map.Entry me : map.entrySet()) {
                NbModuleProject project = (NbModuleProject)me.getKey();
                ProjectXMLManager pxm = new ProjectXMLManager(project);
                for (Pair pair : (Set)me.getValue()) {
                    pxm.removeTestDependency((String)pair.second, ((TestModuleDependency)pair.first).getModule().getCodeNameBase());
                }
                try {
                    ProjectManager.getDefault().saveProject((Project)project);
                }
                catch (IOException e) {
                    Exceptions.attachMessage((Throwable)e, (String)"Problem during test dependencies removing");
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        }

        public String getName() {
            return Bundle.CTL_RemoveDependency();
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        protected boolean asynchronous() {
            return false;
        }

        protected int mode() {
            return 4;
        }

        protected Class<?>[] cookieClasses() {
            return new Class[]{TestModuleDependency.class, NbModuleProject.class};
        }
    }

    private static final class Pair<F, S> {
        public F first;
        public S second;

        Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }

    private static final class LibraryDependencyNode
    extends FilterNode {
        private final TestModuleDependency dep;
        private final String testType;
        private final NbModuleProject project;
        private Action[] actions;

        LibraryDependencyNode(TestModuleDependency dep, String testType, NbModuleProject project, Node original) {
            super(original, null, (Lookup)new ProxyLookup(new Lookup[]{original.getLookup(), Lookups.fixed((Object[])new Object[]{dep, project, testType})}));
            this.dep = dep;
            this.testType = testType;
            this.project = project;
        }

        public String getName() {
            return this.dep.getModule().getCodeNameBase();
        }

        public String getDisplayName() {
            return this.dep.getModule().getLocalizedName();
        }

        public String getShortDescription() {
            return UnitTestLibrariesNode.createHtmlDescription(this.dep);
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                LinkedHashSet<Action> result = new LinkedHashSet<Action>();
                result.add(new EditTestDependencyAction(this.dep, this.testType, this.project));
                Action[] superActions = super.getActions(false);
                for (int i = 0; i < superActions.length; ++i) {
                    if (!(superActions[i] instanceof FindAction)) continue;
                    result.add(superActions[i]);
                }
                result.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = result.toArray(new Action[0]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }

    private static final class ProjectDependencyNode
    extends AbstractNode {
        private final TestModuleDependency dep;
        private final String testType;
        private final NbModuleProject project;
        private Action[] actions;

        ProjectDependencyNode(TestModuleDependency dep, String testType, NbModuleProject project) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{dep, project, dep.getModule(), testType}));
            this.dep = dep;
            this.testType = testType;
            this.project = project;
            ModuleEntry me = dep.getModule();
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            this.setName(me.getCodeNameBase());
            this.setDisplayName(me.getLocalizedName());
            this.setShortDescription(UnitTestLibrariesNode.createHtmlDescription(dep));
        }

        public Action[] getActions(boolean context) {
            if (this.actions == null) {
                LinkedHashSet<Object> result = new LinkedHashSet<Object>();
                result.add(SystemAction.get(LibrariesNode.OpenProjectAction.class));
                result.add(new EditTestDependencyAction(this.dep, this.testType, this.project));
                result.add(LibrariesChildren.REMOVE_DEPENDENCY_ACTION);
                this.actions = result.toArray(new Action[0]);
            }
            return this.actions;
        }

        public Action getPreferredAction() {
            return this.getActions(false)[0];
        }
    }
}

