/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.BugtrackingOwnerSupport;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.IssuePrioritySupport;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.IssuePriorityInfo;
import org.netbeans.modules.bugtracking.spi.IssuePriorityProvider;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.IssueScheduleProvider;
import org.netbeans.modules.bugtracking.spi.IssueStatusProvider;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.team.spi.NBRepositoryProvider;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.openide.util.Utilities;

public final class RepositoryImpl<R, Q, I> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.Repository");
    public static final String EVENT_QUERY_LIST_CHANGED = "bugtracking.repository.queries.changed";
    public static final String EVENT_UNSUBMITTED_ISSUES_CHANGED = "bugtracking.repository.unsubmittedIssues.changed";
    public static final String EVENT_ATTRIBUTES_CHANGED = "bugtracking.repository.attributes.changed";
    public static final String ATTRIBUTE_URL = "repository.attribute.url";
    public static final String ATTRIBUTE_DISPLAY_NAME = "repository.attribute.displayName";
    private final PropertyChangeSupport support;
    private final RepositoryProvider<R, Q, I> repositoryProvider;
    private final IssueProvider<I> issueProvider;
    private final QueryProvider<Q, I> queryProvider;
    private final IssueStatusProvider<R, I> issueStatusProvider;
    private final IssueScheduleProvider<I> issueSchedulingProvider;
    private final IssuePriorityProvider<I> issuePriorityProvider;
    private final R r;
    private final WrapperMap<I, IssueImpl> issueMap = new WrapperMap<I, IssueImpl>(){

        @Override
        IssueImpl createWrapper(I d) {
            return new IssueImpl(RepositoryImpl.this, RepositoryImpl.this.issueProvider, d);
        }
    };
    private final WrapperMap<Q, QueryImpl> queryMap = new WrapperMap<Q, QueryImpl>(){

        @Override
        QueryImpl createWrapper(Q d) {
            return new QueryImpl(RepositoryImpl.this, RepositoryImpl.this.queryProvider, RepositoryImpl.this.issueProvider, d);
        }
    };
    private Repository repository;
    private IssuePrioritySupport prioritySupport;
    private final IssueFinder issueFinder;
    private int fakeIdCounter = 0;
    private boolean hasNumericIDs = true;
    private boolean hasNumericPrefix = true;
    private boolean hasNumericSufix = true;

    public RepositoryImpl(final R r, RepositoryProvider<R, Q, I> repositoryProvider, QueryProvider<Q, I> queryProvider, IssueProvider<I> issueProvider, IssueStatusProvider<R, I> issueStatusProvider, IssueScheduleProvider<I> issueSchedulingProvider, IssuePriorityProvider<I> issuePriorityProvider, IssueFinder issueFinder) {
        this.repositoryProvider = repositoryProvider;
        this.issueProvider = issueProvider;
        this.queryProvider = queryProvider;
        this.issueStatusProvider = issueStatusProvider;
        this.issueSchedulingProvider = issueSchedulingProvider;
        this.issuePriorityProvider = issuePriorityProvider;
        this.issueFinder = issueFinder;
        this.r = r;
        this.support = new PropertyChangeSupport(this);
        repositoryProvider.addPropertyChangeListener(r, new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (RepositoryImpl.EVENT_QUERY_LIST_CHANGED.equals(evt.getPropertyName())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "firing query list change {0} - rImpl: {1} - r: {2}", new Object[]{RepositoryImpl.this.getDisplayName(), this, r});
                    }
                    ArrayList<QueryImpl> queries = new ArrayList<QueryImpl>(RepositoryImpl.this.getQueries());
                    WrapperMap wrapperMap = RepositoryImpl.this.queryMap;
                    synchronized (wrapperMap) {
                        LinkedList toRemove = new LinkedList();
                        for (Map.Entry e : RepositoryImpl.this.queryMap.entrySet()) {
                            boolean contains = false;
                            for (QueryImpl q : queries) {
                                QueryImpl cachedQuery = (QueryImpl)((WeakReference)e.getValue()).get();
                                if (cachedQuery == null || !cachedQuery.isData(q.getData())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) continue;
                            toRemove.add(e.getKey());
                        }
                        RepositoryImpl.this.queryMap.keySet().removeAll(toRemove);
                    }
                    RepositoryImpl.this.fireQueryListChanged();
                } else if (RepositoryImpl.EVENT_UNSUBMITTED_ISSUES_CHANGED.equals(evt.getPropertyName())) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "firing unsubmitted issues change {0} - rImpl: {1} - r: {2}", new Object[]{RepositoryImpl.this.getDisplayName(), this, r});
                    }
                    RepositoryImpl.this.fireUnsubmittedIssuesChanged();
                }
            }
        });
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "created repository {0} - rImpl: {1} - r: {2}", new Object[]{this.getDisplayName(), this, r});
        }
    }

    public synchronized Repository getRepository() {
        if (this.repository == null) {
            this.repository = APIAccessor.IMPL.createRepository(this);
        }
        return this.repository;
    }

    public IssueFinder getIssueFinder() {
        return this.issueFinder;
    }

    public Image getIcon() {
        return this.repositoryProvider.getIcon(this.r);
    }

    public String getDisplayName() {
        RepositoryInfo info = this.repositoryProvider.getInfo(this.r);
        return info != null ? info.getDisplayName() : null;
    }

    public String getTooltip() {
        RepositoryInfo info = this.repositoryProvider.getInfo(this.r);
        return info != null ? info.getTooltip() : null;
    }

    public String getId() {
        return this.getInfo().getID();
    }

    public RepositoryInfo getInfo() {
        return this.repositoryProvider.getInfo(this.r);
    }

    public String getUrl() {
        return this.getInfo().getUrl();
    }

    public Collection<IssueImpl> getIssueImpls(String ... ids) {
        Collection<I> is = this.repositoryProvider.getIssues(this.r, ids);
        if (is == null || is.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(is.size());
        for (I i : is) {
            IssueImpl impl = this.getIssue(i);
            if (impl == null) continue;
            ret.add(impl);
        }
        return ret;
    }

    R getData() {
        return this.r;
    }

    public QueryImpl createNewQuery() {
        this.setLooseAssociation();
        return this.getQuery(this.repositoryProvider.createQuery(this.r));
    }

    public IssueImpl createNewIssue() {
        this.setLooseAssociation();
        I issueData = this.repositoryProvider.createIssue(this.r);
        return this.getIssue(issueData);
    }

    public IssueImpl createNewIssue(String summary, String description) {
        this.setLooseAssociation();
        I issueData = this.repositoryProvider.createIssue(this.r, summary, description);
        return this.getIssue(issueData);
    }

    public RepositoryProvider<R, Q, I> getProvider() {
        return this.repositoryProvider;
    }

    public Collection<IssueImpl> simpleSearch(String criteria) {
        Collection<I> issues = this.repositoryProvider.simpleSearch(this.r, criteria);
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(issues.size());
        for (I i : issues) {
            ret.add(this.getIssue(i));
        }
        return ret;
    }

    public Collection<QueryImpl> getQueries() {
        Collection<Q> queries = this.repositoryProvider.getQueries(this.r);
        ArrayList<QueryImpl> ret = new ArrayList<QueryImpl>(queries.size());
        for (Q q : queries) {
            ret.add(this.getQuery(q));
        }
        return ret;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    IssueStatusProvider<R, I> getStatusProvider() {
        return this.issueStatusProvider;
    }

    IssueScheduleProvider<I> getSchedulingProvider() {
        return this.issueSchedulingProvider;
    }

    IssuePriorityProvider<I> getPriorityProvider() {
        return this.issuePriorityProvider;
    }

    public IssuePriorityInfo[] getPriorityInfos() {
        return this.issuePriorityProvider != null ? this.issuePriorityProvider.getPriorityInfos() : new IssuePriorityInfo[]{};
    }

    String getPriorityName(I i) {
        return this.issuePriorityProvider != null ? this.getPrioritySupport().getName(this.issuePriorityProvider.getPriorityID(i)) : "";
    }

    Image getPriorityIcon(I i) {
        Image icon = null;
        if (this.issuePriorityProvider != null) {
            icon = this.getPrioritySupport().getIcon(this.issuePriorityProvider.getPriorityID(i));
        }
        if (icon == null) {
            icon = IssuePrioritySupport.getDefaultIcon();
        }
        return icon;
    }

    public void setIssueContext(I i, OwnerInfo info) {
        assert (this.repositoryProvider instanceof NBRepositoryProvider);
        if (this.repositoryProvider instanceof NBRepositoryProvider) {
            ((NBRepositoryProvider)this.repositoryProvider).setIssueOwnerInfo(i, info);
        }
    }

    public void setQueryContext(Q q, OwnerInfo info) {
        assert (this.repositoryProvider instanceof NBRepositoryProvider);
        if (this.repositoryProvider instanceof NBRepositoryProvider) {
            ((NBRepositoryProvider)this.repositoryProvider).setQueryOwnerInfo(q, info);
        }
    }

    void fireQueryListChanged() {
        this.support.firePropertyChange(EVENT_QUERY_LIST_CHANGED, null, null);
    }

    void fireAttributesChanged(Map<String, Object> oldAttributes, Map<String, Object> newAttributes) {
        LinkedList<String> equalAttributes = new LinkedList<String>();
        for (Map.Entry<String, Object> e : newAttributes.entrySet()) {
            String key = e.getKey();
            Object value = e.getValue();
            Object oldValue = oldAttributes.get(key);
            if ((value != null || oldValue != null) && (value == null || !value.equals(oldValue))) continue;
            equalAttributes.add(key);
        }
        for (String equalAttribute : equalAttributes) {
            if (oldAttributes != null) {
                oldAttributes.remove(equalAttribute);
            }
            newAttributes.remove(equalAttribute);
        }
        if (!newAttributes.isEmpty()) {
            this.support.firePropertyChange(new PropertyChangeEvent(this, EVENT_ATTRIBUTES_CHANGED, oldAttributes, newAttributes));
        }
    }

    public void applyChanges() {
        HashMap<String, Object> oldAttributes = this.createAttributesMap();
        this.repositoryProvider.getController(this.getData()).applyChanges();
        HashMap<String, Object> newAttributes = this.createAttributesMap();
        this.fireAttributesChanged(oldAttributes, newAttributes);
    }

    public void cancelChanges() {
        this.repositoryProvider.getController(this.getData()).cancelChanges();
    }

    private HashMap<String, Object> createAttributesMap() {
        HashMap<String, Object> attributes = new HashMap<String, Object>(2);
        if (this.getInfo() != null) {
            attributes.put(ATTRIBUTE_DISPLAY_NAME, this.getDisplayName());
            attributes.put(ATTRIBUTE_URL, this.getUrl());
        }
        return attributes;
    }

    public String getConnectorId() {
        return this.getInfo().getConnectorId();
    }

    public synchronized IssueImpl getIssue(I i) {
        return this.issueMap.getWrapper(i);
    }

    public QueryImpl getQuery(Q q) {
        return this.queryMap.getWrapper(q);
    }

    public boolean isTeamRepository() {
        return this.getInfo().getValue("team.project.name") != null;
    }

    public boolean isMutable() {
        DelegatingConnector dc = BugtrackingManager.getInstance().getConnector(this.getConnectorId());
        assert (dc != null);
        return dc.providesRepositoryManagement();
    }

    public boolean canAttachFiles() {
        return this.repositoryProvider.canAttachFiles(this.r);
    }

    public void remove() {
        RepositoryRegistry.getInstance().removeRepository(this);
        this.repositoryProvider.removed(this.r);
    }

    public RepositoryController getController() {
        return this.repositoryProvider.getController(this.r);
    }

    public Collection<IssueImpl> getUnsubmittedIssues() {
        Collection<I> issues;
        Collection<I> collection = issues = this.issueStatusProvider != null ? this.issueStatusProvider.getUnsubmittedIssues(this.r) : null;
        if (issues == null || issues.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(issues.size());
        for (I i : issues) {
            IssueImpl impl = this.getIssue(i);
            if (impl == null) continue;
            ret.add(impl);
        }
        return ret;
    }

    private void fireUnsubmittedIssuesChanged() {
        this.support.firePropertyChange(EVENT_UNSUBMITTED_ISSUES_CHANGED, null, null);
    }

    private synchronized IssuePrioritySupport getPrioritySupport() {
        if (this.prioritySupport == null) {
            this.prioritySupport = new IssuePrioritySupport(this.issuePriorityProvider.getPriorityInfos());
        }
        return this.prioritySupport;
    }

    private void setLooseAssociation() {
        BugtrackingOwnerSupport.getInstance().setLooseAssociation(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS, this);
    }

    String getNextFakeIssueID() {
        return this.getConnectorId() + "<=>" + this.getId() + "<=>" + --this.fakeIdCounter;
    }

    int compareID(String id1, String id2) {
        if (this.hasNumericIDs) {
            try {
                return this.compare(id1, id2);
            }
            catch (NumberFormatException e) {
                this.hasNumericIDs = false;
            }
        }
        int idx1 = id1.lastIndexOf("-");
        int idx2 = id2.lastIndexOf("-");
        if (idx1 > -1 && idx2 > -1) {
            if (this.hasNumericPrefix) {
                try {
                    int i = this.compare(this.getPrefix(id1, idx1), this.getPrefix(id2, idx2));
                    return i != 0 ? i : this.getSufix(id1, idx1).compareTo(this.getSufix(id2, idx2));
                }
                catch (NumberFormatException e) {
                    this.hasNumericPrefix = false;
                }
            } else if (this.hasNumericSufix) {
                try {
                    int i = this.getPrefix(id1, idx1).compareTo(this.getPrefix(id2, idx2));
                    return i != 0 ? i : this.compare(this.getSufix(id1, idx1), this.getSufix(id2, idx2));
                }
                catch (NumberFormatException e) {
                    this.hasNumericSufix = false;
                }
            }
        }
        return id1.compareTo(id2);
    }

    protected String getSufix(String id1, int idx1) {
        return id1.substring(idx1 + 1);
    }

    private String getPrefix(String id1, int idx1) {
        return id1.substring(0, idx1);
    }

    protected int compare(String id1, String id2) throws NumberFormatException {
        long l1 = Long.parseLong(id1);
        long l2 = Long.parseLong(id2);
        return Long.compare(l1, l2);
    }

    private abstract class WrapperMap<DATA, WRAPPER>
    extends HashMap<DATA, WeakReference<WRAPPER>> {
        private WrapperMap() {
        }

        public synchronized WRAPPER getWrapper(DATA d) {
            Object w;
            if (d == null) {
                return null;
            }
            WeakReference ref = (WeakReference)this.get(d);
            Object WRAPPER = w = ref != null ? (Object)ref.get() : null;
            if (w == null) {
                w = this.createWrapper(d);
                this.put(d, new MapReference(d, w));
            }
            return w;
        }

        public WeakReference<WRAPPER> get(DATA key, WRAPPER w) {
            return super.put(key, new MapReference(key, w));
        }

        abstract WRAPPER createWrapper(DATA var1);

        private class MapReference
        extends WeakReference<WRAPPER>
        implements Runnable {
            private final DATA key;

            public MapReference(DATA d, WRAPPER w) {
                super(w, Utilities.activeReferenceQueue());
                this.key = d;
            }

            @Override
            public void run() {
                WrapperMap.this.remove(this.key);
            }
        }
    }
}

