/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.findusages.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.ElementUtils;
import org.netbeans.modules.groovy.refactoring.findusages.model.MethodSignatureBuilder;
import org.netbeans.modules.groovy.refactoring.findusages.model.RefactoringElement;
import org.openide.filesystems.FileObject;

public class MethodRefactoringElement
extends RefactoringElement {
    private ClassNode methodType;

    public MethodRefactoringElement(FileObject fileObject, ASTNode node) {
        this(fileObject, node, null);
    }

    public MethodRefactoringElement(FileObject fileObject, ASTNode node, ClassNode methodType) {
        super(fileObject, node);
        this.methodType = methodType;
    }

    @Override
    public String getName() {
        return ElementUtils.getNameWithoutPackage((ASTNode)this.node);
    }

    @Override
    public ElementKind getKind() {
        if (this.node instanceof ConstructorNode || this.node instanceof ConstructorCallExpression) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    @Override
    public String getShowcase() {
        if (this.node instanceof ConstructorNode) {
            return this.getConstructorSignature((ConstructorNode)this.node);
        }
        if (this.node instanceof MethodNode) {
            return this.getMethodSignature((MethodNode)this.node);
        }
        if (this.node instanceof ConstructorCallExpression) {
            return this.getConstructorSignature((ConstructorCallExpression)this.node);
        }
        if (this.node instanceof MethodCallExpression) {
            return this.getMethodSignature((MethodCallExpression)this.node);
        }
        return "Should not happened - MethodRefactoringElement: getShowcase():85";
    }

    public String getMethodTypeName() {
        return this.methodType.getName();
    }

    public ClassNode getMethodType() {
        return this.methodType;
    }

    public List<String> getMethodParameters() {
        if (this.node instanceof MethodCallExpression) {
            return this.getParamTypes((MethodCallExpression)this.node);
        }
        if (this.node instanceof MethodNode) {
            return this.getParams((MethodNode)this.node);
        }
        assert (false) : "Weird class type found: " + this.node.getClass().getSimpleName();
        return Collections.emptyList();
    }

    private List<String> getParamTypes(MethodCallExpression methodCall) {
        ArgumentListExpression argumentList;
        Expression arguments = methodCall.getArguments();
        ArrayList<String> paramTypes = new ArrayList<String>();
        if (arguments instanceof ArgumentListExpression && (argumentList = (ArgumentListExpression)arguments).getExpressions().size() > 0) {
            for (Expression argument : argumentList.getExpressions()) {
                paramTypes.add(ElementUtils.getTypeName((ASTNode)argument.getType()));
            }
        }
        return paramTypes;
    }

    private List<String> getParams(MethodNode methodNode) {
        ArrayList<String> paramTypes = new ArrayList<String>();
        for (Parameter param : methodNode.getParameters()) {
            paramTypes.add(ElementUtils.getTypeName((ASTNode)param));
        }
        return paramTypes;
    }

    public void setMethodType(ClassNode methodType) {
        this.methodType = methodType;
    }

    private String getMethodSignature(MethodNode method) {
        MethodSignatureBuilder builder = new MethodSignatureBuilder();
        builder.appendMethodName(method);
        builder.appendMethodParams(method);
        builder.appendReturnType(method);
        return builder.toString();
    }

    private String getConstructorSignature(ConstructorNode constructor) {
        MethodSignatureBuilder builder = new MethodSignatureBuilder();
        builder.appendMethodName((MethodNode)constructor);
        builder.appendMethodParams((MethodNode)constructor);
        return builder.toString();
    }

    private String getConstructorSignature(ConstructorCallExpression constructorCall) {
        MethodSignatureBuilder builder = new MethodSignatureBuilder();
        builder.appendMethodName(constructorCall);
        builder.appendMethodParams((Expression)constructorCall);
        return builder.toString();
    }

    private String getMethodSignature(MethodCallExpression methodCall) {
        MethodSignatureBuilder builder = new MethodSignatureBuilder();
        builder.appendMethodName(methodCall);
        builder.appendMethodParams((Expression)methodCall);
        builder.appendReturnType(methodCall);
        return builder.toString();
    }
}

