// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/entity_type.proto

package dialogflowpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EntityTypes_ListEntityTypes_FullMethodName        = "/google.cloud.dialogflow.v2.EntityTypes/ListEntityTypes"
	EntityTypes_GetEntityType_FullMethodName          = "/google.cloud.dialogflow.v2.EntityTypes/GetEntityType"
	EntityTypes_CreateEntityType_FullMethodName       = "/google.cloud.dialogflow.v2.EntityTypes/CreateEntityType"
	EntityTypes_UpdateEntityType_FullMethodName       = "/google.cloud.dialogflow.v2.EntityTypes/UpdateEntityType"
	EntityTypes_DeleteEntityType_FullMethodName       = "/google.cloud.dialogflow.v2.EntityTypes/DeleteEntityType"
	EntityTypes_BatchUpdateEntityTypes_FullMethodName = "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntityTypes"
	EntityTypes_BatchDeleteEntityTypes_FullMethodName = "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntityTypes"
	EntityTypes_BatchCreateEntities_FullMethodName    = "/google.cloud.dialogflow.v2.EntityTypes/BatchCreateEntities"
	EntityTypes_BatchUpdateEntities_FullMethodName    = "/google.cloud.dialogflow.v2.EntityTypes/BatchUpdateEntities"
	EntityTypes_BatchDeleteEntities_FullMethodName    = "/google.cloud.dialogflow.v2.EntityTypes/BatchDeleteEntities"
)

// EntityTypesClient is the client API for EntityTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EntityTypesClient interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Creates an entity type in the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type entityTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewEntityTypesClient(cc grpc.ClientConnInterface) EntityTypesClient {
	return &entityTypesClient{cc}
}

func (c *entityTypesClient) ListEntityTypes(ctx context.Context, in *ListEntityTypesRequest, opts ...grpc.CallOption) (*ListEntityTypesResponse, error) {
	out := new(ListEntityTypesResponse)
	err := c.cc.Invoke(ctx, EntityTypes_ListEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) GetEntityType(ctx context.Context, in *GetEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_GetEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) CreateEntityType(ctx context.Context, in *CreateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_CreateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) UpdateEntityType(ctx context.Context, in *UpdateEntityTypeRequest, opts ...grpc.CallOption) (*EntityType, error) {
	out := new(EntityType)
	err := c.cc.Invoke(ctx, EntityTypes_UpdateEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) DeleteEntityType(ctx context.Context, in *DeleteEntityTypeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, EntityTypes_DeleteEntityType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntityTypes(ctx context.Context, in *BatchUpdateEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_BatchUpdateEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntityTypes(ctx context.Context, in *BatchDeleteEntityTypesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_BatchDeleteEntityTypes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchCreateEntities(ctx context.Context, in *BatchCreateEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_BatchCreateEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchUpdateEntities(ctx context.Context, in *BatchUpdateEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_BatchUpdateEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *entityTypesClient) BatchDeleteEntities(ctx context.Context, in *BatchDeleteEntitiesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EntityTypes_BatchDeleteEntities_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EntityTypesServer is the server API for EntityTypes service.
// All implementations should embed UnimplementedEntityTypesServer
// for forward compatibility
type EntityTypesServer interface {
	// Returns the list of all entity types in the specified agent.
	ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error)
	// Retrieves the specified entity type.
	GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error)
	// Creates an entity type in the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error)
	// Updates the specified entity type.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error)
	// Deletes the specified entity type.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error)
	// Updates/Creates multiple entity types in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [BatchUpdateEntityTypesResponse][google.cloud.dialogflow.v2.BatchUpdateEntityTypesResponse]
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateEntityTypes(context.Context, *BatchUpdateEntityTypesRequest) (*longrunningpb.Operation, error)
	// Deletes entity types in the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteEntityTypes(context.Context, *BatchDeleteEntityTypesRequest) (*longrunningpb.Operation, error)
	// Creates multiple new entities in the specified entity type.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchCreateEntities(context.Context, *BatchCreateEntitiesRequest) (*longrunningpb.Operation, error)
	// Updates or creates multiple entities in the specified entity type. This
	// method does not affect entities in the entity type that aren't explicitly
	// specified in the request.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchUpdateEntities(context.Context, *BatchUpdateEntitiesRequest) (*longrunningpb.Operation, error)
	// Deletes entities in the specified entity type.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	BatchDeleteEntities(context.Context, *BatchDeleteEntitiesRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEntityTypesServer should be embedded to have forward compatible implementations.
type UnimplementedEntityTypesServer struct {
}

func (UnimplementedEntityTypesServer) ListEntityTypes(context.Context, *ListEntityTypesRequest) (*ListEntityTypesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEntityTypes not implemented")
}
func (UnimplementedEntityTypesServer) GetEntityType(context.Context, *GetEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEntityType not implemented")
}
func (UnimplementedEntityTypesServer) CreateEntityType(context.Context, *CreateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEntityType not implemented")
}
func (UnimplementedEntityTypesServer) UpdateEntityType(context.Context, *UpdateEntityTypeRequest) (*EntityType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEntityType not implemented")
}
func (UnimplementedEntityTypesServer) DeleteEntityType(context.Context, *DeleteEntityTypeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEntityType not implemented")
}
func (UnimplementedEntityTypesServer) BatchUpdateEntityTypes(context.Context, *BatchUpdateEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateEntityTypes not implemented")
}
func (UnimplementedEntityTypesServer) BatchDeleteEntityTypes(context.Context, *BatchDeleteEntityTypesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteEntityTypes not implemented")
}
func (UnimplementedEntityTypesServer) BatchCreateEntities(context.Context, *BatchCreateEntitiesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateEntities not implemented")
}
func (UnimplementedEntityTypesServer) BatchUpdateEntities(context.Context, *BatchUpdateEntitiesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchUpdateEntities not implemented")
}
func (UnimplementedEntityTypesServer) BatchDeleteEntities(context.Context, *BatchDeleteEntitiesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDeleteEntities not implemented")
}

// UnsafeEntityTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EntityTypesServer will
// result in compilation errors.
type UnsafeEntityTypesServer interface {
	mustEmbedUnimplementedEntityTypesServer()
}

func RegisterEntityTypesServer(s grpc.ServiceRegistrar, srv EntityTypesServer) {
	s.RegisterService(&EntityTypes_ServiceDesc, srv)
}

func _EntityTypes_ListEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_ListEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).ListEntityTypes(ctx, req.(*ListEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_GetEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).GetEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_GetEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).GetEntityType(ctx, req.(*GetEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_CreateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).CreateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_CreateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).CreateEntityType(ctx, req.(*CreateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_UpdateEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_UpdateEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).UpdateEntityType(ctx, req.(*UpdateEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_DeleteEntityType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntityTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_DeleteEntityType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).DeleteEntityType(ctx, req.(*DeleteEntityTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_BatchUpdateEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntityTypes(ctx, req.(*BatchUpdateEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntityTypes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntityTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_BatchDeleteEntityTypes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntityTypes(ctx, req.(*BatchDeleteEntityTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchCreateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_BatchCreateEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchCreateEntities(ctx, req.(*BatchCreateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchUpdateEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_BatchUpdateEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchUpdateEntities(ctx, req.(*BatchUpdateEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EntityTypes_BatchDeleteEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EntityTypes_BatchDeleteEntities_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EntityTypesServer).BatchDeleteEntities(ctx, req.(*BatchDeleteEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EntityTypes_ServiceDesc is the grpc.ServiceDesc for EntityTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EntityTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.EntityTypes",
	HandlerType: (*EntityTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListEntityTypes",
			Handler:    _EntityTypes_ListEntityTypes_Handler,
		},
		{
			MethodName: "GetEntityType",
			Handler:    _EntityTypes_GetEntityType_Handler,
		},
		{
			MethodName: "CreateEntityType",
			Handler:    _EntityTypes_CreateEntityType_Handler,
		},
		{
			MethodName: "UpdateEntityType",
			Handler:    _EntityTypes_UpdateEntityType_Handler,
		},
		{
			MethodName: "DeleteEntityType",
			Handler:    _EntityTypes_DeleteEntityType_Handler,
		},
		{
			MethodName: "BatchUpdateEntityTypes",
			Handler:    _EntityTypes_BatchUpdateEntityTypes_Handler,
		},
		{
			MethodName: "BatchDeleteEntityTypes",
			Handler:    _EntityTypes_BatchDeleteEntityTypes_Handler,
		},
		{
			MethodName: "BatchCreateEntities",
			Handler:    _EntityTypes_BatchCreateEntities_Handler,
		},
		{
			MethodName: "BatchUpdateEntities",
			Handler:    _EntityTypes_BatchUpdateEntities_Handler,
		},
		{
			MethodName: "BatchDeleteEntities",
			Handler:    _EntityTypes_BatchDeleteEntities_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/entity_type.proto",
}
